/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.report.Container$;
import io.gatling.charts.util.Color;

public final class RequestCountPolarTemplate$
extends Template {
    public static final RequestCountPolarTemplate$ MODULE$ = new RequestCountPolarTemplate$();

    @Override
    public String js() {
        return "\nfunction numberOfRequestsDataForGroup(group) {\n  var data = {names: [], oks: [], kos: []};\n\n  $.each(group.contents, function(contentName, content) {\n    if (content.type == '" + Container$.MODULE$.Group() + "') {\n      var result = numberOfRequestsDataForGroup(content);\n      data.names = data.names.concat(result.names);\n      data.oks = data.oks.concat(result.oks);\n      data.kos = data.kos.concat(result.kos);\n    }\n    else if (content.type == '" + Container$.MODULE$.Request() + "') {\n      data.names.push(content.path);\n      data.oks.push(parseInt(content.stats.numberOfRequests.ok));\n      data.kos.push(parseInt(content.stats.numberOfRequests.ko));\n    }\n  });\n\n  return data;\n}\n\nvar numberOfRequestsData = numberOfRequestsDataForGroup(stats);\nvar tickInterval = Math.ceil(numberOfRequestsData.names.length / 1000);\n\nnew Highcharts.Chart({\n  chart: {\n    renderTo:'container_number_of_requests',\n    polar:true,\n    type:'column',\n    height:330\n  },\n  credits:{\n    enabled:false\n  },\n  title:{\n    text:'<span class=\"chart_title\">Number of requests</span>',\n    useHTML: true,\n    widthAdjust:-20\n  },\n  xAxis:{\n    tickmarkPlacement:'on',\n    tickInterval: tickInterval,\n    categories:numberOfRequestsData.names,\n    labels:{ enabled:false }\n  },\n  yAxis:{\n    min:0,\n    reversedStacks: false\n  },\n  plotOptions:{\n    series:{\n      stacking:'normal',\n      groupPadding:0,\n      pointPlacement:'on',\n      shadow: true\n    }\n  },\n  legend: {\n      borderWidth: 0,\n      itemStyle: { fontWeight: \"normal\" },\n      symbolRadius: 0\n  },\n  series:[\n      {\n      name:'OK',\n      data:numberOfRequestsData.oks,\n      color:\"" + Color.Requests$.MODULE$.Ok() + "\"\n    },\n    {\n      name:'KO',\n      data:numberOfRequestsData.kos,\n      color:\"" + Color.Requests$.MODULE$.Ko() + "\"\n    }\n  ]\n});\n";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema polar\">\n              <div id=\"container_number_of_requests\"></div>\n            </div>\n";
    }

    private RequestCountPolarTemplate$() {
    }
}

