/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.GroupRestriction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GroupRestrictionFluent<A extends GroupRestrictionFluent<A>>
extends BaseFluent<A> {
    private List<String> groups = new ArrayList<String>();
    private ArrayList<LabelSelectorBuilder> labels = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GroupRestrictionFluent() {
    }

    public GroupRestrictionFluent(GroupRestriction instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GroupRestriction instance) {
        GroupRestriction groupRestriction = instance = instance != null ? instance : new GroupRestriction();
        if (instance != null) {
            this.withGroups(instance.getGroups());
            this.withLabels(instance.getLabels());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)((Object)this);
    }

    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)((Object)this);
    }

    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromGroups(String ... items) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGroups(Collection<String> items) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public String getFirstGroup() {
        return this.groups.get(0);
    }

    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)((Object)this);
    }

    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove((Object)"groups");
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public A addToLabels(int index, LabelSelector item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        if (index < 0 || index >= this.labels.size()) {
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        } else {
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToLabels(int index, LabelSelector item) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        if (index < 0 || index >= this.labels.size()) {
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        } else {
            this._visitables.get((Object)"labels").add(builder);
            this.labels.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToLabels(LabelSelector ... items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToLabels(Collection<LabelSelector> items) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get((Object)"labels").add(builder);
            this.labels.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(LabelSelector ... items) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get((Object)"labels").remove(builder);
            this.labels.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLabels(Collection<LabelSelector> items) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get((Object)"labels").remove(builder);
            this.labels.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromLabels(Predicate<LabelSelectorBuilder> predicate) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        Iterator<LabelSelectorBuilder> each = this.labels.iterator();
        List visitables = this._visitables.get((Object)"labels");
        while (each.hasNext()) {
            LabelSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LabelSelector> buildLabels() {
        return this.labels != null ? GroupRestrictionFluent.build(this.labels) : null;
    }

    public LabelSelector buildLabel(int index) {
        return this.labels.get(index).build();
    }

    public LabelSelector buildFirstLabel() {
        return this.labels.get(0).build();
    }

    public LabelSelector buildLastLabel() {
        return this.labels.get(this.labels.size() - 1).build();
    }

    public LabelSelector buildMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.labels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLabels(List<LabelSelector> labels) {
        if (this.labels != null) {
            this._visitables.get((Object)"labels").clear();
        }
        if (labels != null) {
            this.labels = new ArrayList();
            for (LabelSelector item : labels) {
                this.addToLabels(item);
            }
        } else {
            this.labels = null;
        }
        return (A)((Object)this);
    }

    public A withLabels(LabelSelector ... labels) {
        if (this.labels != null) {
            this.labels.clear();
            this._visitables.remove((Object)"labels");
        }
        if (labels != null) {
            for (LabelSelector item : labels) {
                this.addToLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null && !this.labels.isEmpty();
    }

    public LabelsNested<A> addNewLabel() {
        return new LabelsNested(-1, null);
    }

    public LabelsNested<A> addNewLabelLike(LabelSelector item) {
        return new LabelsNested(-1, item);
    }

    public LabelsNested<A> setNewLabelLike(int index, LabelSelector item) {
        return new LabelsNested(index, item);
    }

    public LabelsNested<A> editLabel(int index) {
        if (this.labels.size() <= index) {
            throw new RuntimeException("Can't edit labels. Index exceeds size.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    public LabelsNested<A> editFirstLabel() {
        if (this.labels.size() == 0) {
            throw new RuntimeException("Can't edit first labels. The list is empty.");
        }
        return this.setNewLabelLike(0, this.buildLabel(0));
    }

    public LabelsNested<A> editLastLabel() {
        int index = this.labels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last labels. The list is empty.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    public LabelsNested<A> editMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!predicate.test(this.labels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching labels. No match found.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupRestrictionFluent that = (GroupRestrictionFluent)((Object)o);
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.labels, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(String.valueOf(this.groups) + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(String.valueOf(this.labels) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LabelsNested<N>
    extends LabelSelectorFluent<LabelsNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;
        int index;

        LabelsNested(int index, LabelSelector item) {
            this.index = index;
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)GroupRestrictionFluent.this.setToLabels(this.index, this.builder.build());
        }

        public N endLabel() {
            return this.and();
        }
    }
}

