/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class EncodingParser {
    private static final byte[] UTF_BOM_BYTES = "\ufeff".getBytes(StandardCharsets.UTF_8);
    private static final Pattern COMMENT_OR_EMPTY_LINE_PATTERN = Pattern.compile("^\\s*#|^\\s*$");
    private static final Pattern ENCODING_PATTERN = Pattern.compile("^\\s*#\\s*encoding\\s*:\\s*([0-9a-zA-Z\\-]+)", 2);
    private static final Pattern LINE_SPLIT_PATTERN = Pattern.compile("([^\\n\\r]+)[\\n\\r]");

    EncodingParser() {
    }

    static String readWithEncodingFromSource(byte[] source) {
        byte[] bomFreeSource = EncodingParser.removeByteOrderMarker(source);
        String presumedUtf8Source = new String(bomFreeSource, StandardCharsets.UTF_8);
        return EncodingParser.parseEncodingPragma(presumedUtf8Source).map(charset -> new String(bomFreeSource, (Charset)charset)).orElse(presumedUtf8Source);
    }

    private static byte[] removeByteOrderMarker(byte[] source) {
        int utfBomBytesLength = UTF_BOM_BYTES.length;
        if (source.length < utfBomBytesLength) {
            return source;
        }
        for (int i = 0; i < utfBomBytesLength; ++i) {
            if (source[i] == UTF_BOM_BYTES[i]) continue;
            return source;
        }
        return Arrays.copyOfRange(source, utfBomBytesLength, source.length);
    }

    private static Optional<Charset> parseEncodingPragma(String source) {
        Matcher m2 = LINE_SPLIT_PATTERN.matcher(source);
        while (m2.find()) {
            String line = m2.group(1);
            if (!COMMENT_OR_EMPTY_LINE_PATTERN.matcher(line).find()) {
                return Optional.empty();
            }
            Matcher matcher = ENCODING_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            String charSetName = matcher.group(1).toUpperCase(Locale.ROOT);
            Charset charset = Charset.forName(charSetName);
            return Optional.of(charset);
        }
        return Optional.empty();
    }
}

