/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ResizeObserver {
    private Map<Component, Integer> componentToId = new HashMap<Component, Integer>();
    private Map<Integer, ComponentMapping> idToComponentMapping = new HashMap<Integer, ComponentMapping>();
    private int nextId = 0;
    private static ObjectMapper om = new ObjectMapper();
    private final UI ui;
    private final Element uiElement;
    private final DomListenerRegistration reg;

    public static ResizeObserver of(UI ui) {
        ResizeObserver resizeObserver = (ResizeObserver)ComponentUtil.getData((Component)ui, ResizeObserver.class);
        if (resizeObserver == null) {
            resizeObserver = new ResizeObserver(ui);
            ComponentUtil.setData((Component)ui, ResizeObserver.class, (Object)resizeObserver);
        }
        return resizeObserver;
    }

    public static ResizeObserver get() {
        return ResizeObserver.of(UI.getCurrent());
    }

    private ResizeObserver(UI ui) {
        this.ui = ui;
        this.uiElement = ui.getElement();
        this.uiElement.executeJs("var el = this;\nel._resizeObserver = new ResizeObserver((entries) => {\n  const sizes = {};\n  for (const entry of entries) {\n    if (entry.target.isConnected && entry.contentBoxSize) {\n      const id = entry.target._resizeObserverId;\n      const contentBoxSize = entry.contentBoxSize[0];\n      sizes[id] = JSON.stringify(entry.contentRect);\n    } else {\n      console.log(\"Ignoring resize event for detached element \" + entry.target._resizeObserverId +  \", TODO: cleanup??\");\n    }\n  }\n  const event = new Event(\"element-resize\");\n  event.dimensions = sizes;\n  el.dispatchEvent(event);\n});\nel._resizeObserverElements = {};\n", new Serializable[0]);
        this.reg = this.uiElement.addEventListener("element-resize", (DomEventListener & Serializable)event -> {
            JsonObject object = event.getEventData().getObject("event.dimensions");
            for (String idx : object.keys()) {
                String json = object.getString(idx);
                try {
                    Dimensions dimensions = (Dimensions)om.readValue(json, Dimensions.class);
                    ComponentMapping componentMapping = this.idToComponentMapping.get(Integer.valueOf(idx));
                    if (componentMapping != null) {
                        new ArrayList<SizeChangeListener>(componentMapping.listeners()).forEach(l -> l.onChange(dimensions));
                        SizeChangeEvent sizeChangeEvent = new SizeChangeEvent(ui, componentMapping.component, dimensions);
                        ComponentUtil.fireEvent((Component)ui, (ComponentEvent)sizeChangeEvent);
                        continue;
                    }
                    Logger.getLogger(ResizeObserver.class.getName()).fine("Resize listener called for component that is already de-registered, id:" + idx);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        }).addEventData("event.dimensions").debounce(100);
    }

    private ComponentMapping getComponentMapping(Component component) {
        return this.idToComponentMapping.computeIfAbsent(this.componentToId.computeIfAbsent(component, c -> this.nextId++), id -> this.mapComponent(component, (Integer)id));
    }

    private ComponentMapping mapComponent(Component c, Integer id) {
        Runnable register = () -> {
            Element componentElement = c.getElement();
            this.uiElement.executeJs("    const el = $0;\n    const id = $1;\n    if(el instanceof HTMLElement) {\n        el._resizeObserverId = id;\n        this._resizeObserver.observe(el);\n        this._resizeObserverElements[id] = el;\n    } else {\n        throw new Error(\"el not Element, Flow bug?\");\n    }\n", new Serializable[]{componentElement, id}).then((SerializableConsumer & Serializable)jsonvalue -> {});
        };
        if (c.isAttached()) {
            register.run();
        } else {
            c.addAttachListener((ComponentEventListener & Serializable)e -> {
                register.run();
                e.unregisterListener();
            });
        }
        c.addDetachListener((ComponentEventListener & Serializable)e -> {
            if (e.getUI().isClosing()) {
                return;
            }
            this.idToComponentMapping.remove(id);
            this.componentToId.remove(c);
            this.uiElement.executeJs("    const el = this._resizeObserverElements[$0];\n    if(el) {\n        delete this._resizeObserverElements[$0];\n        this._resizeObserver.unobserve(el);\n    }\n", new Serializable[]{id});
            e.unregisterListener();
        });
        return new ComponentMapping(id, c);
    }

    public Registration addResizeListener(Component component, ComponentEventListener<SizeChangeEvent> listener) {
        SizeChangeListener sizeChangeListener = d -> listener.onComponentEvent((ComponentEvent)new SizeChangeEvent(this.ui, component, d));
        this.getComponentMapping(component).listeners().add(sizeChangeListener);
        return (Registration & Serializable)() -> {
            ComponentMapping componentMapping = this.getComponentMapping(component);
            componentMapping.listeners().remove(sizeChangeListener);
            if (componentMapping.listeners().isEmpty()) {
                this.unobserve(component);
            }
        };
    }

    public ResizeObserver observe(Component component, SizeChangeListener listener) {
        this.getComponentMapping(component).listeners().add(listener);
        return this;
    }

    public ResizeObserver unobserve(Component component, SizeChangeListener listener) {
        ComponentMapping componentMapping = this.getComponentMapping(component);
        componentMapping.listeners().remove(listener);
        if (componentMapping.listeners().isEmpty()) {
            this.unobserve(component);
        }
        return this;
    }

    private ResizeObserver unobserve(Component component) {
        ComponentMapping componentMapping = this.getComponentMapping(component);
        this.idToComponentMapping.remove(componentMapping.id());
        this.componentToId.remove(component);
        this.uiElement.executeJs("    const el = this._resizeObserverElements[$0];\n    if(el) {\n        delete this._resizeObserverElements[$0];\n        this._resizeObserver.unobserve(el);\n    }\n", new Serializable[]{Integer.valueOf(componentMapping.id())});
        return this;
    }

    public ResizeObserver withDebounceTimeout(int timeout) {
        this.reg.debounce(timeout);
        return this;
    }

    private record ComponentMapping(int id, Component component, ArrayList<SizeChangeListener> listeners) {
        private ComponentMapping(int id, Component component) {
            this(id, component, new ArrayList<SizeChangeListener>());
        }
    }

    public static interface SizeChangeListener {
        public void onChange(Dimensions var1);
    }

    public static class SizeChangeEvent
    extends ComponentEvent<UI> {
        private final Component component;
        private final Dimensions dimensions;

        public SizeChangeEvent(UI ui, Component component, Dimensions dimensions) {
            super((Component)ui, true);
            this.component = component;
            this.dimensions = dimensions;
        }

        public Component getComponent() {
            return this.component;
        }

        public int getWidht() {
            return this.dimensions.width();
        }

        public int getHeight() {
            return this.dimensions.height();
        }

        public Dimensions getDimensions() {
            return this.dimensions;
        }
    }

    public record Dimensions(int x, int y, int width, int height, int top, int right, int bottom, int left) {
    }
}

