/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.messagelist;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.server.Command;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.components.RichText;

@Tag(value="vaadin-message")
public class MarkdownMessage
extends Component
implements HasStyle,
HasSize {
    private static final String PLACEHOLDER = "...";
    private UI ui;
    private String previousHtml;
    private boolean autoScroll = true;
    private Element content = new Element("div");
    private Element scrollHelper = new Element("div");
    private MarkdownStrategy markdownStrategy;

    public MarkdownMessage(String name, LocalDateTime timestamp, Color color) {
        this.getElement().setProperty("userName", name);
        this.getElement().setProperty("time", timestamp.format(DateTimeFormatter.ofPattern("YYYY-MM-dd hh:mm")));
        this.getElement().appendChild(new Element[]{this.content, this.scrollHelper});
        if (color != null) {
            this.setAvatarColor(color);
        }
        this.content.getStyle().setWhiteSpace(Style.WhiteSpace.NORMAL);
    }

    public MarkdownMessage(String name) {
        this(name, LocalDateTime.now(), Color.AVATAR_PRESETS[0]);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String name, LocalDateTime timestamp) {
        this(name, timestamp, Color.AVATAR_PRESETS[0]);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String name, Color avatarColor) {
        this(name, LocalDateTime.now(), avatarColor);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String markdown, String name, Color avatarColor) {
        this(name, LocalDateTime.now(), avatarColor);
        this.setMarkdown(markdown);
    }

    public MarkdownMessage(String markdown, String name) {
        this(name, LocalDateTime.now(), Color.AVATAR_PRESETS[name.hashCode() % Color.AVATAR_PRESETS.length]);
        this.setMarkdown(markdown);
    }

    public MarkdownMessage(String markdown, String name, LocalDateTime timestamp) {
        this(name, timestamp, null);
        this.setMarkdown(markdown);
    }

    public void setAvatarColor(Color color) {
        this.getElement().getStyle().set("--vaadin-avatar-user-color", color.cssColorCode);
        this.getElement().executeJs("\n$0.querySelector('vaadin-avatar').style.setProperty('--vaadin-avatar-user-color', null);$0.querySelector('vaadin-avatar').setAttribute('has-color-index', true);", new Serializable[0]);
    }

    public void setUserColorIndex(int index) {
        this.getElement().setProperty("userColorIndex", (double)index);
    }

    @Deprecated
    public String getMarkdown() {
        try {
            FlexmarkStrategy flexmarkStrategy = (FlexmarkStrategy)this.getMarkdownStrategy();
            return flexmarkStrategy.markdown;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Markdown now cached by the component");
        }
    }

    protected MarkdownStrategy getMarkdownStrategy() {
        if (this.markdownStrategy == null) {
            this.markdownStrategy = new MarkdownItStrategy();
        }
        return this.markdownStrategy;
    }

    public void useFlexmarkJava() {
        this.markdownStrategy = new FlexmarkStrategy();
    }

    protected void setMarkdown(String markdown, boolean uiAccess) {
        this.getMarkdownStrategy().setMarkdown(markdown, uiAccess);
    }

    public void setMarkdown(String markdown) {
        this.setMarkdown(markdown, false);
    }

    private void appendHtml(String html) {
        this.getElement().executeJs("if(this.curHtml) {\n    this.curHtml = this.curHtml + $0;\n} else {\n    this.curHtml = $0;\n}\n$1.innerHTML = this.curHtml;\n", new Serializable[]{html, this.content});
    }

    private void appendHtml(String html, int replaceFrom) {
        this.getElement().executeJs("this.curHtml = this.curHtml ? this.curHtml.substring(0, $2) + $0 : $0;\n$1.innerHTML = this.curHtml;\n", new Serializable[]{html, this.content, Integer.valueOf(replaceFrom)});
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.ui = attachEvent.getUI();
    }

    public UI getUi() {
        if (this.ui == null) {
            this.ui = this.ui.getUI().orElseGet(() -> UI.getCurrent());
        }
        return this.ui;
    }

    public void appendMarkdown(String markdownSnippet) {
        this.appendMarkdown(markdownSnippet, false);
    }

    public void appendMarkdownAsync(String markdownSnippet) {
        this.appendMarkdown(markdownSnippet, true);
    }

    protected void appendMarkdown(String markdownSnippet, boolean uiAccess) {
        this.getMarkdownStrategy().appendMarkdown(markdownSnippet, uiAccess);
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    protected void doAutoScroll() {
        if (this.autoScroll) {
            this.scrollHelper.executeJs("    if(this.scrollIntoViewIfNeeded) {\n        this.scrollIntoViewIfNeeded();\n    } else {\n        // FF\n        this.scrollIntoView();\n    }\n", new Serializable[0]);
        }
    }

    public record Color(String cssColorCode) {
        public static Color[] AVATAR_PRESETS = new Color[]{new Color("#df0b92"), new Color("#650acc"), new Color("#097faa"), new Color("#ad6200"), new Color("#bf16f3"), new Color("#084391"), new Color("#078836")};
    }

    static interface MarkdownStrategy {
        public void appendMarkdown(String var1, boolean var2);

        public void setMarkdown(String var1, boolean var2);
    }

    class FlexmarkStrategy
    implements MarkdownStrategy {
        private static HtmlRenderer renderer;
        private static Parser parser;
        private String markdown;

        FlexmarkStrategy() {
        }

        protected HtmlRenderer getMdRenderer() {
            if (renderer == null) {
                renderer = HtmlRenderer.builder().build();
            }
            return renderer;
        }

        protected Parser getMdParser() {
            if (parser == null) {
                MutableDataSet options = new MutableDataSet();
                parser = Parser.builder((DataHolder)options).build();
            }
            return parser;
        }

        @Override
        public void appendMarkdown(String markdownSnippet, boolean uiAccess) {
            Command & Serializable c;
            markdownSnippet = markdownSnippet != null ? markdownSnippet : "";
            this.markdown = this.markdown == null || MarkdownMessage.PLACEHOLDER.equals(this.markdown) ? markdownSnippet : this.markdown + markdownSnippet;
            String html = this.getMdRenderer().render((Node)this.getMdParser().parse(this.markdown));
            if (MarkdownMessage.this.previousHtml == null) {
                c = (Command & Serializable)() -> MarkdownMessage.this.appendHtml(html);
            } else {
                String commonPrefix = StringUtils.getCommonPrefix((String[])new String[]{html, MarkdownMessage.this.previousHtml});
                int startOfNew = commonPrefix.length();
                String newPart = html.substring(startOfNew);
                c = (Command & Serializable)() -> {
                    MarkdownMessage.this.appendHtml(newPart, startOfNew);
                    MarkdownMessage.this.doAutoScroll();
                };
            }
            MarkdownMessage.this.previousHtml = html;
            if (uiAccess) {
                MarkdownMessage.this.getUi().access((Command)c);
            } else {
                c.execute();
            }
        }

        @Override
        public void setMarkdown(String markdown, boolean uiAccess) {
            String html;
            this.markdown = markdown == null ? MarkdownMessage.PLACEHOLDER : markdown;
            MarkdownMessage.this.previousHtml = html = this.getMdRenderer().render((Node)this.getMdParser().parse(this.markdown));
            if (uiAccess) {
                MarkdownMessage.this.getUi().access((Command & Serializable)() -> MarkdownMessage.this.appendHtml(html, 0));
            } else {
                MarkdownMessage.this.appendHtml(html, 0);
            }
        }
    }

    class MarkdownItStrategy
    implements MarkdownStrategy {
        MarkdownItStrategy() {
        }

        @Override
        public void appendMarkdown(String markdown, boolean uiAccess) {
            Command & Serializable c = (Command & Serializable)() -> {
                RichText.MarkdownItStrategy.ensureMarkdownIt();
                MarkdownMessage.this.content.executeJs("    const md = window.markdownit(); \n    const input = $0;\n    if(this.markdown) {\n        this.markdown = this.markdown + input;\n    } else {\n        this.markdown = input;\n    }\n    const html = md.render(this.markdown);\n    this.innerHTML = html;\n", new Serializable[]{markdown});
            };
            if (uiAccess) {
                MarkdownMessage.this.getUi().access((Command)c);
            } else {
                c.execute();
            }
        }

        @Override
        public void setMarkdown(String markdown, boolean uiAccess) {
            Command & Serializable c = (Command & Serializable)() -> {
                RichText.MarkdownItStrategy.ensureMarkdownIt();
                MarkdownMessage.this.content.executeJs("    const md = window.markdownit(); \n    const input = $0;\n    this.markdown = input;\n    const html = md.render(input);\n    this.innerHTML = html;\n", new Serializable[]{markdown == null ? "" : markdown});
            };
            if (uiAccess) {
                MarkdownMessage.this.getUi().access((Command)c);
            } else {
                c.execute();
            }
        }
    }
}

