/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.router.Menu;
import org.vaadin.firitin.appframework.MenuItem;
import org.vaadin.firitin.appframework.NavigationItem;
import org.vaadin.firitin.appframework.SubMenu;

public class BasicNavigationItem
extends SideNavItem
implements NavigationItem {
    private final Class<? extends Component> navigationTarget;
    private final String text;
    private String path;
    private boolean disabled = false;
    private NavigationItem parentItem;

    public BasicNavigationItem(Class<? extends Component> navigationTarget) {
        super(null, navigationTarget);
        Menu menu;
        this.getStyle().setDisplay(Style.Display.BLOCK);
        this.text = NavigationItem.getMenuTextFromClass(navigationTarget);
        this.setLabel(this.text);
        MenuItem me = navigationTarget.getAnnotation(MenuItem.class);
        if (me != null) {
            if (me.icon() != null) {
                this.setPrefixComponent((Component)new Icon(me.icon()));
            }
            if (me.hidden()) {
                this.setVisible(false);
            }
            if (!me.enabled()) {
                this.setEnabled(false);
            }
            if (me.openByDefault()) {
                this.setExpanded(true);
            }
        } else if (navigationTarget.isAnnotationPresent(Menu.class) && (menu = navigationTarget.getAnnotation(Menu.class)).icon() != null) {
            this.setPrefixComponent((Component)new Icon(menu.icon()));
        }
        this.navigationTarget = navigationTarget;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget;
    }

    public void setPath(String path) {
        this.path = path;
        if (!this.disabled) {
            super.setPath(path);
        }
    }

    public void setEnabled(boolean enabled) {
        boolean bl = this.disabled = !enabled;
        if (this.disabled) {
            super.setPath((String)null);
        } else if (this.path != null) {
            super.setPath(this.path);
        }
        String color = enabled ? "" : "gray";
        this.getStyle().setColor(color);
    }

    @Override
    public boolean isEnabled() {
        return !this.disabled;
    }

    @Override
    public void setActive(boolean active) {
        if (active) {
            this.getElement().setAttribute("active", true);
        } else {
            this.getElement().removeAttribute("active");
        }
    }

    @Override
    public void addSubItem(NavigationItem item) {
        if (item instanceof BasicNavigationItem) {
            BasicNavigationItem bi = (BasicNavigationItem)item;
            this.addItem(new SideNavItem[]{bi});
        } else {
            this.addSubMenu((SubMenu)item);
        }
    }

    private void addSubMenu(SubMenu item) {
        this.getElement().appendChild(new Element[]{item.getElement()});
    }

    @Override
    public void setParentItem(NavigationItem parent) {
        this.parentItem = parent;
    }

    @Override
    public NavigationItem getParentItem() {
        return this.parentItem;
    }
}

