/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyLabel;
import org.nuiton.wikitty.entities.WikittyLabelHelper;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;

public class WikittyLabelUtil {
    private static Log log = LogFactory.getLog(WikittyLabelUtil.class);

    public static void addLabel(Wikitty wikitty, String label) {
        if (!WikittyLabelHelper.hasExtension(wikitty)) {
            WikittyLabelHelper.addExtension(wikitty);
        }
        WikittyLabelHelper.addLabels(wikitty, label);
    }

    public static void addLabel(BusinessEntityImpl entity, String label) {
        Wikitty w = entity.getWikitty();
        WikittyLabelUtil.addLabel(w, label);
    }

    @Deprecated
    public static void addLabel(WikittyProxy proxy, String wikittyId, String label) {
        Wikitty w = proxy.restore(wikittyId);
        WikittyLabelImpl l = new WikittyLabelImpl(w);
        l.addLabels(label);
        proxy.store(l);
    }

    public static void addLabel(WikittyClient client, String wikittyId, String label) {
        Wikitty w = client.restore(wikittyId);
        WikittyLabelImpl l = new WikittyLabelImpl(w);
        l.addLabels(label);
        client.store(l);
    }

    @Deprecated
    public static PagedResult<Wikitty> findAllByLabel(WikittyProxy proxy, String label, int firstIndex, int endIndex) {
        WikittyLabelImpl l = new WikittyLabelImpl();
        l.addLabels(label);
        Criteria criteria = Search.query(l.getWikitty()).criteria().setFirstIndex(firstIndex).setEndIndex(endIndex);
        PagedResult<Wikitty> result = proxy.findAllByCriteria(criteria);
        return result;
    }

    public static WikittyQueryResult<Wikitty> findAllByLabel(WikittyClient client, String label, int firstIndex, int limit) {
        WikittyQuery query = new WikittyQueryMaker().eq(WikittyLabel.ELEMENT_FIELD_WIKITTYLABEL_LABELS, (Object)label).end().setFirst(firstIndex).setLimit(limit);
        WikittyQueryResult<Wikitty> result = client.findAllByQuery(Wikitty.class, query);
        return result;
    }

    @Deprecated
    public static Wikitty findByLabel(WikittyProxy proxy, String label) {
        WikittyLabelImpl l = new WikittyLabelImpl();
        l.addLabels(label);
        Criteria criteria = Search.query(l.getWikitty()).criteria();
        Wikitty result = proxy.findByCriteria(criteria);
        return result;
    }

    public static Wikitty findByLabel(WikittyClient proxy, String label) {
        WikittyQuery query = new WikittyQueryMaker().eq(WikittyLabel.ELEMENT_FIELD_WIKITTYLABEL_LABELS, (Object)label).end();
        Wikitty result = proxy.findByQuery(Wikitty.class, query);
        return result;
    }

    @Deprecated
    public static Set<String> findAllAppliedLabels(WikittyProxy proxy, String wikittyId) {
        Wikitty w = proxy.restore(wikittyId);
        Set<String> result = WikittyLabelHelper.getLabels(w);
        return result;
    }

    public static Set<String> findAllAppliedLabels(WikittyClient proxy, String wikittyId) {
        Wikitty w = proxy.restore(wikittyId);
        Set<String> result = WikittyLabelHelper.getLabels(w);
        return result;
    }
}

