/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id: EntitiesList.java 235 2011-09-21 10:34:48Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-entities/src/main/java/fr/inra/refcomp/entities/EntitiesList.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 *
 * Entity to encapsulate an AgentSkill list and all its dependencies (Agent,
 * Skills, Frequencies, ...)
 *
 * User: couteau
 * Date: 04/01/11
 */
public class EntitiesList implements Serializable {

    protected Map<BusinessEntity, Skill> entities;

    protected Map<String,BusinessEntity> dependencies;

    public EntitiesList() {
        entities = new HashMap<BusinessEntity, Skill>();
        dependencies = new HashMap<String, BusinessEntity>();
    }

    public EntitiesList(Map<BusinessEntity, Skill> entities) {
        this.entities = entities;
        dependencies = new HashMap<String, BusinessEntity>();
    }

    public Map<BusinessEntity, Skill> getEntities() {
        return entities;
    }

    public void setEntities(Map<BusinessEntity, Skill> entities) {
        this.entities = entities;
    }

    public void addEntity(BusinessEntity entity) {
        entities.put(entity, null);
    }

    public void addEntity(BusinessEntity entity, Skill skill) {
        entities.put(entity, skill);
    }

    public void removeEntity(BusinessEntity entity) {
        entities.remove(entity);
    }

    public void clearEntities(){
        entities.clear();
    }

    public void addDependency(String id, BusinessEntity entity) {
        dependencies.put(id, entity);
    }

    public void removeDependency(String id) {
        dependencies.remove(id);
    }

    public BusinessEntity getDependency(String id) {
        return dependencies.get(id);
    }

    public void setDependencies(Map<String, BusinessEntity> dependencies) {
        this.dependencies = dependencies;
    }

    public void clearDependencies() {
        dependencies.clear();
    }
}
