/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class DepartmentAbstract extends BusinessEntityImpl implements Department {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionDepartment;

    private static final long serialVersionUID = 7004839258241655396L;

    @Override
    public String getName() {
String value = DepartmentHelper.getName(getWikitty());
return value;
}

    @Override
    public void setName(String name) {
String oldValue = getName();
DepartmentHelper.setName(getWikitty(), name);
getPropertyChangeSupport().firePropertyChange(Department.FIELD_DEPARTMENT_NAME, oldValue, getName());
}

    @Override
    public String getFullName() {
String value = DepartmentHelper.getFullName(getWikitty());
return value;
}

    @Override
    public void setFullName(String fullName) {
String oldValue = getFullName();
DepartmentHelper.setFullName(getWikitty(), fullName);
getPropertyChangeSupport().firePropertyChange(Department.FIELD_DEPARTMENT_FULLNAME, oldValue, getFullName());
}

    @Override
    public Set<String> getUnitDeptLink() {
Set<String> result = DepartmentHelper.getUnitDeptLink(getWikitty());
return result;
}

    @Override
    public void setUnitDeptLink(Set<String> unitDeptLink) {
Set<String> oldValue = getUnitDeptLink();
DepartmentHelper.setUnitDeptLink(getWikitty(), unitDeptLink);
getPropertyChangeSupport().firePropertyChange(Department.FIELD_DEPARTMENT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void addAllUnitDeptLink(Collection<String> unitDeptLink) {
Set<String> oldValue = getUnitDeptLink();
DepartmentHelper.addAllUnitDeptLink(getWikitty(), unitDeptLink);
getPropertyChangeSupport().firePropertyChange(Department.FIELD_DEPARTMENT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void addUnitDeptLink(String... element) {
Set<String> oldValue = getUnitDeptLink();
DepartmentHelper.addUnitDeptLink(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Department.FIELD_DEPARTMENT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void removeUnitDeptLink(String... element) {
Set<String> oldValue = getUnitDeptLink();
DepartmentHelper.removeUnitDeptLink(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Department.FIELD_DEPARTMENT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void clearUnitDeptLink() {
DepartmentHelper.clearUnitDeptLink(getWikitty());
getPropertyChangeSupport().firePropertyChange(Department.FIELD_DEPARTMENT_UNITDEPTLINK, null, getUnitDeptLink());
}

    public DepartmentAbstract() {
        super();
}

    public DepartmentAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public DepartmentAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionDepartment = new WikittyExtension(EXT_DEPARTMENT,
                "2.0", // version
                WikittyUtil.tagValuesToMap(" version=\"2.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String name unique=\"true\"", 
                                             "String fullName unique=\"true\"", 
                                             "Wikitty unitDeptLink[0-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionDepartment);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return DepartmentHelper.toString(getWikitty());
}

} //DepartmentAbstract
