/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.adagio.core.dao.referential.pmfm.UnitId;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristics;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ReferentialPersistenceServiceSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.hibernate.type.IntegerType;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;

@Service(value="caracteristicPersistenceService")
public class CaracteristicPersistenceServiceImpl
extends ReferentialPersistenceServiceSupport
implements CaracteristicPersistenceService {
    @Resource(name="caracteristicPersistenceService")
    protected CaracteristicPersistenceService thisService;
    protected Set<Integer> propertedPmfmIds;
    protected Predicate<SpeciesAbleBatch> batchVracPredicate;

    @Override
    public void init() {
        super.init();
        this.batchVracPredicate = SpeciesAbleBatchs.newSpeciesAbleBatchCategoryPredicate(PmfmId.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue());
        this.propertedPmfmIds = Sets.newHashSet((Object[])new Integer[]{PmfmId.MULTIRIG_AGGREGATION.getValue(), PmfmId.MULTIRIG_NUMBER.getValue(), PmfmId.STATION_NUMBER.getValue(), PmfmId.RECTILINEAR_OPERATION.getValue(), PmfmId.HAUL_VALID.getValue(), PmfmId.TRAWL_DISTANCE.getValue(), PmfmId.SURVEY_PART.getValue(), PmfmId.SORTED_UNSORTED.getValue(), PmfmId.ID_PMFM.getValue()});
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        return this.getAllCaracteristics(false);
    }

    @Override
    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.getAllCaracteristics(true);
    }

    @Override
    public List<Caracteristic> getAllCaracteristicForSampleCategory() {
        List<Caracteristic> allCaracteristicWithProtected = this.thisService.getAllCaracteristicWithProtected();
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter(allCaracteristicWithProtected, Caracteristics.newSampleCategoryModelPredicate()));
        return result;
    }

    protected List<Caracteristic> getAllCaracteristics(boolean withProtected) {
        Iterator<Object[]> sources = this.queryListWithStatus("allPmfm", "unitIdNone", IntegerType.INSTANCE, UnitId.NONE.getValue());
        ArrayList result = Lists.newArrayList();
        Cache pmfmByIdCache = this.cacheService.getCache("pmfmById");
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Integer pmfmId = (Integer)source[0];
            Caracteristic target = this.loadCaracteristic(source);
            if (withProtected || !this.isProtectedCaracteristic(pmfmId)) {
                result.add(target);
            }
            pmfmByIdCache.put((Object)pmfmId, (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Caracteristic> getAllNumericCaracteristic() {
        ArrayList result = Lists.newArrayList();
        for (Caracteristic caracteristic : this.getAllCaracteristic()) {
            if (!caracteristic.isNumericType()) continue;
            result.add(caracteristic);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        Integer pmfmId = PmfmId.SIZE_CATEGORY.getValue();
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        Integer pmfmId = PmfmId.SEX.getValue();
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        Integer pmfmId = PmfmId.SORTED_UNSORTED.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        ArrayList qualitativeValue = Lists.newArrayList(result.getQualitativeValue());
        Iterator iterator = qualitativeValue.iterator();
        while (iterator.hasNext()) {
            CaracteristicQualitativeValue qv = (CaracteristicQualitativeValue)iterator.next();
            if (!QualitativeValueId.UNSORTED.getValue().equals(Integer.valueOf(qv.getId()))) continue;
            iterator.remove();
            break;
        }
        result.setQualitativeValue(Collections.unmodifiableList(qualitativeValue));
        return result;
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        Integer pmfmId = PmfmId.MATURITY.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getAgeCaracteristic() {
        Integer pmfmId = PmfmId.AGE.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getMarineLitterCategoryCaracteristic() {
        Integer pmfmId = PmfmId.MARINE_LITTER_TYPE.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        Integer pmfmId = PmfmId.MARINE_LITTER_SIZE_CATEGORY.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getVerticalOpeningCaracteristic() {
        Integer pmfmId = PmfmId.VERTICAL_OPENING.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getHorizontalOpeningWingsCaracteristic() {
        Integer pmfmId = PmfmId.HORIZONTAL_OPENING_WINGS.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        Integer pmfmId = PmfmId.HORIZONTAL_OPENING_DOOR.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getDeadOrAliveCaracteristic() {
        Integer pmfmId = PmfmId.DEAD_OR_ALIVE.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getPmfmIdCaracteristic() {
        Integer pmfmId = PmfmId.ID_PMFM.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getWeightMeasuredCaracteristic() {
        Integer pmfmId = PmfmId.WEIGHT_MEASURED.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getCaracteristic(Integer pmfmId) {
        Object[] source = this.queryUniqueWithStatus("pmfmById", "pmfmId", IntegerType.INSTANCE, pmfmId, "unitIdNone", IntegerType.INSTANCE, UnitId.NONE.getValue());
        Caracteristic target = this.loadCaracteristic(source);
        return target;
    }

    @Override
    public boolean isVracBatch(SpeciesAbleBatch speciesBatch) {
        return this.batchVracPredicate.apply((Object)speciesBatch);
    }

    @Override
    public boolean isHorsVracBatch(SpeciesAbleBatch speciesBatch) {
        return !this.batchVracPredicate.apply((Object)speciesBatch);
    }

    @Override
    public Predicate<SpeciesAbleBatch> getVracBatchPredicate() {
        return this.batchVracPredicate;
    }

    protected Caracteristic loadCaracteristic(Object[] source) {
        Integer pmfmId = (Integer)source[0];
        Caracteristic result = Caracteristics.newCaracteristic();
        result.setId(pmfmId);
        result.setParameterName((String)source[1]);
        result.setMatrixName((String)source[2]);
        result.setFractionName((String)source[3]);
        result.setMethodName((String)source[4]);
        CaracteristicType type = Caracteristics.getType((Boolean)source[5], (Boolean)source[6]);
        result.setCaracteristicType(type);
        result.setNumericType(Caracteristics.isNumberCaracteristic(result));
        result.setSignifFiguresNumber((Integer)source[7]);
        result.setMaximumNumberDecimals((Integer)source[8]);
        result.setPrecision((Float)source[9]);
        result.setUnit((String)source[10]);
        this.setStatus((String)source[11], result);
        if (Caracteristics.isQualitativeCaracteristic(result)) {
            Iterator<Object[]> sources = this.queryListWithStatus("pmfmQualitativeValues", "pmfmId", IntegerType.INSTANCE, pmfmId);
            ArrayList values = Lists.newArrayList();
            while (sources.hasNext()) {
                Object[] source2 = sources.next();
                CaracteristicQualitativeValue target2 = CaracteristicQualitativeValues.newCaracteristicQualitativeValue();
                target2.setId(String.valueOf(source2[0]));
                target2.setName(String.valueOf(source2[1]));
                target2.setDescription(String.valueOf(source2[2]));
                this.setStatus((String)source2[3], target2);
                values.add(target2);
            }
            result.setQualitativeValue(Collections.unmodifiableList(values));
        }
        return result;
    }

    protected boolean isProtectedCaracteristic(Integer pmfmId) {
        return this.propertedPmfmIds.contains(pmfmId);
    }
}

