/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.util.Vector;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.XMLObject;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.QName;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;

class XMLList
extends XMLObjectImpl
implements Function {
    static final long serialVersionUID = -4543618751670781135L;
    private AnnotationList _annos;
    private XMLObjectImpl targetObject = null;
    private javax.xml.namespace.QName targetProperty = null;

    XMLList(XMLLibImpl xMLLibImpl) {
        super(xMLLibImpl, xMLLibImpl.xmlListPrototype);
        this._annos = new AnnotationList();
    }

    XMLList(XMLLibImpl xMLLibImpl, Object object) {
        super(xMLLibImpl, xMLLibImpl.xmlListPrototype);
        if (object == null || object instanceof Undefined) {
            String string = "";
        } else if (object instanceof XML) {
            XML xML = (XML)object;
            this._annos = new AnnotationList();
            this._annos.add(xML.getAnnotation());
        } else if (object instanceof XMLList) {
            XMLList xMLList = (XMLList)object;
            this._annos = new AnnotationList();
            for (int i = 0; i < xMLList._annos.length(); ++i) {
                this._annos.add(xMLList._annos.item(i));
            }
        } else {
            String string = ScriptRuntime.toString(object).trim();
            if (!string.startsWith("<>")) {
                string = "<>" + string + "</>";
            }
            if (!(string = "<fragment>" + string.substring(2)).endsWith("</>")) {
                throw ScriptRuntime.typeError("XML with anonymous tag missing end anonymous tag");
            }
            string = string.substring(0, string.length() - 3) + "</fragment>";
            XML xML = XML.createFromJS(xMLLibImpl, string);
            XMLList xMLList = xML.children();
            this._annos = new AnnotationList();
            for (int i = 0; i < xMLList._annos.length(); ++i) {
                this._annos.add(((XML)xMLList.item(i).copy()).getAnnotation());
            }
        }
    }

    void setTargets(XMLObjectImpl xMLObjectImpl, javax.xml.namespace.QName qName) {
        this.targetObject = xMLObjectImpl;
        this.targetProperty = qName;
    }

    XML getXmlFromAnnotation(int n) {
        XML xML;
        if (n >= 0 && n < this.length()) {
            XML.XScriptAnnotation xScriptAnnotation = this._annos.item(n);
            xML = XML.getFromAnnotation(this.lib, xScriptAnnotation);
        } else {
            xML = null;
        }
        return xML;
    }

    private void internalRemoveFromList(int n) {
        this._annos.remove(n);
    }

    void replace(int n, XML xML) {
        if (n < this.length()) {
            int n2;
            AnnotationList annotationList = new AnnotationList();
            for (n2 = 0; n2 < n; ++n2) {
                annotationList.add(this._annos.item(n2));
            }
            annotationList.add(xML.getAnnotation());
            for (n2 = n + 1; n2 < this.length(); ++n2) {
                annotationList.add(this._annos.item(n2));
            }
            this._annos = annotationList;
        }
    }

    private void insert(int n, XML xML) {
        if (n < this.length()) {
            int n2;
            AnnotationList annotationList = new AnnotationList();
            for (n2 = 0; n2 < n; ++n2) {
                annotationList.add(this._annos.item(n2));
            }
            annotationList.add(xML.getAnnotation());
            for (n2 = n; n2 < this.length(); ++n2) {
                annotationList.add(this._annos.item(n2));
            }
            this._annos = annotationList;
        }
    }

    public String getClassName() {
        return "XMLList";
    }

    public Object get(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.length()) {
            return this.getXmlFromAnnotation(n);
        }
        return Scriptable.NOT_FOUND;
    }

    boolean hasXMLProperty(XMLName xMLName) {
        boolean bl = false;
        String string = xMLName.localName();
        if (this.getPropertyList(xMLName).length() > 0 || this.getMethod(string) != NOT_FOUND) {
            bl = true;
        }
        return bl;
    }

    public boolean has(int n, Scriptable scriptable) {
        return 0 <= n && n < this.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void putXMLProperty(XMLName xMLName, Object object) {
        if (object == null) {
            object = "null";
        } else if (object instanceof Undefined) {
            object = "undefined";
        }
        if (this.length() > 1) {
            throw ScriptRuntime.typeError("Assignment to lists with more that one item is not supported");
        }
        if (this.length() == 0) {
            if (this.targetObject == null || this.targetProperty == null || this.targetProperty.getLocalPart().equals("*")) throw ScriptRuntime.typeError("Assignment to empty XMLList without targets not supported");
            XML xML = XML.createTextElement(this.lib, this.targetProperty, "");
            this.addToList(xML);
            if (xMLName.isAttributeName()) {
                this.setAttribute(xMLName, object);
            } else {
                XML xML2 = this.item(0);
                xML2.putXMLProperty(xMLName, object);
                this.replace(0, this.item(0));
            }
            XMLName xMLName2 = XMLName.formProperty(this.targetProperty.getNamespaceURI(), this.targetProperty.getLocalPart());
            this.targetObject.putXMLProperty(xMLName2, this);
            return;
        } else if (xMLName.isAttributeName()) {
            this.setAttribute(xMLName, object);
            return;
        } else {
            XML xML = this.item(0);
            xML.putXMLProperty(xMLName, object);
            this.replace(0, this.item(0));
        }
    }

    Object getXMLProperty(XMLName xMLName) {
        return this.getPropertyList(xMLName);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        Object object2 = Undefined.instance;
        if (object == null) {
            object = "null";
        } else if (object instanceof Undefined) {
            object = "undefined";
        }
        XMLObject xMLObject = object instanceof XMLObject ? (XMLObject)object : (this.targetProperty == null ? XML.createFromJS(this.lib, object.toString()) : XML.createTextElement(this.lib, this.targetProperty, object.toString()));
        object2 = n < this.length() ? this.item(n).parent() : this.parent();
        if (object2 instanceof XML) {
            XML xML = (XML)object2;
            if (n < this.length()) {
                XMLList xMLList;
                XML xML2 = this.getXmlFromAnnotation(n);
                if (xMLObject instanceof XML) {
                    xML2.replaceAll((XML)xMLObject);
                    this.replace(n, xML2);
                } else if (xMLObject instanceof XMLList && (xMLList = (XMLList)xMLObject).length() > 0) {
                    int n2 = xML2.childIndex();
                    xML2.replaceAll(xMLList.item(0));
                    this.replace(n, xMLList.item(0));
                    for (int i = 1; i < xMLList.length(); ++i) {
                        xML.insertChildAfter(xML.getXmlChild(n2), xMLList.item(i));
                        ++n2;
                        this.insert(n + i, xMLList.item(i));
                    }
                }
            } else {
                xML.appendChild(xMLObject);
                this.addToList(xML.getXmlChild(n));
            }
        } else if (n < this.length()) {
            XMLList xMLList;
            XML xML = XML.getFromAnnotation(this.lib, this._annos.item(n));
            if (xMLObject instanceof XML) {
                xML.replaceAll((XML)xMLObject);
                this.replace(n, xML);
            } else if (xMLObject instanceof XMLList && (xMLList = (XMLList)xMLObject).length() > 0) {
                xML.replaceAll(xMLList.item(0));
                this.replace(n, xMLList.item(0));
                for (int i = 1; i < xMLList.length(); ++i) {
                    this.insert(n + i, xMLList.item(i));
                }
            }
        } else {
            this.addToList(xMLObject);
        }
    }

    void deleteXMLProperty(XMLName xMLName) {
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            if (xML.tokenType() != XmlCursor.TokenType.START) continue;
            xML.deleteXMLProperty(xMLName);
        }
    }

    public void delete(int n) {
        if (n >= 0 && n < this.length()) {
            XML xML = this.getXmlFromAnnotation(n);
            xML.remove();
            this.internalRemoveFromList(n);
        }
    }

    public Object[] getIds() {
        Object[] objectArray;
        if (this.prototypeFlag) {
            objectArray = new Object[]{};
        } else {
            objectArray = new Object[this.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = new Integer(i);
            }
        }
        return objectArray;
    }

    public Object[] getIdsForDebug() {
        return this.getIds();
    }

    void remove() {
        int n = this.length();
        for (int i = n - 1; i >= 0; --i) {
            XML xML = this.getXmlFromAnnotation(i);
            if (xML == null) continue;
            xML.remove();
            this.internalRemoveFromList(i);
        }
    }

    XML item(int n) {
        return this._annos != null ? this.getXmlFromAnnotation(n) : XML.createEmptyXML(this.lib);
    }

    private void setAttribute(XMLName xMLName, Object object) {
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xML.setAttribute(xMLName, object);
        }
    }

    void addToList(Object object) {
        if (object instanceof Undefined) {
            return;
        }
        if (object instanceof XMLList) {
            XMLList xMLList = (XMLList)object;
            for (int i = 0; i < xMLList.length(); ++i) {
                this._annos.add(xMLList.item(i).getAnnotation());
            }
        } else if (object instanceof XML) {
            this._annos.add(((XML)object).getAnnotation());
        } else if (object instanceof XML.XScriptAnnotation) {
            this._annos.add((XML.XScriptAnnotation)object);
        }
    }

    XML addNamespace(Namespace namespace) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).addNamespace(namespace);
        }
        throw ScriptRuntime.typeError("The addNamespace method works only on lists containing one item");
    }

    XML appendChild(Object object) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).appendChild(object);
        }
        throw ScriptRuntime.typeError("The appendChild method works only on lists containing one item");
    }

    XMLList attribute(XMLName xMLName) {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.attribute(xMLName));
        }
        return xMLList;
    }

    XMLList attributes() {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.attributes());
        }
        return xMLList;
    }

    XMLList child(long l) {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            xMLList.addToList(this.getXmlFromAnnotation(i).child(l));
        }
        return xMLList;
    }

    XMLList child(XMLName xMLName) {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            xMLList.addToList(this.getXmlFromAnnotation(i).child(xMLName));
        }
        return xMLList;
    }

    int childIndex() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).childIndex();
        }
        throw ScriptRuntime.typeError("The childIndex method works only on lists containing one item");
    }

    XMLList children() {
        Vector<XML> vector = new Vector<XML>();
        for (int i = 0; i < this.length(); ++i) {
            XMLList xMLList;
            XML xML = this.getXmlFromAnnotation(i);
            if (xML == null || !((xMLList = xML.children()) instanceof XMLList)) continue;
            XMLList xMLList2 = xMLList;
            int n = xMLList2.length();
            for (int j = 0; j < n; ++j) {
                vector.addElement(xMLList2.item(j));
            }
        }
        XMLList xMLList = new XMLList(this.lib);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            xMLList.addToList(vector.get(i));
        }
        return xMLList;
    }

    XMLList comments() {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.comments());
        }
        return xMLList;
    }

    boolean contains(Object object) {
        boolean bl = false;
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            if (!xML.equivalentXml(object)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    Object copy() {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.copy());
        }
        return xMLList;
    }

    XMLList descendants(XMLName xMLName) {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.descendants(xMLName));
        }
        return xMLList;
    }

    Object[] inScopeNamespaces() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).inScopeNamespaces();
        }
        throw ScriptRuntime.typeError("The inScopeNamespaces method works only on lists containing one item");
    }

    XML insertChildAfter(Object object, Object object2) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).insertChildAfter(object, object2);
        }
        throw ScriptRuntime.typeError("The insertChildAfter method works only on lists containing one item");
    }

    XML insertChildBefore(Object object, Object object2) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).insertChildAfter(object, object2);
        }
        throw ScriptRuntime.typeError("The insertChildBefore method works only on lists containing one item");
    }

    boolean hasOwnProperty(XMLName xMLName) {
        String string;
        boolean bl = false;
        bl = this.prototypeFlag ? 0 != this.findPrototypeId(string = xMLName.localName()) : this.getPropertyList(xMLName).length() > 0;
        return bl;
    }

    boolean hasComplexContent() {
        boolean bl;
        int n = this.length();
        if (n == 0) {
            bl = false;
        } else if (n == 1) {
            bl = this.getXmlFromAnnotation(0).hasComplexContent();
        } else {
            bl = false;
            for (int i = 0; i < n; ++i) {
                XML xML = this.getXmlFromAnnotation(i);
                if (xML.tokenType() != XmlCursor.TokenType.START) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    boolean hasSimpleContent() {
        boolean bl;
        int n = this.length();
        if (n == 0) {
            bl = true;
        } else if (n == 1) {
            bl = this.getXmlFromAnnotation(0).hasSimpleContent();
        } else {
            bl = true;
            for (int i = 0; i < n; ++i) {
                XML xML = this.getXmlFromAnnotation(i);
                if (xML.tokenType() != XmlCursor.TokenType.START) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    int length() {
        int n = 0;
        if (this._annos != null) {
            n = this._annos.length();
        }
        return n;
    }

    String localName() {
        if (this.length() == 1) {
            return this.name().localName();
        }
        throw ScriptRuntime.typeError("The localName method works only on lists containing one item");
    }

    QName name() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).name();
        }
        throw ScriptRuntime.typeError("The name method works only on lists containing one item");
    }

    Object namespace(String string) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).namespace(string);
        }
        throw ScriptRuntime.typeError("The namespace method works only on lists containing one item");
    }

    Object[] namespaceDeclarations() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).namespaceDeclarations();
        }
        throw ScriptRuntime.typeError("The namespaceDeclarations method works only on lists containing one item");
    }

    Object nodeKind() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).nodeKind();
        }
        throw ScriptRuntime.typeError("The nodeKind method works only on lists containing one item");
    }

    void normalize() {
        for (int i = 0; i < this.length(); ++i) {
            this.getXmlFromAnnotation(i).normalize();
        }
    }

    Object parent() {
        Object object = Undefined.instance;
        if (this.length() == 0 && this.targetObject != null && this.targetObject instanceof XML) {
            object = this.targetObject;
        } else {
            for (int i = 0; i < this.length(); ++i) {
                Object object2 = this.getXmlFromAnnotation(i).parent();
                if (i == 0) {
                    object = object2;
                    continue;
                }
                if (object == object2) continue;
                object = Undefined.instance;
                break;
            }
        }
        return object;
    }

    XML prependChild(Object object) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).prependChild(object);
        }
        throw ScriptRuntime.typeError("The prependChild method works only on lists containing one item");
    }

    Object processingInstructions(XMLName xMLName) {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            XML xML = this.getXmlFromAnnotation(i);
            xMLList.addToList(xML.processingInstructions(xMLName));
        }
        return xMLList;
    }

    boolean propertyIsEnumerable(Object object) {
        long l;
        if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        } else if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            l = (long)d;
            if ((double)l != d) {
                return false;
            }
            if (l == 0L && 1.0 / d < 0.0) {
                return false;
            }
        } else {
            String string = ScriptRuntime.toString(object);
            l = ScriptRuntime.testUint32String(string);
        }
        return 0L <= l && l < (long)this.length();
    }

    XML removeNamespace(Namespace namespace) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).removeNamespace(namespace);
        }
        throw ScriptRuntime.typeError("The removeNamespace method works only on lists containing one item");
    }

    XML replace(long l, Object object) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).replace(l, object);
        }
        throw ScriptRuntime.typeError("The replace method works only on lists containing one item");
    }

    XML replace(XMLName xMLName, Object object) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).replace(xMLName, object);
        }
        throw ScriptRuntime.typeError("The replace method works only on lists containing one item");
    }

    XML setChildren(Object object) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).setChildren(object);
        }
        throw ScriptRuntime.typeError("The setChildren method works only on lists containing one item");
    }

    void setLocalName(String string) {
        if (this.length() != 1) {
            throw ScriptRuntime.typeError("The setLocalName method works only on lists containing one item");
        }
        this.getXmlFromAnnotation(0).setLocalName(string);
    }

    void setName(QName qName) {
        if (this.length() != 1) {
            throw ScriptRuntime.typeError("The setName method works only on lists containing one item");
        }
        this.getXmlFromAnnotation(0).setName(qName);
    }

    void setNamespace(Namespace namespace) {
        if (this.length() != 1) {
            throw ScriptRuntime.typeError("The setNamespace method works only on lists containing one item");
        }
        this.getXmlFromAnnotation(0).setNamespace(namespace);
    }

    XMLList text() {
        XMLList xMLList = new XMLList(this.lib);
        for (int i = 0; i < this.length(); ++i) {
            xMLList.addToList(this.getXmlFromAnnotation(i).text());
        }
        return xMLList;
    }

    public String toString() {
        if (this.hasSimpleContent()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.length(); ++i) {
                XML xML = this.getXmlFromAnnotation(i);
                stringBuffer.append(xML.toString());
            }
            return stringBuffer.toString();
        }
        return this.toXMLString(0);
    }

    String toSource(int n) {
        return "<>" + this.toXMLString(0) + "</>";
    }

    String toXMLString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.length(); ++i) {
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(this.getXmlFromAnnotation(i).toXMLString(n));
        }
        return stringBuffer.toString();
    }

    Object valueOf() {
        return this;
    }

    boolean equivalentXml(Object object) {
        XMLList xMLList;
        boolean bl = false;
        if (object instanceof Undefined && this.length() == 0) {
            bl = true;
        } else if (this.length() == 1) {
            bl = this.getXmlFromAnnotation(0).equivalentXml(object);
        } else if (object instanceof XMLList && (xMLList = (XMLList)object).length() == this.length()) {
            bl = true;
            for (int i = 0; i < this.length(); ++i) {
                if (this.getXmlFromAnnotation(i).equivalentXml(xMLList.getXmlFromAnnotation(i))) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private XMLList getPropertyList(XMLName xMLName) {
        XMLList xMLList = new XMLList(this.lib);
        javax.xml.namespace.QName qName = null;
        if (!xMLName.isDescendants() && !xMLName.isAttributeName()) {
            qName = new javax.xml.namespace.QName(xMLName.uri(), xMLName.localName());
        }
        xMLList.setTargets(this, qName);
        for (int i = 0; i < this.length(); ++i) {
            xMLList.addToList(this.getXmlFromAnnotation(i).getPropertyList(xMLName));
        }
        return xMLList;
    }

    private Object applyOrCall(boolean bl, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        String string;
        String string2 = string = bl ? "apply" : "call";
        if (!(scriptable2 instanceof XMLList) || ((XMLList)scriptable2).targetProperty == null) {
            throw ScriptRuntime.typeError1("msg.isnt.function", string);
        }
        return ScriptRuntime.applyOrCall(bl, context, scriptable, scriptable2, objectArray);
    }

    protected Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (objectArray.length == 0) {
            return new XMLList(this.lib);
        }
        Object object = objectArray[0];
        if (!bl && object instanceof XMLList) {
            return object;
        }
        return new XMLList(this.lib, object);
    }

    XmlObject getXmlObject() {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0).getXmlObject();
        }
        throw ScriptRuntime.typeError("getXmlObject method works only on lists containing one item");
    }

    public Scriptable getExtraMethodSource(Context context) {
        if (this.length() == 1) {
            return this.getXmlFromAnnotation(0);
        }
        return null;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (this.targetProperty == null) {
            throw ScriptRuntime.notFunctionError(this);
        }
        String string = this.targetProperty.getLocalPart();
        boolean bl = string.equals("apply");
        if (bl || string.equals("call")) {
            return this.applyOrCall(bl, context, scriptable, scriptable2, objectArray);
        }
        Callable callable = ScriptRuntime.getElemFunctionAndThis(this, string, context);
        ScriptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, objectArray);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw ScriptRuntime.typeError1("msg.not.ctor", "XMLList");
    }

    static class AnnotationList {
        private Vector v = new Vector();

        AnnotationList() {
        }

        void add(XML.XScriptAnnotation xScriptAnnotation) {
            this.v.add(xScriptAnnotation);
        }

        XML.XScriptAnnotation item(int n) {
            return (XML.XScriptAnnotation)this.v.get(n);
        }

        void remove(int n) {
            this.v.remove(n);
        }

        int length() {
            return this.v.size();
        }
    }
}

