/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class SimulationInformation {
    private static Log log = LogFactory.getLog(SimulationInformation.class);
    private static final String START_SIMULATION = "simulationStart";
    private static final String END_SIMULATION = "simulationEnd";
    private static final String EXPORT_TIME = "exportTime";
    private static final String EXPORT_SIZE = "exportSize";
    private static final String EXPORT_EXCEPTION = "exportException";
    private static final String RULE_TIME = "ruleTime";
    private static final String RULE_TIME_INIT = "ruleTime.init";
    private static final String RULE_TIME_PRE = "ruleTime.pre";
    private static final String RULE_TIME_POST = "ruleTime.post";
    private static final String OTHER_INFO = "otherInfo";
    private static final String STATISTIC = "statistic";
    private static final String COMPUTE_RESULT = "computeResult";
    private static final String OPTIMIZATION_USAGE = "optimizationUsage";
    private static final String SIMULATION_EXCEPTION = "exception";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    protected Properties info = new Properties();
    protected File file = null;

    public SimulationInformation(File file) {
        this.file = file;
        this.reloadLocal();
    }

    public void reloadLocal() {
        block8: {
            if (this.file.exists()) {
                try (FileReader reader = new FileReader(this.file);){
                    this.info.load(reader);
                }
                catch (IOException eee) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn((Object)I18n.t((String)"isisfish.error.read.simulation", (Object[])new Object[]{this.file.getPath()}), (Throwable)eee);
                }
            }
        }
    }

    public String toString() {
        Map<String, String> exportException;
        String v;
        String string;
        Set<String> set;
        Map<String, Long> exportSize;
        Object result = "Simulation Information:\n";
        Date start = this.getSimulationStart();
        Date end = this.getSimulationEnd();
        if (start != null && end != null) {
            result = (String)result + "Duration: " + StringUtil.convertTime((long)(start.getTime() * 1000000L), (long)(end.getTime() * 1000000L)) + " Start: " + dateFormat.format(start) + " End: " + dateFormat.format(end) + "\n";
        } else if (start != null) {
            result = (String)result + " Start: " + dateFormat.format(start);
            result = (String)result + " End: N/A\n";
        } else {
            result = (String)result + " Start: N/A";
            result = (String)result + " End: N/A\n";
        }
        result = (String)result + "\n";
        Map<String, Long> exportTime = this.getExportTimes();
        if (exportTime.size() > 0) {
            result = (String)result + "Export time: " + StringUtil.convertTime((long)this.getAllExportTime()) + "\n";
            for (Map.Entry<String, Long> entry : exportTime.entrySet()) {
                result = (String)result + "\t" + entry.getKey() + " : " + StringUtil.convertTime((long)entry.getValue()) + "\n";
            }
        }
        if ((exportSize = this.getExportSizes()).size() > 0) {
            result = (String)result + "Export size: " + StringUtil.convertMemory((long)this.getAllExportSize()) + "\n";
            for (Map.Entry<String, Long> entry : exportSize.entrySet()) {
                result = (String)result + "\t" + entry.getKey() + " : " + StringUtil.convertMemory((long)entry.getValue()) + "\n";
            }
        }
        if ((set = this.getRuleNames()).size() > 0) {
            result = (String)result + "Rule time:\n";
            for (String ruleName : set) {
                Object details = "";
                long total = 0L;
                long time = this.getRuleInitTime(ruleName);
                if (time > 0L) {
                    total += time;
                    details = (String)details + "init:" + DurationFormatUtils.formatDuration((long)time, (String)"s'.'S");
                }
                if ((time = this.getRulePreTime(ruleName)) > 0L) {
                    if (total > 0L) {
                        details = (String)details + ", ";
                    }
                    total += time;
                    details = (String)details + "pre:" + DurationFormatUtils.formatDuration((long)time, (String)"s'.'S");
                }
                if ((time = this.getRulePostTime(ruleName)) > 0L) {
                    if (total > 0L) {
                        details = (String)details + ", ";
                    }
                    total += time;
                    details = (String)details + "post:" + DurationFormatUtils.formatDuration((long)time, (String)"s'.'S");
                }
                if (total <= 0L) continue;
                result = (String)result + "\t" + ruleName + " : " + DurationFormatUtils.formatDuration((long)total, (String)"s'.'S");
                result = (String)result + "s (" + (String)details + ")";
                result = (String)result + "\n";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(string = this.getInformation()))) {
            result = (String)result + "\nInformation:\n\t" + string + "\n";
        }
        if ((v = this.getStatistic()) != null) {
            result = (String)result + "\nStatistic:\n" + v + "\n";
        }
        if ((v = this.getOptimizationUsage()) != null) {
            result = (String)result + "Optimisation usage:\n" + v + "\n";
        }
        if ((v = this.getComputeResult()) != null) {
            result = (String)result + "\nResult compute time:\n" + v + "\n";
        }
        if ((v = this.getException()) != null) {
            result = (String)result + "Simulation exception:\n" + v + "\n";
        }
        if ((exportException = this.getExportExceptions()).size() > 0) {
            result = (String)result + "Export exception:\n ";
            for (Map.Entry<String, String> entry : exportException.entrySet()) {
                result = (String)result + entry.getKey() + " : " + entry.getValue() + "\n\n";
            }
        }
        return result;
    }

    protected void store() {
        block7: {
            try (FileWriter writer = new FileWriter(this.file);){
                this.info.store(writer, "Simulation Information");
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block7;
                log.warn((Object)I18n.t((String)"isisfish.error.write.simulation", (Object[])new Object[]{this.file.getPath()}), (Throwable)eee);
            }
        }
    }

    protected void setInfo(String key, String value) {
        this.info.setProperty(key, value);
        this.store();
    }

    public Date getSimulationStart() {
        Date result;
        block3: {
            String d = this.info.getProperty(START_SIMULATION);
            result = null;
            if (d != null) {
                try {
                    result = dateFormat.parse(d);
                }
                catch (ParseException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n.t((String)"isisfish.error.parse.date", (Object[])new Object[]{d}), (Throwable)eee);
                }
            }
        }
        return result;
    }

    public void setSimulationStart(Date date) {
        this.setInfo(START_SIMULATION, dateFormat.format(date));
    }

    public Date getSimulationEnd() {
        Date result;
        block3: {
            String d = this.info.getProperty(END_SIMULATION);
            result = null;
            if (d != null) {
                try {
                    result = dateFormat.parse(d);
                }
                catch (ParseException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n.t((String)"isisfish.error.parse.date", (Object[])new Object[]{d}), (Throwable)eee);
                }
            }
        }
        return result;
    }

    public void setSimulationEnd(Date date) {
        this.setInfo(END_SIMULATION, dateFormat.format(date));
    }

    public void addExportTime(String exportName, long time) {
        this.setInfo("exportTime." + exportName, String.valueOf(time));
    }

    public void addExportSize(String exportName, long size) {
        this.setInfo("exportSize." + exportName, String.valueOf(size));
    }

    public void addExportException(String exportName, Throwable eee) {
        this.setInfo("exportException." + exportName, this.exceptionToString(eee));
    }

    public void addAllExportTime(long time) {
        this.setInfo(EXPORT_TIME, String.valueOf(time));
    }

    public void addAllExportSize(long size) {
        this.setInfo(EXPORT_SIZE, String.valueOf(size));
    }

    protected Map<String, Long> getExportTimes() {
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        for (String key : this.info.stringPropertyNames()) {
            if (!key.startsWith("exportTime.")) continue;
            String exportName = key.substring(EXPORT_TIME.length() + 1);
            result.put(exportName, this.getExportTime(exportName));
        }
        return result;
    }

    protected Map<String, Long> getExportSizes() {
        TreeMap<String, Long> result = new TreeMap<String, Long>();
        for (String key : this.info.stringPropertyNames()) {
            if (!key.startsWith("exportSize.")) continue;
            String exportName = key.substring(EXPORT_SIZE.length() + 1);
            result.put(exportName, this.getExportSize(exportName));
        }
        return result;
    }

    protected Map<String, String> getExportExceptions() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String key : this.info.stringPropertyNames()) {
            if (!key.startsWith("exportException.")) continue;
            String exportName = key.substring(EXPORT_EXCEPTION.length() + 1);
            result.put(exportName, this.info.getProperty(key));
        }
        return result;
    }

    public Map<String, Long> getExportTime() {
        return this.getExportTimes();
    }

    protected long getLong(String prop) {
        long result;
        block3: {
            String t = this.info.getProperty(prop);
            result = 0L;
            if (t != null) {
                try {
                    result = Long.parseLong(t);
                }
                catch (NumberFormatException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n.t((String)"isisfish.error.parse.long", (Object[])new Object[]{t}), (Throwable)eee);
                }
            }
        }
        return result;
    }

    public long getExportTime(String exportName) {
        Object prop = EXPORT_TIME;
        if (StringUtils.isNotEmpty((CharSequence)exportName)) {
            prop = (String)prop + "." + exportName;
        }
        return this.getLong((String)prop);
    }

    public long getExportSize(String exportName) {
        Object prop = EXPORT_SIZE;
        if (StringUtils.isNotEmpty((CharSequence)exportName)) {
            prop = (String)prop + "." + exportName;
        }
        return this.getLong((String)prop);
    }

    public long getAllExportTime() {
        return this.getExportTime(null);
    }

    public long getAllExportSize() {
        return this.getExportSize(null);
    }

    protected void addRuleTime(String keyName, String ruleName, long time) {
        long previousTime;
        block3: {
            String previousTimeAsString = this.info.getProperty(keyName + "." + ruleName);
            previousTime = 0L;
            if (previousTimeAsString != null) {
                try {
                    previousTime = Long.parseLong(previousTimeAsString);
                }
                catch (NumberFormatException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n.t((String)"isisfish.error.parse.long", (Object[])new Object[]{previousTimeAsString}), (Throwable)eee);
                }
            }
        }
        long newTime = previousTime + time;
        this.setInfo(keyName + "." + ruleName, String.valueOf(newTime));
    }

    public void addRuleInitTime(String ruleName, long time) {
        this.addRuleTime(RULE_TIME_INIT, ruleName, time);
    }

    public void addRulePreTime(String ruleName, long time) {
        this.addRuleTime(RULE_TIME_PRE, ruleName, time);
    }

    public void addRulePostTime(String ruleName, long time) {
        this.addRuleTime(RULE_TIME_POST, ruleName, time);
    }

    public long getRuleInitTime(String ruleName) {
        return this.getRuleTime(RULE_TIME_INIT, ruleName);
    }

    public long getRulePreTime(String ruleName) {
        return this.getRuleTime(RULE_TIME_PRE, ruleName);
    }

    public long getRulePostTime(String ruleName) {
        return this.getRuleTime(RULE_TIME_POST, ruleName);
    }

    protected long getRuleTime(String prefixName, String ruleName) {
        long result;
        block3: {
            String t = this.info.getProperty(prefixName + "." + ruleName);
            result = 0L;
            if (t != null) {
                try {
                    result = Long.parseLong(t);
                }
                catch (NumberFormatException eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)I18n.t((String)"isisfish.error.parse.long", (Object[])new Object[]{t}), (Throwable)eee);
                }
            }
        }
        return result;
    }

    protected Set<String> getRuleNames() {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.info.stringPropertyNames()) {
            if (!key.startsWith("ruleTime.")) continue;
            String ruleName = key.substring(key.indexOf(46, RULE_TIME.length() + 1) + 1);
            result.add(ruleName);
        }
        return result;
    }

    public String getStatistic() {
        String result = this.info.getProperty(STATISTIC);
        return result;
    }

    public void setStatistic(String v) {
        this.setInfo(STATISTIC, v);
    }

    public String getComputeResult() {
        String result = this.info.getProperty(COMPUTE_RESULT);
        return result;
    }

    public void setComputeResult(String v) {
        this.setInfo(COMPUTE_RESULT, v);
    }

    public String getOptimizationUsage() {
        String result = this.info.getProperty(OPTIMIZATION_USAGE);
        return result;
    }

    public void setOptimizationUsage(String v) {
        this.setInfo(OPTIMIZATION_USAGE, v);
    }

    public String getException() {
        String result = this.info.getProperty(SIMULATION_EXCEPTION);
        return result;
    }

    public void setException(Throwable eee) {
        String v = this.exceptionToString(eee);
        this.setInfo(SIMULATION_EXCEPTION, v);
    }

    protected String exceptionToString(Throwable eee) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        eee.printStackTrace(pw);
        String v = w.getBuffer().toString();
        return v;
    }

    public boolean hasError() {
        boolean result = this.getException() != null && this.getException().length() > 0;
        return result;
    }

    public String getInfomation() {
        return this.getInformation();
    }

    protected String getInformation() {
        String result = this.info.getProperty(OTHER_INFO);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void addInformation(String info) {
        this.setInfo(OTHER_INFO, this.getInformation() + info + "\n\n");
    }
}

