/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamNameRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamValueEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamValueRenderer;
import fr.ifremer.isisfish.ui.simulator.PlanUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import fr.ifremer.isisfish.ui.widget.editor.ScriptParameterDialog;
import java.awt.Component;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import jaxx.runtime.JAXXContext;

public class PlanHandler
extends SimulatorTabHandler {
    protected PlanUI planUI;
    protected StorageChangeListener simulationPlanStorageListener;

    protected PlanHandler(PlanUI planUI) {
        super(planUI);
        this.planUI = planUI;
    }

    protected void initSimulationPlansComboModel(StorageChangeEvent evt) {
        this.planUI.fieldSimulParamsSimulationPlansModel.setElementList(SimulationPlanStorage.getSimulationPlanNames());
    }

    protected void initSimulationSimulationPlansListModel() {
        this.planUI.listSimulParamsSimulationPlansModel.setElementList(this.getParamSimulationPlans());
    }

    protected void afterInit() {
        this.simulationPlanStorageListener = this::initSimulationPlansComboModel;
        SimulationPlanStorage.addStorageListener(this.simulationPlanStorageListener);
        this.initSimulationPlansComboModel(null);
        this.initSimulationSimulationPlansListModel();
    }

    protected void switchSimulationPlanEnabled() {
        boolean selected = this.planUI.fieldSimulUseSimulationPlan.isSelected();
        this.getParameters().setUseSimulationPlan(selected);
        this.setTabSelectedIcon((Component)((Object)this.planUI), selected);
        this.planUI.fieldSimulParamsSimulationPlansSelect.setSelectedItem(null);
        this.planUI.listSimulParamsSimulationPlansList.clearSelection();
    }

    public void refresh() {
        this.planUI.fieldSimulUseSimulationPlan.setSelected(this.getParameters().getUseSimulationPlan());
        this.initSimulationPlansComboModel(null);
        this.initSimulationSimulationPlansListModel();
    }

    public List<SimulationPlan> getParamSimulationPlans() {
        return this.getParameters().getSimulationPlans();
    }

    protected void addSimulationPlan(PlanUI planUI, String name) {
        try {
            SimulationPlan sp = (SimulationPlan)SimulationPlanStorage.getSimulationPlan(name, new CodeSourceStorage.Location[0]).getNewInstance();
            sp = (SimulationPlan)ScriptParameterDialog.displayConfigurationFrame((JAXXContext)planUI, sp);
            if (sp != null) {
                this.getParameters().addSimulationPlan(sp);
            }
        }
        catch (IsisFishException ex) {
            throw new IsisFishRuntimeException("Can't add simulation plan", ex);
        }
    }

    protected void addSimulationPlan() {
        String selectedSimulationPlanName = (String)this.planUI.fieldSimulParamsSimulationPlansSelect.getSelectedItem();
        this.addSimulationPlan(this.planUI, selectedSimulationPlanName);
        this.initSimulationSimulationPlansListModel();
    }

    protected void removeSimulationPlan() {
        SimulationPlan selectedSimulationPlan = this.planUI.listSimulParamsSimulationPlansList.getSelectedValue();
        this.getParameters().removeSimulationPlan(selectedSimulationPlan);
        this.initSimulationSimulationPlansListModel();
        this.planUI.listSimulParamsSimulationPlansList.setSelectedValue(null, false);
    }

    protected void setSimulParamsSimulationPlans() {
        SimulationPlan selectedSimulationPlan = this.planUI.listSimulParamsSimulationPlansList.getSelectedValue();
        if (selectedSimulationPlan != null) {
            ScriptParametersParamModel model = new ScriptParametersParamModel(selectedSimulationPlan);
            this.planUI.simulParamsSimulationPlans.setModel(model);
            ScriptParametersParamNameRenderer nameRenderer = new ScriptParametersParamNameRenderer(selectedSimulationPlan);
            this.planUI.simulParamsSimulationPlans.getColumnModel().getColumn(0).setCellRenderer(nameRenderer);
            ScriptParametersParamValueRenderer valueRenderer = new ScriptParametersParamValueRenderer();
            this.planUI.simulParamsSimulationPlans.getColumnModel().getColumn(1).setCellRenderer(valueRenderer);
            ScriptParametersParamValueEditor cellEditor = new ScriptParametersParamValueEditor(selectedSimulationPlan);
            cellEditor.setRegionStorage(this.planUI.getContextValue(RegionStorage.class));
            this.planUI.simulParamsSimulationPlans.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        } else {
            this.planUI.simulParamsSimulationPlans.setModel(new DefaultTableModel());
        }
    }
}

