/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.aspect.ComputeResultTrace;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.ActiveRuleDAO;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.FisheryRegionDAO;
import fr.ifremer.isisfish.entities.GearDAO;
import fr.ifremer.isisfish.entities.MetierDAO;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.ObservationDAO;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoDAO;
import fr.ifremer.isisfish.entities.PortDAO;
import fr.ifremer.isisfish.entities.ResultDAO;
import fr.ifremer.isisfish.entities.SeasonDAO;
import fr.ifremer.isisfish.entities.SelectivityDAO;
import fr.ifremer.isisfish.entities.SetOfVesselsDAO;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.entities.StrategyDAO;
import fr.ifremer.isisfish.entities.StrategyMonthInfoDAO;
import fr.ifremer.isisfish.entities.TargetSpeciesDAO;
import fr.ifremer.isisfish.entities.TripTypeDAO;
import fr.ifremer.isisfish.entities.VariableDAO;
import fr.ifremer.isisfish.entities.VesselTypeDAO;
import fr.ifremer.isisfish.entities.ZoneDAO;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.PopulationMonitor;
import fr.ifremer.isisfish.simulator.ResultManager;
import fr.ifremer.isisfish.simulator.RuleMonitor;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationListener;
import fr.ifremer.isisfish.simulator.SimulationResultListener;
import fr.ifremer.isisfish.simulator.SimulationVariable;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityUtils;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.cache.IsisCache;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.OverwriteApplicationConfig;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.profiling.Statistic;
import org.nuiton.profiling.Trace;
import org.nuiton.profiling.Unit;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class SimulationContext {
    private static Log log = LogFactory.getLog(SimulationContext.class);
    protected ApplicationConfig config;
    protected Map<String, Object> values = new HashMap<String, Object>();
    protected SimulationStorage simulation = null;
    protected SimulationControl simulationControl = null;
    protected PopulationMonitor populationMonitor = null;
    protected MetierMonitor metierMonitor = null;
    protected RuleMonitor ruleMonitor = null;
    protected ResultManager resultManager = null;
    protected Set<SimulationListener> simulationListeners = new LinkedHashSet<SimulationListener>();
    protected PropertyChangeListener stepListener = evt -> {
        Integer i = (Integer)evt.getNewValue();
        this.fireStepChange(new TimeStep(i));
        Statistic stat = this.timeStepStat;
        stat.add((long)i.intValue());
        this.getSimulationControl().setTimeStepMeanTime(Unit.Time.nano.convertTo(Unit.Time.s, stat.getMean()));
    };
    protected Statistic timeStepStat = new Statistic("Step time"){
        protected long lastTime;
        {
            this.lastTime = 0L;
        }

        public void add(long value) {
            if (this.lastTime == 0L) {
                this.lastTime = System.nanoTime();
            } else {
                long newTime = System.nanoTime();
                long delta = newTime - this.lastTime;
                this.lastTime = newTime;
                super.add(delta);
            }
        }

        public String formatValue(long value) {
            String result = String.valueOf(Unit.Time.nano.convertTo(Unit.Time.s, (double)value));
            return result;
        }
    };
    protected ClassLoader classLoader = null;
    protected Map<String, ClassLoader> equationClassLoaders = new HashMap<String, ClassLoader>();
    protected File scriptDirectory;
    protected Trace trace;
    protected ComputeResultTrace computeResultTrace;
    protected IsisCache cache;
    protected TopiaContext db = null;
    protected TopiaContext dbResult = null;
    protected Map<TopiaEntity, SimulationVariable> variablesCache = new HashMap<TopiaEntity, SimulationVariable>();
    protected Map<String, Double> contextEquationValue = new HashMap<String, Double>();
    private static ThreadLocal<SimulationContext> simulationContext = new ThreadLocal<SimulationContext>(){

        @Override
        protected synchronized SimulationContext initialValue() {
            return new SimulationContext();
        }
    };

    protected SimulationContext() {
    }

    public void initForSimulation() {
        MatrixFactory.initMatrixFactoryThreadLocal(IsisFish.config.getSimulationMatrixVectorClass(), IsisFish.config.getSimulationMatrixVectorSparseClass(), (int)IsisFish.config.getSimulationMatrixThresholdUseSparse(), (boolean)IsisFish.config.getSimulationMatrixdUseLazyVector());
    }

    public static SimulationContext get() {
        return simulationContext.get();
    }

    public static void remove() {
        SimulationContext current = SimulationContext.get();
        current.getCache().clear();
        current.cache = null;
        current.getTrace().clearStatistics();
        current.trace = null;
        current.computeResultTrace = null;
        current.values.clear();
        current.classLoader = null;
        current.equationClassLoaders = null;
        simulationContext.remove();
    }

    public ApplicationConfig getConfig() {
        if (this.config == null) {
            if (this.getSimulationStorage() != null) {
                Map<String, String> tv = this.getSimulationStorage().getParameter().getTagValue();
                this.config = new OverwriteApplicationConfig((ApplicationConfig)IsisFish.config, tv);
            } else {
                this.config = IsisFish.config;
            }
        }
        return this.config;
    }

    public void addSimulationListener(SimulationListener l) {
        this.simulationListeners.add(l);
        if (l instanceof SimulationResultListener) {
            this.getResultManager().addSimulationResultListener((SimulationResultListener)l);
        }
    }

    public void closeDB() {
        block3: {
            if (this.db != null) {
                try {
                    this.db.closeContext();
                }
                catch (TopiaException eee) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Can't close simulation topia context", (Throwable)eee);
                }
            }
        }
    }

    @Deprecated
    public void closeDBResult() {
        block3: {
            if (this.dbResult != null) {
                try {
                    this.dbResult.commitTransaction();
                    this.dbResult.closeContext();
                }
                catch (TopiaException eee) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Can't close simulation result topia context", (Throwable)eee);
                }
            }
        }
    }

    public void removeSimulationListener(SimulationListener l) {
        this.simulationListeners.remove(l);
        if (l instanceof SimulationResultListener) {
            this.getResultManager().addSimulationResultListener((SimulationResultListener)l);
        }
    }

    public void fireBeforeSimulation() {
        for (SimulationListener l : this.simulationListeners) {
            l.beforeSimulation(this);
        }
    }

    public void fireStepChange(TimeStep step) {
        for (SimulationListener l : this.simulationListeners) {
            l.stepChange(this, step);
        }
    }

    public void fireAfterSimulation() {
        for (SimulationListener l : this.simulationListeners) {
            l.afterSimulation(this);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Map<String, ClassLoader> getEquationClassLoaders() {
        return this.equationClassLoaders;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Trace getTrace() {
        if (this.trace == null) {
            this.trace = new Trace(false, false);
        }
        return this.trace;
    }

    public ComputeResultTrace getComputeResultTrace() {
        if (this.computeResultTrace == null) {
            this.computeResultTrace = new ComputeResultTrace(false, false);
        }
        return this.computeResultTrace;
    }

    public IsisCache getCache() {
        if (this.cache == null) {
            this.cache = new IsisCache();
        }
        return this.cache;
    }

    public Object getValue(String name) {
        Object result = this.values.get(name);
        return result;
    }

    public void setValue(String name, Object value) {
        this.values.put(name, value);
    }

    public SimulationStorage getSimulationStorage() {
        return this.simulation;
    }

    public void setSimulationStorage(SimulationStorage simulation) {
        this.simulation = simulation;
    }

    public Statistic getTimeStepStat() {
        return this.timeStepStat;
    }

    public SimulationControl getSimulationControl() {
        return this.simulationControl;
    }

    public void setSimulationControl(SimulationControl simulationControl) {
        if (this.simulationControl != simulationControl) {
            if (this.simulationControl != null) {
                this.simulationControl.removePropertyChangeListener("step", this.stepListener);
            }
            this.simulationControl = simulationControl;
            if (simulationControl != null) {
                simulationControl.addPropertyChangeListener("step", this.stepListener);
            }
        }
    }

    public PopulationMonitor getPopulationMonitor() {
        if (this.populationMonitor == null) {
            this.populationMonitor = new PopulationMonitor();
        }
        return this.populationMonitor;
    }

    public MetierMonitor getMetierMonitor() {
        if (this.metierMonitor == null) {
            this.metierMonitor = new MetierMonitor();
        }
        return this.metierMonitor;
    }

    public RuleMonitor getRuleMonitor() {
        if (this.ruleMonitor == null) {
            this.ruleMonitor = new RuleMonitor();
        }
        return this.ruleMonitor;
    }

    public ResultManager getResultManager() {
        if (this.resultManager == null) {
            this.resultManager = new ResultManager(this);
        }
        return this.resultManager;
    }

    public TopiaContext getDB() throws TopiaException {
        if (this.db == null && this.getSimulationStorage() != null) {
            this.db = this.getSimulationStorage().getMemStorage().beginTransaction();
        }
        return this.db;
    }

    @Deprecated
    public TopiaContext getDbResult() throws TopiaException {
        if (this.dbResult == null && this.getSimulationStorage() != null) {
            this.dbResult = this.getSimulationStorage().getStorage().beginTransaction();
        }
        return this.dbResult;
    }

    @Deprecated
    public void clearCache(TimeStep step) throws TopiaException {
        this.getCache().clear(step);
    }

    public File getScriptDirectory() {
        return this.scriptDirectory;
    }

    public void setScriptDirectory(File scriptDirectory) {
        this.scriptDirectory = scriptDirectory;
    }

    public void message(String message) {
        log.info((Object)message);
        if (this.getSimulationControl() != null) {
            this.getSimulationControl().setText(message);
        }
    }

    public void setComputeValue(String key, Double value) {
        String localKey = SensitivityUtils.espaceFactorName(key);
        this.contextEquationValue.put(localKey, value);
    }

    public double getValueAndCompute(String key, double defaultValue) {
        double result;
        String localKey = SensitivityUtils.espaceFactorName(key);
        if (this.contextEquationValue.containsKey(localKey)) {
            Double value = this.contextEquationValue.get(localKey);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found key '" + localKey + "' current value = " + value));
            }
            result = value;
        } else {
            result = defaultValue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("No key defined for key '" + localKey + "' in context"));
            }
        }
        return result;
    }

    public SimulationVariable get(TopiaEntity entity) {
        SimulationVariable v = this.variablesCache.getOrDefault(entity, new SimulationVariable(this, entity));
        return v;
    }

    public void rollbackRuleChanges() throws TopiaException {
        if (this.db != null) {
            this.db.rollbackTransaction();
        }
    }

    public void validateDBChanges() throws TopiaException {
        if (this.db != null) {
            this.db.commitTransaction();
        }
    }

    @Deprecated
    public void commitResults() throws TopiaException {
        TopiaContext tx = this.getDbResult();
        tx.commitTransaction();
    }

    public ActiveRuleDAO getActiveRuleDAO() throws TopiaException {
        return IsisFishDAOHelper.getActiveRuleDAO(this.getDB());
    }

    public CellDAO getCellDAO() throws TopiaException {
        return IsisFishDAOHelper.getCellDAO(this.getDB());
    }

    public EffortDescriptionDAO getEffortDescriptionDAO() throws TopiaException {
        return IsisFishDAOHelper.getEffortDescriptionDAO(this.getDB());
    }

    public EquationDAO getEquationDAO() throws TopiaException {
        return IsisFishDAOHelper.getEquationDAO(this.getDB());
    }

    public FisheryRegionDAO getFisheryRegionDAO() throws TopiaException {
        return IsisFishDAOHelper.getFisheryRegionDAO(this.getDB());
    }

    public GearDAO getGearDAO() throws TopiaException {
        return IsisFishDAOHelper.getGearDAO(this.getDB());
    }

    public MetierDAO getMetierDAO() throws TopiaException {
        return IsisFishDAOHelper.getMetierDAO(this.getDB());
    }

    public MetierSeasonInfoDAO getMetierSeasonInfoDAO() throws TopiaException {
        return IsisFishDAOHelper.getMetierSeasonInfoDAO(this.getDB());
    }

    public ObservationDAO getObservationDAO() throws TopiaException {
        return IsisFishDAOHelper.getObservationDAO(this.getDB());
    }

    public PopulationDAO getPopulationDAO() throws TopiaException {
        return IsisFishDAOHelper.getPopulationDAO(this.getDB());
    }

    public PopulationGroupDAO getPopulationGroupDAO() throws TopiaException {
        return IsisFishDAOHelper.getPopulationGroupDAO(this.getDB());
    }

    public PopulationSeasonInfoDAO getPopulationSeasonInfoDAO() throws TopiaException {
        return IsisFishDAOHelper.getPopulationSeasonInfoDAO(this.getDB());
    }

    public PortDAO getPortDAO() throws TopiaException {
        return IsisFishDAOHelper.getPortDAO(this.getDB());
    }

    public ResultDAO getResultDAO() throws TopiaException {
        return IsisFishDAOHelper.getResultDAO(this.getDB());
    }

    public SeasonDAO getSeasonDAO() throws TopiaException {
        return IsisFishDAOHelper.getSeasonDAO(this.getDB());
    }

    public SelectivityDAO getSelectivityDAO() throws TopiaException {
        return IsisFishDAOHelper.getSelectivityDAO(this.getDB());
    }

    public SetOfVesselsDAO getSetOfVesselsDAO() throws TopiaException {
        return IsisFishDAOHelper.getSetOfVesselsDAO(this.getDB());
    }

    public SpeciesDAO getSpeciesDAO() throws TopiaException {
        return IsisFishDAOHelper.getSpeciesDAO(this.getDB());
    }

    public StrategyDAO getStrategyDAO() throws TopiaException {
        return IsisFishDAOHelper.getStrategyDAO(this.getDB());
    }

    public StrategyMonthInfoDAO getStrategyMonthInfoDAO() throws TopiaException {
        return IsisFishDAOHelper.getStrategyMonthInfoDAO(this.getDB());
    }

    public TargetSpeciesDAO getTargetSpeciesDAO() throws TopiaException {
        return IsisFishDAOHelper.getTargetSpeciesDAO(this.getDB());
    }

    public TripTypeDAO getTripTypeDAO() throws TopiaException {
        return IsisFishDAOHelper.getTripTypeDAO(this.getDB());
    }

    public VariableDAO getVariableDAO() throws TopiaException {
        return IsisFishDAOHelper.getVariableDAO(this.getDB());
    }

    public VesselTypeDAO getVesselTypeDAO() throws TopiaException {
        return IsisFishDAOHelper.getVesselTypeDAO(this.getDB());
    }

    public ZoneDAO getZoneDAO() throws TopiaException {
        return IsisFishDAOHelper.getZoneDAO(this.getDB());
    }
}

