/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.result;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ResultInfoStorage;
import fr.ifremer.isisfish.result.ResultInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultInfoHelper {
    private static Log log = LogFactory.getLog(ResultInfoHelper.class);

    public static Set<String> cleanResultNames(Collection<String> results) {
        HashSet<String> returnSet = new HashSet<String>();
        for (String result : results) {
            String cleanResult = StringUtils.removeEndIgnoreCase((String)result, (String)".java");
            returnSet.add(cleanResult);
        }
        return returnSet;
    }

    public static Set<String> extractAllNecessaryResults(Set<String> currentResult) {
        HashSet<String> destResult = new HashSet<String>();
        HashSet<String> inputResult = new HashSet<String>(currentResult);
        ResultInfoHelper.extractRecursiveResults(inputResult, destResult);
        return destResult;
    }

    protected static void extractRecursiveResults(Set<String> inputResult, Set<String> destResult) {
        Collection unexplored = CollectionUtils.subtract(inputResult, destResult);
        for (String result : unexplored) {
            destResult.add(result);
            try {
                ResultInfoStorage storage = ResultInfoStorage.getResultInfo(result, new CodeSourceStorage.Location[0]);
                if (storage == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Can't find result : " + result));
                    continue;
                }
                ResultInfo resultInfo = (ResultInfo)storage.getNewInstance();
                if (resultInfo.getNecessaryResult() == null) continue;
                Collections.addAll(inputResult, resultInfo.getNecessaryResult());
            }
            catch (IsisFishException ex) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Result class can't be compiled", (Throwable)ex);
            }
        }
        if (!unexplored.isEmpty()) {
            ResultInfoHelper.extractRecursiveResults(inputResult, destResult);
        }
    }
}

