/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.types.RangeOfValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class GearAbstract
extends TopiaEntityAbstract
implements Gear {
    protected String name;
    protected String effortUnit;
    protected double standardisationFactor;
    protected String parameterName;
    protected double cost;
    protected RangeOfValues possibleValue;
    protected String comment;
    protected Collection<Selectivity> populationSelectivity;
    private static final long serialVersionUID = 3847588526840636258L;

    public void update() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Gear.class).update((TopiaEntity)this);
    }

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Gear.class).delete((TopiaEntity)this);
    }

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        this.accept0(visitor);
        visitor.end((TopiaEntity)this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "effortUnit", String.class, (Object)this.effortUnit);
        visitor.visit((TopiaEntity)this, "standardisationFactor", Double.TYPE, (Object)this.standardisationFactor);
        visitor.visit((TopiaEntity)this, "parameterName", String.class, (Object)this.parameterName);
        visitor.visit((TopiaEntity)this, "cost", Double.TYPE, (Object)this.cost);
        visitor.visit((TopiaEntity)this, "possibleValue", RangeOfValues.class, (Object)this.possibleValue);
        visitor.visit((TopiaEntity)this, "comment", String.class, (Object)this.comment);
        visitor.visit((TopiaEntity)this, "populationSelectivity", Collection.class, Selectivity.class, this.populationSelectivity);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setEffortUnit(String effortUnit) {
        String oldValue = this.effortUnit;
        this.fireOnPreWrite("effortUnit", oldValue, effortUnit);
        this.effortUnit = effortUnit;
        this.fireOnPostWrite("effortUnit", oldValue, effortUnit);
    }

    @Override
    public String getEffortUnit() {
        String result = this.effortUnit;
        return result;
    }

    @Override
    public void setStandardisationFactor(double standardisationFactor) {
        double oldValue = this.standardisationFactor;
        this.fireOnPreWrite("standardisationFactor", oldValue, standardisationFactor);
        this.standardisationFactor = standardisationFactor;
        this.fireOnPostWrite("standardisationFactor", oldValue, standardisationFactor);
    }

    @Override
    public double getStandardisationFactor() {
        double result = this.standardisationFactor;
        return result;
    }

    @Override
    public void setParameterName(String parameterName) {
        String oldValue = this.parameterName;
        this.fireOnPreWrite("parameterName", oldValue, parameterName);
        this.parameterName = parameterName;
        this.fireOnPostWrite("parameterName", oldValue, parameterName);
    }

    @Override
    public String getParameterName() {
        String result = this.parameterName;
        return result;
    }

    @Override
    public void setCost(double cost) {
        double oldValue = this.cost;
        this.fireOnPreWrite("cost", oldValue, cost);
        this.cost = cost;
        this.fireOnPostWrite("cost", oldValue, cost);
    }

    @Override
    public double getCost() {
        double result = this.cost;
        return result;
    }

    @Override
    public void setPossibleValue(RangeOfValues possibleValue) {
        RangeOfValues oldValue = this.possibleValue;
        this.fireOnPreWrite("possibleValue", oldValue, possibleValue);
        this.possibleValue = possibleValue;
        this.fireOnPostWrite("possibleValue", oldValue, possibleValue);
    }

    @Override
    public RangeOfValues getPossibleValue() {
        RangeOfValues result = this.possibleValue;
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        this.fireOnPreWrite("comment", oldValue, comment);
        this.comment = comment;
        this.fireOnPostWrite("comment", oldValue, comment);
    }

    @Override
    public String getComment() {
        String result = this.comment;
        return result;
    }

    @Override
    public void addPopulationSelectivity(Selectivity populationSelectivity) {
        this.fireOnPreWrite("populationSelectivity", null, populationSelectivity);
        if (this.populationSelectivity == null) {
            this.populationSelectivity = new ArrayList<Selectivity>();
        }
        this.populationSelectivity.add(populationSelectivity);
        this.fireOnPostWrite("populationSelectivity", this.populationSelectivity.size(), null, populationSelectivity);
    }

    @Override
    public void addAllPopulationSelectivity(Collection<Selectivity> populationSelectivity) {
        if (populationSelectivity == null) {
            return;
        }
        for (Selectivity item : populationSelectivity) {
            this.addPopulationSelectivity(item);
        }
    }

    @Override
    public void setPopulationSelectivity(Collection<Selectivity> populationSelectivity) {
        ArrayList<Selectivity> oldValue = this.populationSelectivity != null ? new ArrayList<Selectivity>(this.populationSelectivity) : null;
        this.fireOnPreWrite("populationSelectivity", oldValue, populationSelectivity);
        this.populationSelectivity = populationSelectivity;
        this.fireOnPostWrite("populationSelectivity", oldValue, populationSelectivity);
    }

    @Override
    public void removePopulationSelectivity(Selectivity populationSelectivity) {
        this.fireOnPreWrite("populationSelectivity", populationSelectivity, null);
        if (this.populationSelectivity == null || !this.populationSelectivity.remove(populationSelectivity)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("populationSelectivity", this.populationSelectivity.size() + 1, populationSelectivity, null);
    }

    @Override
    public void clearPopulationSelectivity() {
        if (this.populationSelectivity == null) {
            return;
        }
        ArrayList<Selectivity> oldValue = new ArrayList<Selectivity>(this.populationSelectivity);
        this.fireOnPreWrite("populationSelectivity", oldValue, this.populationSelectivity);
        this.populationSelectivity.clear();
        this.fireOnPostWrite("populationSelectivity", oldValue, this.populationSelectivity);
    }

    @Override
    public Collection<Selectivity> getPopulationSelectivity() {
        return this.populationSelectivity;
    }

    @Override
    public Selectivity getPopulationSelectivityByTopiaId(String topiaId) {
        return (Selectivity)TopiaEntityHelper.getEntityByTopiaId(this.populationSelectivity, (String)topiaId);
    }

    @Override
    public Selectivity getPopulationSelectivity(Population population) {
        if (population == null || this.populationSelectivity == null) {
            return null;
        }
        for (Selectivity item : this.populationSelectivity) {
            if (!population.equals(item.getPopulation())) continue;
            return item;
        }
        return null;
    }

    @Override
    public int sizePopulationSelectivity() {
        if (this.populationSelectivity == null) {
            return 0;
        }
        return this.populationSelectivity.size();
    }

    @Override
    public boolean isPopulationSelectivityEmpty() {
        int size = this.sizePopulationSelectivity();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList tmp = new ArrayList();
        TopiaDAO dao = ((TopiaContextImplementor)this.getTopiaContext()).getDAO(Selectivity.class);
        List findAllByProperties = dao.findAllByProperties("gear", (Object)this, new Object[0]);
        if (findAllByProperties != null) {
            tmp.addAll(findAllByProperties);
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity == null) continue;
            result.add(entity);
            result.addAll(entity.getComposite());
        }
        return result;
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("effortUnit", (Object)this.effortUnit).append("standardisationFactor", this.standardisationFactor).append("parameterName", (Object)this.parameterName).append("cost", this.cost).append("possibleValue", (Object)this.possibleValue).append("comment", (Object)this.comment).toString();
        return result;
    }
}

