/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.aspect.AspectJUrlClassLoader;
import fr.ifremer.isisfish.aspect.CacheAspect;
import fr.ifremer.isisfish.aspect.RuleAspect;
import fr.ifremer.isisfish.aspect.TraceAspect;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationExportResultWrapper;
import fr.ifremer.isisfish.simulator.SimulationListener;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPreScriptListener;
import fr.ifremer.isisfish.simulator.Simulator;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.CompileHelper;
import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionListener;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.StringUtil;

public class InProcessSimulatorLauncher
implements SimulatorLauncher {
    private static Log log = LogFactory.getLog(InProcessSimulatorLauncher.class);
    protected SimulationStorage simulation;

    @Override
    public void simulate(SimulationService simulationService, SimulationItem simulationItem) throws RemoteException {
        block8: {
            SimulationControl control = simulationItem.getControl();
            File simulationZip = simulationItem.getSimulationZip();
            String generatedPrescript = simulationItem.getGeneratedPrescriptContent();
            String id = control.getId();
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"simulate %s with file %s", (Object[])new Object[]{id, simulationZip}));
            }
            try {
                if (SimulationStorage.localyExists(id)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Warning , simulation " + id + " aleady exists"));
                        log.warn((Object)"Deleting it before doing simulation");
                    }
                    SimulationStorage storage = SimulationStorage.getSimulation(id);
                    storage.closeStorage();
                    FileUtils.deleteQuietly((File)storage.getFile());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Timing : before import zip : " + new Date()));
                }
                this.simulation = SimulationStorage.importAndRenameZip(simulationZip, id);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Timing : after import zip : " + new Date()));
                }
                SimulationParameter param = this.simulation.getParameter();
                control.setStep(new TimeStep());
                control.setProgress(0L);
                control.setStarted(true);
                if (StringUtils.isNotBlank((CharSequence)generatedPrescript)) {
                    param.setGeneratedPreScript(generatedPrescript);
                }
                int lastYear = param.getNumberOfYear();
                int lastDate = lastYear * Month.NUMBER_OF_MONTH;
                control.setProgressMax(lastDate);
                this.simulation = this.localSimulate(control, this.simulation);
            }
            catch (Exception eee) {
                log.error((Object)I18n.t((String)"Can't do simulation %s", (Object[])new Object[]{id}), (Throwable)eee);
                if (this.simulation == null) break block8;
                this.simulation.getInformation().setException(eee);
            }
        }
    }

    @Override
    public SimulationStorage getSimulationStorage(SimulationService simulationService, SimulationControl control) throws RemoteException {
        return this.simulation;
    }

    @Override
    public void updateControl(SimulationService simulationService, SimulationControl control) throws RemoteException {
    }

    @Override
    public int maxSimulationThread() {
        return IsisFish.config.getSimulatorInMaxThreads();
    }

    @Override
    public int getCheckProgressionInterval() {
        int interval = 1;
        return interval;
    }

    public String toString() {
        return I18n.t((String)"isisfish.simulator.launcher.inprocess", (Object[])new Object[0]);
    }

    protected void message(SimulationControl control, String message) {
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
        if (control != null) {
            control.setText(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimulationStorage localSimulate(SimulationControl control, SimulationStorage simulation) {
        SimThread simThread;
        block8: {
            simThread = new SimThread(control, simulation);
            String simulLogLevel = simulation.getParameter().getSimulLogLevel();
            String scriptLogLevel = simulation.getParameter().getScriptLogLevel();
            String libLogLevel = simulation.getParameter().getLibLogLevel();
            try {
                simulation.addSimulationLogger(simulLogLevel, scriptLogLevel, libLogLevel, simThread.getName());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn((Object)I18n.t((String)"isisfish.error.add.logger.simulation", (Object[])new Object[]{e}));
            }
        }
        try {
            simThread.start();
            try {
                simThread.join();
            }
            catch (InterruptedException eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)I18n.t((String)"isisfish.error.wait.simThread", (Object[])new Object[0]), (Throwable)eee);
                }
            }
        }
        finally {
            simulation.removeSimulationLogger();
        }
        return simulation;
    }

    protected AspectJUrlClassLoader changeClassLoader(Thread thread, File directory) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            Enumeration<URL> e = CompileHelper.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found manifest : " + url));
                }
                if (url == null || !url.getFile().startsWith("file:/")) continue;
                String jarPath = url.getPath().substring(0, url.getPath().indexOf("!"));
                urls.add(new URL(jarPath));
            }
            urls.add(directory.toURI().toURL());
            urls.add(IsisFish.config.getCompileDirectory().toURI().toURL());
            AspectJUrlClassLoader loader = new AspectJUrlClassLoader(urls.toArray(new URL[urls.size()]), IsisFish.class.getClassLoader());
            thread.setContextClassLoader((ClassLoader)((Object)loader));
            return loader;
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.change.classloader", (Object[])new Object[]{directory}), eee);
        }
    }

    protected SimulationStorage localSimulateSameThread(SimulationControl control, SimulationStorage simulation) {
        SimulationStorage result = null;
        String jvmVersion = System.getProperty("java.runtime.version");
        log.info((Object)(SimpleDateFormat.getInstance().format(new Date()) + " Java version: " + jvmVersion + " Isis-fish version: " + IsisConfig.getVersion()));
        long start = System.nanoTime();
        simulation.getInformation().setSimulationStart(new Date());
        AspectJUrlClassLoader classLoader = null;
        try {
            File rootDirectory = simulation.getDirectory();
            SimulationContext context = SimulationContext.get();
            context.setSimulationControl(control != null ? control : new SimulationControl(simulation.getName()));
            File compileDirectory = IsisFish.config.getCompileDirectory();
            compileDirectory.mkdirs();
            classLoader = this.changeClassLoader(Thread.currentThread(), rootDirectory);
            context.setClassLoader((ClassLoader)((Object)classLoader));
            context.setScriptDirectory(rootDirectory);
            context.setSimulationStorage(simulation);
            classLoader.deploy(RuleAspect.class);
            SimulationParameter parameters = simulation.getParameter();
            parameters.setIsisFishVersion(IsisConfig.getVersion());
            parameters = simulation.getForceReloadParameter();
            if (parameters.getUseStatistic() || parameters.getUseCache()) {
                if (parameters.getUseStatistic()) {
                    this.message(control, I18n.t((String)"isisfish.message.setting.trace.aspects", (Object[])new Object[0]));
                    classLoader.deploy(TraceAspect.class);
                }
                if (parameters.getUseCache()) {
                    this.message(control, I18n.t((String)"isisfish.message.setting.cache.aspects", (Object[])new Object[0]));
                    classLoader.deploy(CacheAspect.class);
                }
            }
            classLoader.prepare();
            String simulatorName = parameters.getSimulatorName();
            SimulatorStorage simulator = SimulatorStorage.getSimulator(simulatorName, new CodeSourceStorage.Location[0]);
            Simulator simulatorObject = (Simulator)simulator.getNewInstance();
            ObjectCreationListener objectCreationListener = new ObjectCreationListener();
            context.getDB().addTopiaTransactionListener((TopiaTransactionListener)objectCreationListener);
            this.initSimulationListener(context);
            this.message(control, I18n.t((String)"isisfish.message.simulation.execution", (Object[])new Object[0]));
            context.fireBeforeSimulation();
            simulatorObject.simulate(context);
            this.message(control, I18n.t((String)"isisfish.message.add.objets.simulation", (Object[])new Object[0]));
            TopiaContext add = context.getDbResult();
            for (TopiaEntity e : objectCreationListener.getNewObjects()) {
                log.debug((Object)("Add new object: " + e + "(" + e.getClass().getName() + ")"));
                add.add(e);
            }
            add.commitTransaction();
            context.fireAfterSimulation();
            this.message(control, I18n.t((String)"isisfish.message.simulation.ended", (Object[])new Object[0]));
            simulation.getInformation().setSimulationEnd(new Date());
            control.setProgress(control.getProgress() + 1L);
            ResultStorage resultStorage = simulation.getResultStorage();
            if (parameters.isSensitivityAnalysisOnlyKeepFirst() && !control.getId().endsWith("_0")) {
                resultStorage.delete();
            }
            resultStorage.close();
        }
        catch (OutOfMemoryError eee) {
            log.error((Object)I18n.t((String)"isisfish.error.during.simulation", (Object[])new Object[0]), (Throwable)eee);
            simulation.getInformation().setException(eee);
            throw new SimulationException(I18n.t((String)"isisfish.error.out.memory", (Object[])new Object[0]), eee);
        }
        catch (Exception eee) {
            log.error((Object)I18n.t((String)"isisfish.error.during.simulation", (Object[])new Object[0]), (Throwable)eee);
            simulation.getInformation().setException(eee);
            throw new SimulationException(I18n.t((String)"isisfish.error.during.simulation", (Object[])new Object[0]), eee);
        }
        finally {
            SimulationContext context;
            block20: {
                context = SimulationContext.get();
                context.closeDB();
                context.closeDBResult();
                try {
                    if (context.getSimulationStorage() != null) {
                        context.getSimulationStorage().closeMemStorage();
                        context.getSimulationStorage().closeStorage();
                    }
                }
                catch (TopiaException eee) {
                    if (!log.isWarnEnabled()) break block20;
                    log.warn((Object)"Can't close all transaction", (Throwable)eee);
                }
            }
            long end = System.nanoTime();
            log.info((Object)("Simulation time: " + DurationFormatUtils.formatDuration((long)((end - start) / 1000000L), (String)"s'.'S")));
            SimulationParameter param = simulation.getParameter();
            if (param.getUseStatistic()) {
                String trace = context.getTrace().printStatisticAndClear();
                simulation.getInformation().setStatistic(trace);
            }
            if (param.getUseCache()) {
                String cache = context.getCache().printStatistiqueAndClear();
                simulation.getInformation().setOptimizationUsage(cache);
            }
            LogFactory.release((ClassLoader)((Object)classLoader));
            IOUtils.closeQuietly((Closeable)((Object)classLoader));
            File simulationBuildDirectory = IsisFish.config.getCompileDirectory();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delete simulation build directory : " + simulationBuildDirectory.getAbsolutePath()));
            }
            FileUtils.deleteQuietly((File)simulationBuildDirectory);
            SimulationContext.remove();
        }
        return result;
    }

    protected void initSimulationListener(SimulationContext context) throws Exception {
        SimulationStorage simulation = context.getSimulationStorage();
        context.addSimulationListener(simulation.getResultStorage());
        String simListener = context.getSimulationStorage().getParameter().getTagValue().get("SimulationListener");
        if (simListener != null) {
            String[] simListeners;
            for (String l : simListeners = StringUtil.split((String)simListener, (String)",")) {
                context.addSimulationListener((SimulationListener)ObjectUtil.create((String)l));
            }
        }
        context.addSimulationListener(new SimulationPreScriptListener());
        context.addSimulationListener(new SimulationExportResultWrapper());
    }

    @Override
    public void simulationStopRequest(SimulationJob job) {
    }

    protected class ObjectCreationListener
    implements TopiaTransactionListener {
        protected List<TopiaEntity> newObjects = new ArrayList<TopiaEntity>();

        protected ObjectCreationListener() {
        }

        public List<TopiaEntity> getNewObjects() {
            return this.newObjects;
        }

        public void commit(TopiaTransactionEvent event) {
        }

        public void rollback(TopiaTransactionEvent event) {
            log.debug((Object)("Transaction rollback " + event.getEntities().size() + " object(s)"));
            for (TopiaEntity entity : event.getEntities()) {
                if (!event.isCreate(entity)) continue;
                log.debug((Object)("New object detected during simulation: " + entity + "(" + entity.getClass().getName() + ")"));
                this.newObjects.add(entity);
            }
        }
    }

    protected class SimThread
    extends Thread {
        protected SimulationControl control;
        protected SimulationStorage simulation;

        public SimThread(SimulationControl control, SimulationStorage simulation) {
            super("SimThread " + (control != null ? control.getId() : ""));
            this.control = control;
            this.simulation = simulation;
        }

        @Override
        public void run() {
            this.simulation = InProcessSimulatorLauncher.this.localSimulateSameThread(this.control, this.simulation);
        }
    }
}

