/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.VersionStorage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;

public abstract class CodeSourceStorage
extends VersionStorage {
    protected String name = null;
    protected String content = null;
    protected long lastContentUpdate = 0L;
    protected long lastContentLength = 0L;

    protected static Location[] nonEmptyLocation(Location ... location) {
        Location[] locs = location;
        if (locs == null || locs.length == 0) {
            locs = Location.values();
        }
        return locs;
    }

    protected CodeSourceStorage(File rootSrc, File directory, String name, String suffix) {
        super(rootSrc, name.endsWith(suffix) ? new File(directory, name) : new File(directory, name + suffix));
        this.name = name.endsWith(suffix) ? name : name + suffix;
    }

    @Override
    protected void prepare() {
    }

    @Override
    protected List<File> getFiles(boolean withParent) {
        List<File> result = Collections.singletonList(this.getFile());
        return result;
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        if (this.content == null || this.getFile().lastModified() > this.lastContentUpdate || this.getFile().length() != this.lastContentLength) {
            if (!this.exists()) {
                this.content = "";
            } else {
                try {
                    this.content = FileUtils.readFileToString((File)this.getFile());
                    this.lastContentUpdate = System.nanoTime();
                    this.lastContentLength = this.getFile().length();
                }
                catch (IOException eee) {
                    throw new IsisFishRuntimeException("Can't get content", eee);
                }
            }
        }
        return this.content;
    }

    public void setContent(String content) throws IOException {
        this.setContent(content, true);
    }

    public void setContent(String content, boolean saveToFile) throws IOException {
        this.content = content;
        if (saveToFile) {
            FileUtils.writeStringToFile((File)this.getFile(), (String)content, (String)"utf-8");
            this.lastContentUpdate = System.nanoTime();
            this.lastContentLength = this.getFile().length();
        }
        CodeSourceStorage.fireDataChanged(new StorageChangeEvent(this));
    }

    public void reload() {
        this.content = null;
    }

    public static enum Location {
        OFFICIAL(IsisFish.config.getDatabaseDirectory()),
        COMMUNITY(IsisFish.config.getCommunityDatabaseDirectory()),
        ALL(null, IsisFish.config.getCommunityDatabaseDirectory());

        protected File[] directory;

        private Location(File ... directory) {
            this.directory = directory;
        }

        public File[] getDirectories() {
            File[] result = new File[this.directory.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.directory[i] == null ? IsisFish.config.getContextDatabaseDirectory() : this.directory[i];
            }
            return result;
        }

        public void setDirectory(File ... directory) {
            this.directory = directory;
        }
    }
}

