/*
 * #%L
 * IsisFish
 * 
 * $Id: FilterDialog.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.widget.filter;

import java.util.List;

/**
 * Contrat à respecter pour qu'un dialogue puisse bénéficier du mécanisme de
 * filtre.
 *
 * Cette méthode est invoquée lors d'un appel à {@link #doFilter()} ou
 * {@link #doCheck()}.
 * <p>
 * La méthode {@link #doReset()} permet de réinitialiser le dialogModel
 * (et le dialogue)
 */
public interface FilterDialog<M, R> {

    /**
     * launch filter process.
     * 
     * This operation acts in three step :
     * <ul>
     * <li>clean model</li>
     * <li>push ui values to model </li>
     * <li> for all original items and only for detected as usable params
     * try to accept item</li>
     * </ul>
     */
    void doFilter();

    /** invoke method {@link #doFilter()} then refresh ui  */
    void doCheck();

    /** réinitialisie le model et rafraichit l'ui */
    void doReset();

    /**
     * Display dialog and waits until user validate a filter result, or cancel
     * (then return <code>null</code>)
     *
     * @return list of filtered result of defined result format
     *         (of type <code>T</code>)
     */
    List<R> obtainFilterResult();

    /**
     * Display dialog and waits until user validate a selected result from a
     * filter result, or cancel (then return <code>null</code>)
     *
     * @return the selected result from filter result as defined result format
     *         (of type <code>T</code>)
     */
    R obtainSelectResult();

    /** @return list of original items (delegate to model) */
    List<M> getOriginal();
}
