/*
 * #%L
 * IsisFish
 * 
 * $Id: ResultListRenderer.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.result;

import static org.nuiton.i18n.I18n.t;

import java.awt.Component;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.ui.util.TooltipHelper;
import fr.ifremer.isisfish.util.Doc;

/**
 * Renderer pour la combo des noms de regles.
 *
 * TODO don't work for now, worg with field name, not field values !!!
 * 
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (jeu., 17 avril 2014) $
 * By : $Author: echatellier $
 */
public class ResultListRenderer extends DefaultListCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;
    
    /** Cache map for doc corresponding to value. */
    protected Map<String, String> docForValue;
    
    public ResultListRenderer() {
        docForValue = new HashMap<String, String>();
    }
    
    /*
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
     */
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {
        
        // this must be used to have alterned highlight rows and default
        // selection color
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

        String resultName = (String)value;
        c.setText(resultName);
        
        String tooltip = docForValue.get(resultName);
        if (tooltip == null) {
            // c'est tres couteux d'avoir la doc en fonction
            // de la valeur d'un des attributs
            try {
                ScriptStorage storage = ScriptStorage.getScript("ResultName.java");
                Class<?> resultNameClass = storage.getCodeClass();
                Field[] fields = resultNameClass.getFields();
                for (Field f : fields) {
                    String fieldValue = (String) f.get(null);
                    if (fieldValue != null && fieldValue.equals(resultName)) {
                        Doc doc = f.getAnnotation(Doc.class);
                        tooltip = TooltipHelper.docToString(doc);
                    }
                }
            } catch (Exception e) {
                String errorTooltip = TooltipHelper.getErrorTooltip(t("isisfish.error.compile.fileerror", "ResultName.java"));
                c.setToolTipText(errorTooltip);
            }
        }
        
        setToolTipText(tooltip);

        return c;
    }
}
