/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.sensitivity.visitor;

import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;

/**
 * Domain visitor.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public interface ScenarioVisitor {

    /**
     * Start.
     * 
     * @param scenario scenario
     */
    void start(Scenario scenario);
    
    /**
     * Visit domain value or property.
     * 
     * @param scenario scenario
     * @param factor factor
     */
    void visit(Scenario scenario, Factor factor);
    
    /**
     * End.
     * 
     * @param scenario scenario
     */
    void end(Scenario scenario);
}
