/*
 * #%L
 * IsisFish
 * 
 * $Id: ImmigrationEquation.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import org.nuiton.math.matrix.MatrixND;

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 * Immigration equation.
 *
 * Created: 23 août 2006 12:06:32
 *
 * @author poussin
 * @version $Revision: 3798 $
 *
 * Last update: $Date: 2012-10-30 11:39:32 +0100 (mar. 30 oct. 2012) $
 * by : $Author: echatellier $
 */
public interface ImmigrationEquation {
    
    /**
     * Compute immigration equation.
     * 
     * @param context simulation context
     * @param N effectif de la population
     * @param pop la population pour lequel on souhaite le nombre d'immigration
     * @param group le group pour lequel on souhaite le nombre d'immigration
     * @param arrivalZone la zone d'arrivé de l'immigration
     * @return le nombre d'individu a immigrer dans la zone
     * d'arrivé pour le groupe passé en argument
     * @throws Exception 
     */
    @Args({"context", "N", "pop", "group", "arrivalZone"})
    public double compute(SimulationContext context,
            MatrixND N, Population pop, PopulationGroup group,
            Zone arrivalZone) throws Exception;

}
