/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.echobase.InputFile;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.ImportDataConfiguration;
import fr.ifremer.echobase.services.VoyageService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class ConfigureFiles
extends EchoBaseActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureFiles.class);
    protected ImportDataConfiguration model;
    protected String voyageId;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public void setAcoustic(File file) {
        this.getModel().getAcousticFile().setFile(file);
    }

    public void setAcousticContentType(String contentType) {
        this.getModel().getAcousticFile().setContentType(contentType);
    }

    public void setAcousticFileName(String fileName) {
        this.getModel().getAcousticFile().setFileName(fileName);
    }

    public void setCapture(File file) {
        this.getModel().getCaptureFile().setFile(file);
    }

    public void setCaptureContentType(String contentType) {
        this.getModel().getCaptureFile().setContentType(contentType);
    }

    public void setCaptureFileName(String fileName) {
        this.getModel().getCaptureFile().setFileName(fileName);
    }

    public void setLectureAgeGen(File file) {
        this.getModel().getLectureAgeGenFile().setFile(file);
    }

    public void setLectureAgeGenContentType(String contentType) {
        this.getModel().getLectureAgeGenFile().setContentType(contentType);
    }

    public void setLectureAgeGenFileName(String fileName) {
        this.getModel().getLectureAgeGenFile().setFileName(fileName);
    }

    public void setEvents(File file) {
        this.getModel().getEventsFile().setFile(file);
    }

    public void setEventsContentType(String contentType) {
        this.getModel().getEventsFile().setContentType(contentType);
    }

    public void setEventsFileName(String fileName) {
        this.getModel().getEventsFile().setFileName(fileName);
    }

    public void setTypeEchoSpecies(File file) {
        this.getModel().getTypeEchoSpeciesFile().setFile(file);
    }

    public void setTypeEchoSpeciesContentType(String contentType) {
        this.getModel().getTypeEchoSpeciesFile().setContentType(contentType);
    }

    public void setTypeEchoSpeciesFileName(String fileName) {
        this.getModel().getTypeEchoSpeciesFile().setFileName(fileName);
    }

    public String getVoyageId() {
        return this.voyageId;
    }

    public ImportDataConfiguration getModel() {
        if (this.model == null) {
            this.model = new ImportDataConfiguration(this.getLocale());
        }
        return this.model;
    }

    public String input() throws Exception {
        this.getEchoBaseSession().setImportDataConfiguration(null);
        return "input";
    }

    public String execute() throws Exception {
        ImportDataConfiguration importModel = this.getModel();
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-import" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        this.copyFile(importModel.getAcousticFile(), dataDirectory);
        this.copyFile(importModel.getCaptureFile(), dataDirectory);
        this.copyFile(importModel.getEventsFile(), dataDirectory);
        this.copyFile(importModel.getLectureAgeGenFile(), dataDirectory);
        this.copyFile(importModel.getTypeEchoSpeciesFile(), dataDirectory);
        this.getEchoBaseSession().setImportDataConfiguration(importModel);
        return "success";
    }

    public void prepare() throws Exception {
        VoyageService service = (VoyageService)this.newService(VoyageService.class);
        Voyage voyage = (Voyage)service.getEntityById(Voyage.class, this.voyageId);
        this.getModel().setVoyage(voyage);
    }

    protected void copyFile(InputFile inputFile, File dataDirectory) throws IOException {
        File source = inputFile.getFile();
        if (source != null) {
            File target = new File(dataDirectory, inputFile.getFileName());
            if (log.isInfoEnabled()) {
                log.info((Object)("Copy file " + source + " to " + target));
            }
            FileUtils.copyFile((File)source, (File)target);
            inputFile.setFile(target);
        }
    }
}

