/*
 * #%L
 * $Id: GraphDownloadAction.java 818 2011-05-06 08:04:19Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.2.6/coser-web/src/main/java/fr/ifremer/coser/web/actions/pop/GraphDownloadAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions.pop;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Télécharge les données qui ont servi a généré le graph au format CSV.
 * 
 * Parametre : zone, species, indicator.
 *  
 * @author chatellier
 * @version $Revision: 818 $
 * 
 * Last update : $Date: 2011-05-06 10:04:19 +0200 (Fri, 06 May 2011) $
 * By : $Author: chatellier $
 */
public class GraphDownloadAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3385467755357775199L;

    private static final Log log = LogFactory.getLog(GraphDownloadAction.class);

    protected String zone;

    protected String species;

    protected String indicator;

    public String getZone() {
        return zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getIndicator() {
        return indicator;
    }

    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public String getSpecies() {
        return species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    @Action(results= {@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() {
        return SUCCESS;
    }

    public String getFilename() {
        return indicator + ".csv";
    }

    public InputStream getInputStream() {
        WebService webService = ServiceFactory.getWebService();

        Locale locale = getLocale();
        String localeCode = locale.getLanguage();

        InputStream input = null;
        try {
            File mapImage = webService.getChartData(zone, species, indicator, null, localeCode);
            input = new FileInputStream(mapImage);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't get file data", ex);
            }
            throw new CoserWebException("Can't get map file", ex);
        }

        return input;
    }
}
