/*
 * #%L
 * $Id: IndexAction.java 543 2011-01-23 21:03:33Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.1/coser-web/src/main/java/fr/ifremer/coser/web/actions/IndexAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web.actions;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;

/**
 * Action index, recupere la date de derniere mise à jour.
 * 
 * @author chatellier
 * @version $Revision: 543 $
 * 
 * Last update : $Date: 2011-01-23 22:03:33 +0100 (dim., 23 janv. 2011) $
 * By : $Author: chatellier $
 */
public class IndexAction extends CoserAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1663244944108703571L;

    protected Date dataUpdateDate;

    public Date getDataUpdateDate() {
        return dataUpdateDate;
    }

    /**
     * Return l'url de l'application context inclut.
     * 
     * @return l'url du context
     */
    public String getContextUrl() {
        HttpServletRequest request = ServletActionContext.getRequest();
        
        String url = request.getScheme() + "://" + request.getServerName();
        if (request.getServerPort() != 80) {
            url += ":" + request.getServerPort();
        }
        url += request.getContextPath();
        
        return url;
    }

    @Override
    public String execute() {

        WebService webService = ServiceFactory.getWebService();

        try {
            dataUpdateDate = webService.getLastDataUpdateDate();
        } catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get last update date", ex);
        }

        return SUCCESS;
    }
}
