package fr.ifremer.coser.ui.result;

/*
 * #%L
 * Coser :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.ui.selection.SelectionHandler;
import fr.ifremer.coser.ui.selection.model.FileListModel;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n._;

public class SelectionEditResultDialog extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_RESULT_ZONE_COMBO_MODEL = "resultZoneComboModel";
    public static final String PROPERTY_RSUFI_RESULT = "rsufiResult";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_PUBLIABLE_RESULT_CHECK_BOX_SELECTED = "publiableResultCheckBox.selected";
    public static final String BINDING_RESULT_CREATION_DATE_DATE = "resultCreationDate.date";
    public static final String BINDING_RESULT_NAME_FIELD_TEXT = "resultNameField.text";
    public static final String BINDING_RESULT_RSUFI_VERSION_TEXT = "resultRsufiVersion.text";
    public static final String BINDING_RESULT_ZONE_COMBO_MODEL = "resultZoneCombo.model";
    public static final String BINDING_RESULT_ZONE_COMBO_MODEL_SELECTED_ITEM = "resultZoneComboModel.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWT28bRRSfmDqJk/RfQp2mhCptXQmhdt2UlktKKUlqpZZLK7uqQsyBWe8knmS8s8zMpssF8QkQHwHuXJC4cUIcOHPggvgKCHHginiz49311tvNqvZh135/fu/33rx5z9//hcpSoCuHOAgs4buKDojV/Gh394l9SHpqm8ieoJ7iApnPVAmVumjeieVSoWvdlnavD93rW3zgcZe4I94bLTQn1ReMyD4hSqG30x49KeudWL0ReL6IUGNSWajf/vN36Rvnq+9KCAUesLsEqayd5JVkcqqFStRRaBEiHeM6w+4B0BDUPQC+p7Vsi2EpP8YD8jn6Es200LSHBYApdLV4yiFG6B94ClVqzW2KGT+4pdCdfWHRfUEGRFg9LuHpU0sQ6TNldQiD+lPuPnSoaocy4+d5Idi0QjO1Z9hmBIAupnKWLyADK9Rpy0ri0Meuw4hQyMqKLKOQSfAd45DEnBfS36eGj0JXxmBsgl2r3YltEs/ZWrOFbcKA7qIubTDkaaTaaCG2PWuKoAvfoITBEVVTLs9IoEJF2i0Ksa5/L6d1iwayrek/J0JCclpzKW01V9vmPX8ABwk0V0ZjKghpRcrxrG6/OuSWIFjXchsrotAaFwfWIdyfI8U9gx1YzV2tfEp7R0Rkp/ReBv6bBn8PGg/6z+aPuUOYQjdyuiq23eRBaO69XPPYQqELqZpHbtn87mTwW/Z8m1HdhqYXtvqkdwQIY8hDeTby3Qzk07Vmpyc4Y0+xq/t/OYWXqNJeVa76REClcYMy0qJSDSu2nn8bBtrKSvkkZTs/BgqydH+DTBu/nxxcTcviSxYiQhaXR93GLcYuftjmZ9I5wnjZ9JXiLuAtpWgYsTbbHD3zAT8mT3QKmr4WN9ImMeB6hvKcxMfDw03gIxuB3kqNJRjyVjLkkyk81UVl4YMY5lh3fC+0QWU2wsWXNoIGDLX/VZd+/+nPHxvRGqhC7AuZpiNbDMazJ7gH05Dq0GfNDvAVZfXH2NvooorpgHDFrWYQ6wzVQA7ihWduaXdrB8s+QJRn/vj5l+pnv72BSg00xzh2GljbP0IV1YfL1ufMCbwPH4SMFl7MwvOc5qZQGToOQ18u3qMuoy5Zwwq2ku0rcj+AOqxm1CEmY1d+/Xep88ODqBZTwG3lleZJPcp7aNpEC5ficN9lLsF5TxLf4cley9p0U/o95w2bth0+n2cmq6gynfdJ4OvXXshaf/u0MMgpPZ5zMKoFMGaIq2+VkwOzciKMFkNzn7nnwERYs6nrwOW7PxFaDp/V4gg8G+HyxByuFTkeqEYei+sTs3inAIsFc6GJ80iRQQ6bd4t0bbgUckBuFgCZhf+SDhFm5782zkmluVWESVSaHCa3J2ZytxDC1zkcPpiYw8NCCIc5CDsTc5gcoTkxQgsQ/gd3CsHq/Q0AAA==";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(SelectionEditResultDialog.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SelectionHandler handler;
    protected JList otherDataFileList;
    protected FileListModel otherDataFileListModel;
    protected JCheckBox publiableResultCheckBox;
    protected JButton removeOtherFile;
    protected JXDatePicker resultCreationDate;
    protected JTextField resultNameField;
    protected JTextField resultRsufiVersion;
    protected JComboBox resultZoneCombo;
    protected ZoneComboBoxModel resultZoneComboModel;
    protected RSufiResult rsufiResult;
    protected JButton saveResultButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private JButton $JButton0;
    private JButton $JButton1;
    private SelectionEditResultDialog $JDialog0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionEditResultDialog(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Dialog param0) {
        super(param0);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Frame param0) {
        super(param0);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog() {
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Window param0) {
        super(param0);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectionEditResultDialog(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SelectionEditResultDialog(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectResultFileOrDirectory(this, otherDataFileList);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__publiableResultCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setPubliableResult(publiableResultCheckBox.isSelected());
    }

    public void doActionPerformed__on__removeOtherFile(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeSelectedFile(this);
    }

    public void doActionPerformed__on__resultCreationDate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setCreationDate(resultCreationDate.getDate());
    }

    public void doActionPerformed__on__resultZoneCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setZone((String)resultZoneCombo.getSelectedItem());
    }

    public void doActionPerformed__on__saveResultButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().performEditResult(this);
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setRsufiVersion(resultRsufiVersion.getText());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getRsufiResult().setRsufiVersion(resultRsufiVersion.getText());
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeOtherFile.setEnabled(getOtherDataFileList().getSelectedIndex() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectionHandler getHandler() {
        return handler;
    }

    public JList getOtherDataFileList() {
        return otherDataFileList;
    }

    public FileListModel getOtherDataFileListModel() {
        return otherDataFileListModel;
    }

    public JCheckBox getPubliableResultCheckBox() {
        return publiableResultCheckBox;
    }

    public JButton getRemoveOtherFile() {
        return removeOtherFile;
    }

    public JXDatePicker getResultCreationDate() {
        return resultCreationDate;
    }

    public JTextField getResultNameField() {
        return resultNameField;
    }

    public JTextField getResultRsufiVersion() {
        return resultRsufiVersion;
    }

    public JComboBox getResultZoneCombo() {
        return resultZoneCombo;
    }

    public ZoneComboBoxModel getResultZoneComboModel() {
        return resultZoneComboModel;
    }

    public RSufiResult getRsufiResult() {
        return rsufiResult;
    }

    public JButton getSaveResultButton() {
        return saveResultButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setHandler(SelectionHandler handler) {
        SelectionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    public void setResultZoneComboModel(ZoneComboBoxModel resultZoneComboModel) {
        ZoneComboBoxModel oldValue = this.resultZoneComboModel;
        this.resultZoneComboModel = resultZoneComboModel;
        firePropertyChange(PROPERTY_RESULT_ZONE_COMBO_MODEL, oldValue, resultZoneComboModel);
    }

    public void setRsufiResult(RSufiResult rsufiResult) {
        RSufiResult oldValue = this.rsufiResult;
        this.rsufiResult = rsufiResult;
        firePropertyChange(PROPERTY_RSUFI_RESULT, oldValue, rsufiResult);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createOtherDataFileList() {
        $objectMap.put("otherDataFileList", otherDataFileList = new JList());
        
        otherDataFileList.setName("otherDataFileList");
    }

    protected void createOtherDataFileListModel() {
        $objectMap.put("otherDataFileListModel", otherDataFileListModel = new FileListModel());
    }

    protected void createPubliableResultCheckBox() {
        $objectMap.put("publiableResultCheckBox", publiableResultCheckBox = new JCheckBox());
        
        publiableResultCheckBox.setName("publiableResultCheckBox");
        publiableResultCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__publiableResultCheckBox"));
    }

    protected void createRemoveOtherFile() {
        $objectMap.put("removeOtherFile", removeOtherFile = new JButton());
        
        removeOtherFile.setName("removeOtherFile");
        removeOtherFile.setEnabled(false);
        removeOtherFile.setText(_("coser.ui.result.removeOtherDataFile"));
        removeOtherFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeOtherFile"));
    }

    protected void createResultCreationDate() {
        $objectMap.put("resultCreationDate", resultCreationDate = new JXDatePicker());
        
        resultCreationDate.setName("resultCreationDate");
        resultCreationDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resultCreationDate"));
    }

    protected void createResultNameField() {
        $objectMap.put("resultNameField", resultNameField = new JTextField());
        
        resultNameField.setName("resultNameField");
        resultNameField.setColumns(15);
        resultNameField.setEnabled(false);
    }

    protected void createResultRsufiVersion() {
        $objectMap.put("resultRsufiVersion", resultRsufiVersion = new JTextField());
        
        resultRsufiVersion.setName("resultRsufiVersion");
        resultRsufiVersion.setColumns(15);
    }

    protected void createResultZoneCombo() {
        $objectMap.put("resultZoneCombo", resultZoneCombo = new JComboBox());
        
        resultZoneCombo.setName("resultZoneCombo");
        resultZoneCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resultZoneCombo"));
    }

    protected void createResultZoneComboModel() {
        $objectMap.put("resultZoneComboModel", resultZoneComboModel = new ZoneComboBoxModel(getContextValue(fr.ifremer.coser.services.WebService.class)));
    }

    protected void createRsufiResult() {
        $objectMap.put("rsufiResult", rsufiResult = null);
    }

    protected void createSaveResultButton() {
        $objectMap.put("saveResultButton", saveResultButton = new JButton());
        
        saveResultButton.setName("saveResultButton");
        saveResultButton.setText(_("coser.ui.result.validEditResult"));
        saveResultButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveResultButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultNameField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultRsufiVersion, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultCreationDate, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(resultZoneCombo, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(publiableResultCheckBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 6, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(otherDataFileList);
        // inline complete setup of $Table1
        $Table1.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(removeOtherFile, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(saveResultButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        resultZoneCombo.setRenderer(new ZoneComboBoxRenderer());
        otherDataFileList.setModel(otherDataFileListModel);
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createHandler();
        createRsufiResult();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.result.resultName"));
        createResultNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("coser.ui.result.rsufiVersion"));
        createResultRsufiVersion();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = resultRsufiVersion.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("coser.ui.result.creationDate"));
        createResultCreationDate();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("coser.ui.result.zone"));
        createResultZoneComboModel();
        createResultZoneCombo();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("coser.ui.result.publiableResult"));
        createPubliableResultCheckBox();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("coser.ui.result.otherDataFile"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createOtherDataFileListModel();
        createOtherDataFileList();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = otherDataFileList.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("coser.ui.result.addOtherDataFile"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createRemoveOtherFile();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("coser.ui.result.cancel"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        createSaveResultButton();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        setTitle(_("coser.ui.result.editResult"));
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_NAME_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getRsufiResult() != null) {
                    SwingUtil.setText(resultNameField, getRsufiResult().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_RSUFI_VERSION_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().addPropertyChangeListener("rsufiVersion", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getRsufiResult() != null) {
                    SwingUtil.setText(resultRsufiVersion, getRsufiResult().getRsufiVersion());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().removePropertyChangeListener("rsufiVersion", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_CREATION_DATE_DATE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().addPropertyChangeListener("creationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getRsufiResult() != null) {
                    resultCreationDate.setDate(getRsufiResult().getCreationDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().removePropertyChangeListener("creationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_ZONE_COMBO_MODEL_SELECTED_ITEM, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().addPropertyChangeListener("zone", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getRsufiResult() != null) {
                    resultZoneComboModel.setSelectedItem(getRsufiResult().getZone());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().removePropertyChangeListener("zone", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESULT_ZONE_COMBO_MODEL, true ,"resultZoneComboModel") {
        
            @Override
            public void processDataBinding() {
                resultZoneCombo.setModel(getResultZoneComboModel());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PUBLIABLE_RESULT_CHECK_BOX_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().addPropertyChangeListener("publiableResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getRsufiResult() != null) {
                    publiableResultCheckBox.setSelected(getRsufiResult().isPubliableResult());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("rsufiResult", this);
                if (getRsufiResult() != null) {
                    getRsufiResult().removePropertyChangeListener("publiableResult", this);
                }
            }
        });
    }

}