package fr.ifremer.coser.ui.control;

/*
 * #%L
 * Coser :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2010 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ControlGraphFrame extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TQU8TQRR+rbSlgCIQCERMUEhMIGy9QxDFVCRFjfVA7MXZ7kCHTHfGmVlZLsaf4E/QuxcTb56MB88evBj/gjEevBrfzJZuiyu2h5nNm/d973uv73vzHQpawZVDEseeikLD2tTbubm3d98/pE1zm+qmYtIIBckvl4d8A0aDblwbWGzULLzSgVe2RFuKkIY96LUajGhzzKluUWoMXO5HNLWu1LvPa7GM1AlrV1QW66ufP/Ivgxev8wCxRHUlbGXhf6i0k6Ea5FlgYBIrPSMVTsIDlKFYeIB6z9vYFida3yNt+hSeQ6kGRUkUkhm4OnjLjsPhY2lgeGmnqpDwuoHVfeWxfUXbVHlNofGMGH6ERgmOwt19RxHZcgApHUnRQKlFwoBTZWB5AIbtJLkHvvSI+NwKmO0blT7Cxj33ZjPLXQBKrhGfckRM2qHEndQkapPGu7kTWtImoxoH4otdEVBuYOUslXXMP06zU5ljvUwGpvsqu+AtEZ8q3uwZ2gMS2uL9il2wA1Jwqa9/XEIvXcJ0S3INKKgIwziwxt97+xCfko2dPbWxltC9/p6Z+vL+27vqyZpax01npva4DNdHKiHxb2a29Hiyo5FhvLJL5FoDyppytKiz4HyGsHrnGcVhvQkL9yzc2ya6hRSF0tcPH2eefD4H+SqMcEGCKrH5d6FsWgqnIHgQyxubTtHY0TCeF602A0Mh7iOOdp2FnIV0gRg0jR8ZuhHjGOYzxtDV4pc//Zqqv908GUUOpc39Mz0dR+ExFJNqzrMdO2Z6dFRqGgUitV2WEXP2HpGddVt057WsXguGmcQQy3FkrxWn2n6tDkwyZGhszuCYGkRIO3HThfWAGLLgszDAld7IJpwbgLDIybGInKz1bJZ5ZPkD0cmbgCEGAAA=";
    private static final Log log = LogFactory.getLog(ControlGraphFrame.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel controlGraphPanel;
    protected ControlHandler handler;
    protected JComboBox speciesCombo;
    protected SpecyComboModel speciesComboModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ControlGraphFrame $JFrame0 = this;
    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ControlGraphFrame() {
        $initialize();
    }

    public ControlGraphFrame(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ControlGraphFrame(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public ControlGraphFrame(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ControlGraphFrame(String param0) {
        super(param0);
        $initialize();
    }

    public ControlGraphFrame(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ControlGraphFrame(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ControlGraphFrame(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__speciesCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().updateCompareNumberCatchGraph(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getControlGraphPanel() {
        return controlGraphPanel;
    }

    public ControlHandler getHandler() {
        return handler;
    }

    public JComboBox getSpeciesCombo() {
        return speciesCombo;
    }

    public SpecyComboModel getSpeciesComboModel() {
        return speciesComboModel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(ControlHandler handler) {
        ControlHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createControlGraphPanel() {
        $objectMap.put("controlGraphPanel", controlGraphPanel = new JPanel());
        
        controlGraphPanel.setName("controlGraphPanel");
        controlGraphPanel.setLayout(new BorderLayout());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createSpeciesCombo() {
        $objectMap.put("speciesCombo", speciesCombo = new JComboBox());
        
        speciesCombo.setName("speciesCombo");
        speciesCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__speciesCombo"));
    }

    protected void createSpeciesComboModel() {
        $objectMap.put("speciesComboModel", speciesComboModel = new SpecyComboModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JFrame0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(speciesCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(controlGraphPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 2 property setters
        speciesCombo.setModel(speciesComboModel);
        // late initializer
        $JFrame0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JFrame0", $JFrame0);
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("coser.ui.control.graph.species"));
        createSpeciesComboModel();
        createSpeciesCombo();
        createControlGraphPanel();
        // inline creation of $JFrame0
        setName("$JFrame0");
        setName("catchLengthCompareFrame");
        setTitle(_("coser.ui.graph.compareNumberCatchLength"));
        
        $completeSetup();
    }

}