/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.ui.selection;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConfig;
import fr.ifremer.coser.CoserException;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.services.PublicationService;
import fr.ifremer.coser.ui.common.DataHandler;
import fr.ifremer.coser.ui.control.ControlGraphFrame;
import fr.ifremer.coser.ui.control.ControlHandler;
import fr.ifremer.coser.ui.result.SelectionAddResultDialog;
import fr.ifremer.coser.ui.result.SelectionEditResultDialog;
import fr.ifremer.coser.ui.selection.SamplingEffortRenderer;
import fr.ifremer.coser.ui.selection.SelectionDetailsView;
import fr.ifremer.coser.ui.selection.SelectionListsView;
import fr.ifremer.coser.ui.selection.SelectionRsufiView;
import fr.ifremer.coser.ui.selection.SelectionView;
import fr.ifremer.coser.ui.selection.SpeciesFusionDialog;
import fr.ifremer.coser.ui.selection.model.OccurrenceDensitySpeciesListModel;
import fr.ifremer.coser.ui.util.CoserListSelectionModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixTableModelND;
import org.nuiton.widget.SwingSession;

public class SelectionHandler
extends DataHandler {
    private static final Log log = LogFactory.getLog(SelectionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionTabChanged(SelectionView view, ChangeEvent event) {
        try {
            this.setWaitCursor(view);
            Component selectedComponent = view.getSelectedComponent();
            if (selectedComponent instanceof SelectionListsView) {
                SelectionListsView selectionListsView = (SelectionListsView)((Object)selectedComponent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"List details tab selected");
                }
                Selection selection = view.getContextValue(Selection.class);
                List<String> currentList = selectionListsView.getSelectionAllSpeciesListModel().getSpecies();
                List selectionSpeciesList = selection.getSelectedSpecies();
                if (!((Object)selectionSpeciesList).equals(currentList)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Data changed, fill default selection");
                    }
                    Project project = view.getContextValue(Project.class);
                    ProjectService projectService = view.getContextValue(ProjectService.class);
                    MatrixND occurrence = projectService.getOccurrence(project, selection);
                    occurrence.meanOverDim(1);
                    MatrixND density = projectService.getDensity(project, selection);
                    density.meanOverDim(1);
                    Collection speciesAllYear = projectService.getSpeciesWithSizeAllYears(selection);
                    Collection speciesWithMaturity = projectService.getSpeciesWithMaturity(selection);
                    selectionListsView.getSelectionOccurrenceDensityListModel().setOccurrence(occurrence);
                    selectionListsView.getSelectionOccurrenceDensityListModel().setDensity(density);
                    selectionListsView.getSelectionAllSpeciesList().clearSelection();
                    selectionListsView.getSelectionAllSpeciesListModel().setSpecies(selectionSpeciesList);
                    ((CoserListSelectionModel)((Object)selectionListsView.getSelectionAllSpeciesList().getSelectionModel())).fillSelection();
                    selectionListsView.getSelectionSizeAllYearListModel().setSizeAllYearSpecies(speciesAllYear);
                    selectionListsView.getSelectionMaturityListModel().setMaturitySpecies(speciesWithMaturity);
                    if (!(selection.getSelectedSpeciesOccDens().isEmpty() && selection.getSelectedSpeciesSizeAllYear().isEmpty() && selection.getSelectedSpeciesMaturity().isEmpty())) {
                        selectionListsView.getSelectionFilterOccurrenceField().setText(String.valueOf(selection.getOccurrenceFilter()));
                        selectionListsView.getSelectionFilterDensityField().setText(String.valueOf(selection.getDensityFilter()));
                        ((CoserListSelectionModel)((Object)selectionListsView.getSelectionOccurrenceDensityList().getSelectionModel())).setSelectedObjects(selection.getSelectedSpeciesOccDens());
                        ((CoserListSelectionModel)((Object)selectionListsView.getSelectionSizeAllYearList().getSelectionModel())).setSelectedObjects(selection.getSelectedSpeciesSizeAllYear());
                        ((CoserListSelectionModel)((Object)selectionListsView.getSelectionMaturityList().getSelectionModel())).setSelectedObjects(selection.getSelectedSpeciesMaturity());
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Apply occurrence/density filter");
                        }
                        this.updateOccurrenceDensityFilter(selectionListsView);
                    }
                }
            }
        }
        finally {
            this.setDefaultCursor(view);
        }
    }

    public void initSelection(SelectionView view) {
        SelectionDetailsView detailView = view.getSelectionDetailsTab();
        this.initSelectionYears(detailView);
        view.setCreationState(true);
        view.setEnabledAt(1, false);
        view.setEnabledAt(2, false);
    }

    public void initSelectionYears(SelectionDetailsView view) {
        Selection selection = view.getContextValue(Selection.class);
        view.getYearsListModel().setYears(selection.getAllYears());
        ((CoserListSelectionModel)((Object)view.getYearsList().getSelectionModel())).setSelectedObjects(selection.getSelectedYears());
        view.getStrataListModel().setStrata(new ArrayList<String>());
        view.getStrataList().clearSelection();
        view.getFilteredSpeciesListModel().setSpecies(new ArrayList<String>());
        view.getFilteredSpeciesList().clearSelection();
        view.getSelectedSpeciesListModel().setSpecies(new ArrayList<String>());
        view.getSelectedSpeciesList().clearSelection();
        this.showSamplingEffort(view);
    }

    public void reloadSelection(SelectionView view) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reloading selection...");
        }
        Selection selection = view.getSelection();
        SelectionDetailsView detailView = view.getSelectionDetailsTab();
        detailView.getYearsListModel().setYears(selection.getAllYears());
        List selectedYears = selection.getSelectedYears();
        ((CoserListSelectionModel)((Object)detailView.getYearsList().getSelectionModel())).setSelectedObjects(selectedYears);
        this.updateSelectionYearsData(detailView);
        List selectedStrata = selection.getSelectedStrata();
        ((CoserListSelectionModel)((Object)detailView.getStrataList().getSelectionModel())).setSelectedObjects(selectedStrata);
        detailView.getSelectedSpeciesListModel().setSpecies(selection.getSelectedSpecies());
        this.updateSelectionStrataData(detailView);
        List selectedSpecies = selection.getSelectedSpecies();
        detailView.getSelectedSpeciesListModel().setSpecies(selectedSpecies);
        detailView.setYearsValidated(!selectedYears.isEmpty());
        detailView.setStrataValidated(!selectedStrata.isEmpty());
        detailView.setSpeciesValidated(!selectedSpecies.isEmpty());
        view.setEnabledAt(2, selection.isValidated());
        this.showSamplingEffort(detailView);
    }

    public void reloadControlData(SelectionDetailsView view) {
        int response = JOptionPane.showConfirmDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.detail.confirmcontrolreload", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 0, 3);
        if (response == 0) {
            Project project = view.getContextValue(Project.class);
            Selection selection = view.getContextValue(Selection.class);
            ProjectService projectService = view.getContextValue(ProjectService.class);
            try {
                projectService.loadControlDataToSelection(project, selection);
                this.initSelectionYears(view);
                view.getValidDatesButton().setEnabled(true);
                view.getDetailAccordionPane().setSelected(1);
                JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.detail.controldatareloaded", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
            }
            catch (CoserBusinessException ex) {
                throw new CoserException("Can't reload control data", ex);
            }
        }
    }

    protected void updateSelectionYearsData(SelectionDetailsView view) {
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Object[] selectedDates = view.getYearsList().getSelectedValues();
        ArrayList<String> years = new ArrayList<String>(selectedDates.length);
        for (Object selectedDate : selectedDates) {
            years.add((String)selectedDate);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refreshing strata list");
        }
        try {
            List strata = projectService.filterDataYearsAndGetStrata(project, selection, years);
            view.getStrataListModel().setStrata(strata);
            view.getStrataList().addSelectionInterval(0, strata.size() - 1);
            view.getFilteredSpeciesListModel().setSpecies(new ArrayList<String>());
            view.getFilteredSpeciesList().clearSelection();
            view.getSelectedSpeciesListModel().setSpecies(new ArrayList<String>());
            view.getSelectedSpeciesList().clearSelection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Years list refreshed");
            }
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't filters data with specified years", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validSelectionYearsData(SelectionDetailsView view) {
        try {
            this.setWaitCursor((Component)((Object)view));
            this.updateSelectionYearsData(view);
            this.showSamplingEffort(view);
            JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.detail.yearsvalidated", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
            view.getDetailAccordionPane().setSelected(2);
        }
        finally {
            this.setDefaultCursor((Component)((Object)view));
        }
    }

    public void initView(SelectionDetailsView view) {
        Project project = view.getContextValue(Project.class);
        view.getStrataMap().initMap(project, view.getStataMapInfo());
        view.getStataMapInfo().setMap(view.getStrataMap().getMapBean());
        view.getStataMapInfo().setShowCoordsInfoLine(true);
        view.getStataMapInfo().setShowInfoLine(true);
    }

    protected void updateSelectionStrataData(SelectionDetailsView view) {
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Strata list selection changed, updating species list");
        }
        Object[] selectedStrata = view.getStrataList().getSelectedValues();
        ArrayList<String> strata = new ArrayList<String>(selectedStrata.length);
        for (Object selectedStratum : selectedStrata) {
            strata.add((String)selectedStratum);
        }
        projectService.filterDataStrata(project, selection, strata);
        view.getStrataListModel().setStrata(strata);
        ((CoserListSelectionModel)((Object)view.getStrataList().getSelectionModel())).setSelectedObjects(strata);
        this.updateSelectionSpecies(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validSelectionStrataData(SelectionDetailsView view) {
        try {
            this.setWaitCursor((Component)((Object)view));
            this.updateSelectionStrataData(view);
            this.showSamplingEffort(view);
            JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.detail.stratavalidated", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
            view.getDetailAccordionPane().setSelected(3);
        }
        finally {
            this.setDefaultCursor((Component)((Object)view));
        }
    }

    public void updateSelectionSpecies(SelectionDetailsView view) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Updating species list");
        }
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Object[] selectedSpeciesTypes = view.getTypeSpeciesList().getSelectedValues();
        ArrayList<String> speciesTypes = new ArrayList<String>();
        for (Object selectedSpeciesType : selectedSpeciesTypes) {
            speciesTypes.add((String)selectedSpeciesType);
        }
        List filteredSpecies = projectService.getProjectSpecies(project, (AbstractDataContainer)selection, speciesTypes);
        List<String> selectedSpecies = view.getSelectedSpeciesListModel().getSpecies();
        filteredSpecies.removeAll(selectedSpecies);
        view.getFilteredSpeciesListModel().setSpecies(filteredSpecies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validSelectionSpeciesData(SelectionDetailsView view) {
        try {
            this.setWaitCursor((Component)((Object)view));
            Project project = view.getContextValue(Project.class);
            Selection selection = view.getContextValue(Selection.class);
            ProjectService projectService = view.getContextValue(ProjectService.class);
            List<String> selectedSpecies = view.getSelectedSpeciesListModel().getSpecies();
            projectService.filterDataSpecies(project, selection, selectedSpecies);
            this.updateSelectionSpecies(view);
            JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.detail.speciesvalidated", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
        }
        finally {
            this.setDefaultCursor((Component)((Object)view));
        }
    }

    public void showYearsContextMenu(final SelectionDetailsView view, MouseEvent event) {
        if (event.getButton() == 3) {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem selectAllMenu = new JMenuItem(I18n._((String)"coser.ui.common.selectAll", (Object[])new Object[0]));
            selectAllMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int size = view.getYearsList().getModel().getSize();
                    view.getYearsList().getSelectionModel().addSelectionInterval(0, size - 1);
                }
            });
            popupMenu.add(selectAllMenu);
            JMenuItem unselectAllMenu = new JMenuItem(I18n._((String)"coser.ui.common.unselectAll", (Object[])new Object[0]));
            unselectAllMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    view.getYearsList().getSelectionModel().clearSelection();
                }
            });
            popupMenu.add(unselectAllMenu);
            popupMenu.show(view.getYearsList(), event.getX(), event.getY());
        }
    }

    public void showStrataContextMenu(final SelectionDetailsView view, MouseEvent event) {
        if (event.getButton() == 3) {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem selectAllMenu = new JMenuItem(I18n._((String)"coser.ui.common.selectAll", (Object[])new Object[0]));
            selectAllMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int size = view.getStrataList().getModel().getSize();
                    view.getStrataList().getSelectionModel().addSelectionInterval(0, size - 1);
                }
            });
            popupMenu.add(selectAllMenu);
            JMenuItem unselectAllMenu = new JMenuItem(I18n._((String)"coser.ui.common.unselectAll", (Object[])new Object[0]));
            unselectAllMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    view.getStrataList().getSelectionModel().clearSelection();
                }
            });
            popupMenu.add(unselectAllMenu);
            popupMenu.show(view.getStrataList(), event.getX(), event.getY());
        }
    }

    public void showFilteredSpeciesContextMenu(final SelectionDetailsView view, MouseEvent event) {
        if (event.getButton() == 3) {
            JPopupMenu popupMenu = new JPopupMenu();
            int[] selectedRows = view.getFilteredSpeciesList().getSelectedIndices();
            if (selectedRows.length > 1) {
                JMenuItem fusionMenu = new JMenuItem(I18n._((String)"coser.ui.selection.speciesMenuFusion", (Object[])new Object[0]));
                fusionMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpeciesFusionDialog speciesFusionDialog = new SpeciesFusionDialog((JAXXContext)view);
                        speciesFusionDialog.setHandler(SelectionHandler.this);
                        String firstSelected = (String)view.getFilteredSpeciesList().getSelectedValue();
                        speciesFusionDialog.getNewSpeciesNameField().setText(firstSelected);
                        speciesFusionDialog.setLocationRelativeTo((Component)((Object)view));
                        speciesFusionDialog.setVisible(true);
                    }
                });
                popupMenu.add(fusionMenu);
            }
            if (selectedRows.length > 0) {
                JMenuItem graphMenu = new JMenuItem(I18n._((String)"coser.ui.selection.details.displayDiffCatchLengthGraph", (Object[])new Object[0]));
                graphMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectionHandler.this.showSelectedSpeciesGraph(view, view.getFilteredSpeciesList());
                    }
                });
                popupMenu.add(graphMenu);
            }
            JMenuItem selectAllMenu = new JMenuItem(I18n._((String)"coser.ui.common.selectAll", (Object[])new Object[0]));
            selectAllMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int size = view.getFilteredSpeciesList().getModel().getSize();
                    view.getFilteredSpeciesList().getSelectionModel().addSelectionInterval(0, size - 1);
                }
            });
            popupMenu.add(selectAllMenu);
            JMenuItem unselectAllMenu = new JMenuItem(I18n._((String)"coser.ui.common.unselectAll", (Object[])new Object[0]));
            unselectAllMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    view.getFilteredSpeciesList().getSelectionModel().clearSelection();
                }
            });
            popupMenu.add(unselectAllMenu);
            popupMenu.show(view.getFilteredSpeciesList(), event.getX(), event.getY());
        }
    }

    public void showSelectedSpeciesContextMenu(final SelectionDetailsView view, MouseEvent event) {
        if (event.getButton() == 3) {
            JPopupMenu popupMenu = new JPopupMenu();
            int[] selectedRows = view.getSelectedSpeciesList().getSelectedIndices();
            if (selectedRows.length > 0) {
                JMenuItem graphMenu = new JMenuItem(I18n._((String)"coser.ui.selection.details.displayDiffCatchLengthGraph", (Object[])new Object[0]));
                graphMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectionHandler.this.showSelectedSpeciesGraph(view, view.getSelectedSpeciesList());
                    }
                });
                popupMenu.add(graphMenu);
            }
            JMenuItem selectAllMenu = new JMenuItem(I18n._((String)"coser.ui.common.selectAll", (Object[])new Object[0]));
            selectAllMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int size = view.getSelectedSpeciesList().getModel().getSize();
                    view.getSelectedSpeciesList().getSelectionModel().addSelectionInterval(0, size - 1);
                }
            });
            popupMenu.add(selectAllMenu);
            JMenuItem unselectAllMenu = new JMenuItem(I18n._((String)"coser.ui.common.unselectAll", (Object[])new Object[0]));
            unselectAllMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    view.getSelectedSpeciesList().getSelectionModel().clearSelection();
                }
            });
            popupMenu.add(unselectAllMenu);
            popupMenu.show(view.getSelectedSpeciesList(), event.getX(), event.getY());
        }
    }

    public void saveSelection(SelectionDetailsView view) {
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService service = view.getContextValue(ProjectService.class);
        SelectionView selectionView = view.getParentContainer(SelectionView.class);
        try {
            if (view.isCreationState().booleanValue()) {
                service.createProjectSelection(project, selection);
                selectionView.setCreationState(false);
                JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.selectionCreated", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
            } else {
                service.saveProjectSelection(project, selection);
                JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.selectionSaved", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
            }
        }
        catch (CoserBusinessException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save selection", (Throwable)ex);
            }
            JOptionPane.showMessageDialog((Component)((Object)view), ex.getMessage(), I18n._((String)"coser.ui.selection.saveError", (Object[])new Object[0]), 0);
        }
        selectionView.setEnabledAt(1, true);
    }

    public void saveSelection(SelectionListsView view) {
        boolean saved = this.saveProjectSelection(view);
        if (saved) {
            JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.selectionSaved", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
        }
    }

    protected boolean saveProjectSelection(SelectionListsView view) {
        boolean saved = false;
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService service = view.getContextValue(ProjectService.class);
        SelectionView selectionView = view.getParentContainer(SelectionView.class);
        this.saveSelectionLists(view, selection);
        try {
            service.saveProjectSelection(project, selection);
            saved = true;
        }
        catch (CoserBusinessException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't save selection", (Throwable)ex);
            }
            JOptionPane.showMessageDialog((Component)((Object)view), ex.getMessage(), I18n._((String)"coser.ui.selection.saveError", (Object[])new Object[0]), 0);
        }
        selectionView.setEnabledAt(2, selection.isValidated());
        return saved;
    }

    protected void saveSelectionLists(SelectionListsView view, Selection selection) {
        Object[] maturitySpeciesSelection;
        Object[] sizeAllYearSpeciesSelection;
        Object[] occDensSpeciesSelection;
        ArrayList<String> occDensList = new ArrayList<String>();
        for (Object occDensSpecies : occDensSpeciesSelection = view.getSelectionOccurrenceDensityList().getSelectedValues()) {
            occDensList.add((String)occDensSpecies);
        }
        ArrayList<String> sizeAllYearList = new ArrayList<String>();
        for (Object sizeAllYearSpecies : sizeAllYearSpeciesSelection = view.getSelectionSizeAllYearList().getSelectedValues()) {
            sizeAllYearList.add((String)sizeAllYearSpecies);
        }
        ArrayList<String> maturityList = new ArrayList<String>();
        for (Object maturitySpecies : maturitySpeciesSelection = view.getSelectionMaturityList().getSelectedValues()) {
            maturityList.add((String)maturitySpecies);
        }
        selection.setSelectedSpeciesOccDens(occDensList);
        selection.setSelectedSpeciesSizeAllYear(sizeAllYearList);
        selection.setSelectedSpeciesMaturity(maturityList);
    }

    public void validSelection(SelectionListsView view) {
        Selection selection = view.getContextValue(Selection.class);
        this.saveSelectionLists(view, selection);
        boolean canBeValidated = this.checkSelectionListComments(view, selection);
        if (canBeValidated) {
            selection.setValidated(true);
            boolean saved = this.saveProjectSelection(view);
            if (saved) {
                JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.selectionValidated", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
            }
        }
    }

    protected boolean checkSelectionListComments(SelectionListsView view, Selection selection) {
        double density;
        double occurrence;
        Set<String> originalOccDensSelection;
        boolean canValidate = true;
        HashSet currentOccDensSelection = new HashSet(selection.getSelectedSpeciesOccDens());
        if (!((Object)currentOccDensSelection).equals(originalOccDensSelection = this.getOccurenceDensityFilteredSpecies(view, occurrence = selection.getOccurrenceFilter(), density = selection.getDensityFilter())) && StringUtils.isBlank((String)selection.getSelectedSpeciesOccDensComment())) {
            JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.nonJustifiedOccurenceDensity", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.nonJustifiedTitle", (Object[])new Object[0]), 0);
            view.getOccurrenceDensityCommentField().requestFocus();
            canValidate = false;
        }
        if (canValidate) {
            int sizeAllYearSpeciesInModel = view.getSelectionSizeAllYearListModel().getSize();
            int[] sizeAllYearSpeciesSelection = view.getSelectionSizeAllYearList().getSelectedIndices();
            if (sizeAllYearSpeciesSelection.length < sizeAllYearSpeciesInModel && StringUtils.isBlank((String)selection.getSelectedSpeciesSizeAllYearComment())) {
                JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.nonJustifiedSizeAllYear", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.nonJustifiedTitle", (Object[])new Object[0]), 0);
                view.getSizeAllYearCommentField().requestFocus();
                canValidate = false;
            }
        }
        if (canValidate) {
            int maturitySpeciesInModel = view.getSelectionMaturityListModel().getSize();
            int[] maturitySpeciesSelection = view.getSelectionMaturityList().getSelectedIndices();
            if (maturitySpeciesSelection.length < maturitySpeciesInModel && StringUtils.isBlank((String)selection.getSelectedSpeciesMaturityComment())) {
                JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.nonJustifiedMaturity", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.nonJustifiedTitle", (Object[])new Object[0]), 0);
                view.getMaturityCommentField().requestFocus();
                canValidate = false;
            }
        }
        return canValidate;
    }

    public void updateOccurrenceDensityFilter(SelectionListsView view) {
        block2: {
            Selection selection = view.getContextValue(Selection.class);
            String stringOccurrence = view.getSelectionFilterOccurrenceField().getText().trim();
            String stringDensity = view.getSelectionFilterDensityField().getText().trim();
            try {
                double occurrence = Double.valueOf(stringOccurrence);
                double density = Double.valueOf(stringDensity);
                selection.setOccurrenceFilter(occurrence);
                selection.setDensityFilter(density);
                Set<String> filteredSpeciesSet = this.getOccurenceDensityFilteredSpecies(view, occurrence, density);
                ArrayList<String> filteredSpecies = new ArrayList<String>(filteredSpeciesSet);
                Collections.sort(filteredSpecies);
                ((CoserListSelectionModel)((Object)view.getSelectionOccurrenceDensityList().getSelectionModel())).setSelectedObjects(filteredSpecies);
                ((CoserListSelectionModel)((Object)view.getSelectionSizeAllYearList().getSelectionModel())).fillSelection();
                ((CoserListSelectionModel)((Object)view.getSelectionMaturityList().getSelectionModel())).fillSelection();
            }
            catch (NumberFormatException ex) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Can't parse occurrence or density as double", (Throwable)ex);
            }
        }
    }

    protected Set<String> getOccurenceDensityFilteredSpecies(SelectionListsView view, double occurrence, double density) {
        OccurrenceDensitySpeciesListModel model = view.getSelectionOccurrenceDensityListModel();
        int speciesCount = model.getSize();
        HashSet<String> filteredSpecies = new HashSet<String>();
        for (int speciesIndex = 0; speciesIndex < speciesCount; ++speciesIndex) {
            String species = (String)model.getElementAt(speciesIndex);
            if (!(model.getDensity(species) >= density) || !(model.getOccurrence(species) >= occurrence)) continue;
            filteredSpecies.add(species);
        }
        return filteredSpecies;
    }

    public void performMergeSpecies(SpeciesFusionDialog view) {
        String newSpeciesName = view.getNewSpeciesNameField().getText();
        String comment = view.getCommentField().getText();
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        boolean newSpeciesExist = projectService.isSpeciesNameExist(project, newSpeciesName);
        if (!newSpeciesExist) {
            JOptionPane.showMessageDialog(view, I18n._((String)"coser.ui.selection.invalidFusionName", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.fusionError", (Object[])new Object[0]), 0);
            view.getNewSpeciesNameField().requestFocus();
        } else {
            SelectionDetailsView parent = view.getContextValue(SelectionDetailsView.class, "parent");
            Object[] selectedSpecies = parent.getFilteredSpeciesList().getSelectedValues();
            String[] speciesNames = new String[selectedSpecies.length];
            for (int i = 0; i < selectedSpecies.length; ++i) {
                String singleSelectedSpecies;
                speciesNames[i] = singleSelectedSpecies = (String)selectedSpecies[i];
            }
            try {
                projectService.mergeSpecies(project, selection, newSpeciesName, comment, speciesNames);
            }
            catch (CoserBusinessException ex) {
                throw new CoserException("Can't merge species", ex);
            }
            this.updateSelectionSpecies(parent);
            parent.getFilteredSpeciesListSelectionModel().clearSelection();
            view.dispose();
            JOptionPane.showMessageDialog(view, I18n._((String)"coser.ui.selection.speciesMerged", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
        }
    }

    public void showSamplingEffort(SelectionDetailsView view) {
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        MatrixND samplingEffort = projectService.getSamplingEffort(project, selection);
        view.getMatrixPanelEditor().setMatrix(samplingEffort);
        view.getMatrixPanelEditor().getTable().setDefaultRenderer(String.class, (TableCellRenderer)((Object)new SamplingEffortRenderer((MatrixTableModelND)view.getMatrixPanelEditor().getTable().getModel())));
    }

    public void showStataOnMap(SelectionDetailsView view) {
        Selection selection = view.getContextValue(Selection.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Object[] selectedStrataArray = view.getStrataList().getSelectedValues();
        HashSet<String> selectedStata = new HashSet<String>();
        for (Object selectedStrataItem : selectedStrataArray) {
            selectedStata.add((String)selectedStrataItem);
        }
        try {
            List hauls = projectService.getStrataHaulCoordinate(selection, selectedStata);
            view.getStrataMap().addStataHaulLayer(hauls);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't display stata's hauls on map", ex);
        }
    }

    public void displayCompareNumberCatchGraph(SelectionListsView view) {
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        SwingSession session = view.getContextValue(SwingSession.class);
        PublicationService publicationService = view.getContextValue(PublicationService.class);
        Map charts = publicationService.getCompareCatchLengthGraph(project, (AbstractDataContainer)selection, null);
        view.setContextValue(charts, "CompareCatchLengthGraph");
        List<String> species = view.getSelectionSizeAllYearListModel().getSpecies();
        JFrame previousFrame = view.getContextValue(JFrame.class, "comparenumberframe");
        if (previousFrame != null) {
            previousFrame.dispose();
        }
        ControlGraphFrame frame = new ControlGraphFrame((JAXXContext)view);
        frame.setHandler(new ControlHandler());
        frame.setContextValue(charts);
        frame.getSpecyComboModel().setSpecy(species);
        frame.pack();
        frame.setLocationRelativeTo((Component)((Object)view));
        session.add((Component)frame);
        frame.toFront();
        frame.setVisible(true);
        view.setContextValue(frame, "comparenumberframe");
    }

    public void displayLengthStructureGraph(SelectionListsView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        SwingSession session = view.getContextValue(SwingSession.class);
        this.displayLengthStructureGraph((Component)((Object)view), session, projectService, project, (AbstractDataContainer)selection);
    }

    public void addSelectedFilteredSpecies(SelectionDetailsView view) {
        Object[] selectedFilteredSpecies = view.getFilteredSpeciesList().getSelectedValues();
        HashSet<String> selectedSpecies = new HashSet<String>();
        if (view.getSelectedSpeciesListModel().getSpecies() != null) {
            selectedSpecies.addAll(view.getSelectedSpeciesListModel().getSpecies());
        }
        for (Object singleSelectedFilteredSpecies : selectedFilteredSpecies) {
            selectedSpecies.add((String)singleSelectedFilteredSpecies);
        }
        ArrayList<String> selectedSpeciesList = new ArrayList<String>(selectedSpecies);
        Collections.sort(selectedSpeciesList);
        view.getSelectedSpeciesListModel().setSpecies(selectedSpeciesList);
        List<String> filteredSpecies = view.getFilteredSpeciesListModel().getSpecies();
        filteredSpecies.removeAll(selectedSpeciesList);
        view.getFilteredSpeciesListModel().setSpecies(filteredSpecies);
    }

    public void removeSelectedSpecies(SelectionDetailsView view) {
        Object[] selectedSelectedSpecies;
        ArrayList<String> filteredSpecies = new ArrayList<String>(view.getFilteredSpeciesListModel().getSpecies());
        ArrayList<String> selectedSpecies = new ArrayList<String>(view.getSelectedSpeciesListModel().getSpecies());
        for (Object singleSelectedSelectedSpecies : selectedSelectedSpecies = view.getSelectedSpeciesList().getSelectedValues()) {
            selectedSpecies.remove((String)singleSelectedSelectedSpecies);
            filteredSpecies.add((String)singleSelectedSelectedSpecies);
        }
        Collections.sort(selectedSpecies);
        Collections.sort(filteredSpecies);
        view.getSelectedSpeciesListModel().setSpecies(selectedSpecies);
        view.getFilteredSpeciesListModel().setSpecies(filteredSpecies);
    }

    public void showSelectedSpeciesGraph(SelectionDetailsView view, JList source) {
        PublicationService publicationService = view.getContextValue(PublicationService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        Object[] selectedSpecies = source.getSelectedValues();
        HashSet<String> graphSpecies = new HashSet<String>();
        for (Object selectedSingleSpecies : selectedSpecies) {
            graphSpecies.add((String)selectedSingleSpecies);
        }
        Map chartsMap = publicationService.getCompareCatchLengthGraph(project, (AbstractDataContainer)selection, graphSpecies);
        Collection charts = chartsMap.values();
        JPanel graphPanel = view.getSpeciesGraphPanel();
        graphPanel.removeAll();
        Iterator itCharts = charts.iterator();
        int chartIndex = 0;
        while (itCharts.hasNext()) {
            JFreeChart chart = (JFreeChart)itCharts.next();
            ChartPanel chartPanel = new ChartPanel(chart);
            view.getSpeciesGraphPanel().add((Component)chartPanel, new GridBagConstraints(0, chartIndex, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            ++chartIndex;
        }
        view.getDetailDecisionPanelLayout().show(view.getDetailDecisionPanel(), "SPECIESGRAPH");
        view.getDetailDecisionPanel().validate();
        view.getDetailDecisionPanel().repaint();
    }

    public void showAddResultDialog(SelectionRsufiView view) {
        SelectionAddResultDialog addResultView = new SelectionAddResultDialog((JAXXContext)view);
        Project project = view.getContextValue(Project.class);
        RSufiResult rsufiresult = new RSufiResult();
        rsufiresult.setName("RSUFI_RESULTS_" + project.getName());
        addResultView.setRsufiResult(rsufiresult);
        addResultView.getValidatorRSufiResult().setBean((Object)addResultView.getRsufiResult());
        addResultView.setHandler(this);
        addResultView.pack();
        addResultView.setLocationRelativeTo((Component)((Object)view));
        addResultView.setVisible(true);
    }

    public void showEditResultDialog(SelectionRsufiView view) {
        int selectedRow = view.getSelectionResultsTable().getSelectedRow();
        RSufiResult result = view.getSelectionResultsTableModel().getValue(selectedRow);
        SelectionEditResultDialog editResultView = new SelectionEditResultDialog((JAXXContext)view);
        editResultView.setRsufiResult(result);
        editResultView.setHandler(this);
        editResultView.pack();
        editResultView.setLocationRelativeTo((Component)((Object)view));
        editResultView.setVisible(true);
    }

    public void performAddResult(SelectionAddResultDialog view) {
        this.setWaitCursor(view);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        List<File> otherFiles = view.getOtherDataFileListModel().getOtherFiles();
        RSufiResult newResult = view.getRsufiResult();
        try {
            projectService.saveRsufiResults(project, selection, newResult, otherFiles);
        }
        catch (CoserBusinessException ex) {
            JOptionPane.showMessageDialog(view, ex.getMessage(), I18n._((String)"coser.ui.result.saveError", (Object[])new Object[0]), 0);
            throw new CoserException("Can't save result", ex);
        }
        finally {
            this.setDefaultCursor(view);
        }
        view.dispose();
    }

    public void performEditResult(SelectionEditResultDialog view) {
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        ProjectService projectService = view.getContextValue(ProjectService.class);
        RSufiResult editedResult = view.getRsufiResult();
        try {
            projectService.saveRsufiResults(project, selection, editedResult);
        }
        catch (CoserBusinessException ex) {
            JOptionPane.showMessageDialog(view, ex.getMessage(), I18n._((String)"coser.ui.result.saveError", (Object[])new Object[0]), 0);
            throw new CoserException("Can't save result", ex);
        }
        view.dispose();
    }

    public void selectOutputDirectory(SelectionRsufiView view, JTextField textComponent) {
        JFileChooser selectFileChooser = this.getFileChooserInstance(null);
        selectFileChooser.setFileSelectionMode(1);
        int result = selectFileChooser.showOpenDialog((Component)((Object)view));
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            textComponent.setText(selectedFile.getAbsolutePath());
        }
    }

    public void extractRSufiData(SelectionRsufiView view) {
        ProjectService projectService = view.getContextValue(ProjectService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        String directoryPath = view.getResultExtractDataField().getText();
        File directory = new File(directoryPath);
        try {
            projectService.extractRSUfiData(project, selection, directory, false);
            JOptionPane.showMessageDialog((Component)((Object)view), I18n._((String)"coser.ui.selection.rsufidataextracted", (Object[])new Object[0]), I18n._((String)"coser.ui.selection.selectionTitle", (Object[])new Object[0]), 1);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't extract rsufi files", ex);
        }
    }

    public void selectResultFile(SelectionAddResultDialog view, JTextField textComponent) {
        CoserConfig config = view.getContextValue(CoserConfig.class);
        JFileChooser selectFileChooser = this.getFileChooserInstance(config.getProjectsDirectory());
        selectFileChooser.setFileSelectionMode(0);
        int result = selectFileChooser.showOpenDialog(view);
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            textComponent.setText(selectedFile.getAbsolutePath());
        }
    }

    public void selectMapsDirectory(SelectionAddResultDialog view, JTextField textComponent) {
        CoserConfig config = view.getContextValue(CoserConfig.class);
        JFileChooser selectFileChooser = this.getFileChooserInstance(config.getProjectsDirectory());
        selectFileChooser.setFileSelectionMode(1);
        int result = selectFileChooser.showOpenDialog(view);
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            textComponent.setText(selectedFile.getAbsolutePath());
        }
    }

    public void selectResultFileOrDirectory(SelectionAddResultDialog view, JList listComponent) {
        CoserConfig config = view.getContextValue(CoserConfig.class);
        JFileChooser selectFileChooser = this.getFileChooserInstance(config.getProjectsDirectory());
        selectFileChooser.setFileSelectionMode(2);
        int result = selectFileChooser.showOpenDialog(view);
        if (result == 0) {
            File selectedFile = selectFileChooser.getSelectedFile();
            view.getOtherDataFileListModel().add(selectedFile);
        }
    }

    public void displayLogReport(SelectionDetailsView view) {
        PublicationService publicationService = view.getContextValue(PublicationService.class);
        Project project = view.getContextValue(Project.class);
        Selection selection = view.getContextValue(Selection.class);
        File htmlFile = null;
        try {
            htmlFile = publicationService.extractSelectionLogAsHTML(project, selection);
            this.browseFile((Component)((Object)view), htmlFile);
        }
        catch (CoserBusinessException ex) {
            throw new CoserException("Can't generate html report", ex);
        }
    }
}

