/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services;

import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.JWTVerifyException;
import fr.ifremer.coselmar.beans.UserWebToken;
import fr.ifremer.coselmar.config.CoselmarServicesConfig;
import fr.ifremer.coselmar.exceptions.CoselmarTechnicalException;
import fr.ifremer.coselmar.persistence.CoselmarPersistenceContext;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserGroupTopiaDao;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserTopiaDao;
import fr.ifremer.coselmar.persistence.entity.DocumentTopiaDao;
import fr.ifremer.coselmar.persistence.entity.QuestionTopiaDao;
import fr.ifremer.coselmar.services.CoselmarRestRequestContext;
import fr.ifremer.coselmar.services.CoselmarService;
import fr.ifremer.coselmar.services.CoselmarServicesContext;
import fr.ifremer.coselmar.services.errors.InvalidCredentialException;
import fr.ifremer.coselmar.services.v1.DocumentsWebService;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.WebMotionController;
import org.debux.webmotion.server.call.HttpContext;
import org.nuiton.topia.persistence.TopiaNoResultException;

public abstract class CoselmarWebServiceSupport
extends WebMotionController
implements CoselmarService {
    private static final Log log = LogFactory.getLog(CoselmarWebServiceSupport.class);
    private CoselmarServicesContext servicesContext;

    public void setServicesContext(CoselmarServicesContext servicesContext) {
        this.servicesContext = servicesContext;
    }

    protected CoselmarServicesContext getServicesContext() {
        HttpContext context = this.getContext();
        if (context != null) {
            CoselmarRestRequestContext requestContext = CoselmarRestRequestContext.getRequestContext((HttpContext)context);
            this.servicesContext = requestContext.getServicesContext();
        }
        return this.servicesContext;
    }

    protected Date getNow() {
        return this.getServicesContext().getNow();
    }

    protected String getCleanMail(String email) {
        return this.getServicesContext().getCleanMail(email);
    }

    protected CoselmarPersistenceContext getPersistenceContext() {
        return this.getServicesContext().getPersistenceContext();
    }

    protected CoselmarServicesConfig getCoselmarServicesConfig() {
        return this.getServicesContext().getCoselmarServicesConfig();
    }

    protected Locale getLocale() {
        return this.servicesContext.getLocale();
    }

    public DocumentsWebService getDocumentsService() {
        return (DocumentsWebService)this.newService(DocumentsWebService.class);
    }

    protected <E extends CoselmarService> E newService(Class<E> serviceClass) {
        return (E)this.getServicesContext().newService(serviceClass);
    }

    protected DocumentTopiaDao getDocumentDao() {
        return this.getPersistenceContext().getDocumentDao();
    }

    protected CoselmarUserTopiaDao getCoselmarUserDao() {
        return this.getPersistenceContext().getCoselmarUserDao();
    }

    protected CoselmarUserGroupTopiaDao getCoselmarUserGroupDao() {
        return this.getPersistenceContext().getCoselmarUserGroupDao();
    }

    protected QuestionTopiaDao getQuestionDao() {
        return this.getPersistenceContext().getQuestionDao();
    }

    public void commit() {
        this.getPersistenceContext().commit();
    }

    public void rollback() {
        this.getPersistenceContext().rollback();
    }

    @Deprecated
    protected UserWebToken checkAuthentication(String authorization) throws InvalidCredentialException {
        try {
            String webSecurityKey = this.getServicesContext().getCoselmarServicesConfig().getWebSecurityKey();
            JWTVerifier jwtVerifier = new JWTVerifier(webSecurityKey, "audience");
            String token = StringUtils.replace((String)authorization, (String)"Bearer ", (String)"");
            Map claims = jwtVerifier.verify(token);
            UserWebToken userWebToken = new UserWebToken(claims);
            return userWebToken;
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during JWT verification : wrong Algorithm !", (Throwable)e);
            }
            throw new CoselmarTechnicalException((Throwable)e);
        }
        catch (SignatureException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during JWT verification : bad signature!", (Throwable)e);
            }
            throw new InvalidCredentialException("Error with signature");
        }
        catch (JWTVerifyException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during JWT verification : bad claims!", (Throwable)e);
            }
            throw new InvalidCredentialException("Error with claims");
        }
        catch (IllegalStateException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during JWT verification : no token!", (Throwable)e);
            }
            throw new InvalidCredentialException("Seems no user connected");
        }
    }

    protected CoselmarUser checkUserAuthentication(String authorization) throws InvalidCredentialException {
        try {
            String webSecurityKey = this.getServicesContext().getCoselmarServicesConfig().getWebSecurityKey();
            JWTVerifier jwtVerifier = new JWTVerifier(webSecurityKey, "audience");
            String token = StringUtils.replace((String)authorization, (String)"Bearer ", (String)"");
            Map claims = jwtVerifier.verify(token);
            UserWebToken userWebToken = new UserWebToken(claims);
            String userId = this.getFullUserIdFromShort(userWebToken.getUserId());
            CoselmarUser coselmarUser = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(userId).findAny();
            return coselmarUser;
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during JWT verification : wrong Algorithm !", (Throwable)e);
            }
            throw new CoselmarTechnicalException((Throwable)e);
        }
        catch (SignatureException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during JWT verification : bad signature!", (Throwable)e);
            }
            throw new InvalidCredentialException("Error with signature");
        }
        catch (JWTVerifyException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during JWT verification : bad claims!", (Throwable)e);
            }
            throw new InvalidCredentialException("Error with claims");
        }
        catch (TopiaNoResultException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during authorization check : user does not exist !", (Throwable)e);
            }
            throw new InvalidCredentialException("User not known");
        }
        catch (IllegalStateException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during JWT verification : no token!", (Throwable)e);
            }
            throw new InvalidCredentialException("Seems no user connected");
        }
    }

    protected String getFullUserIdFromShort(String shortUserId) {
        return CoselmarUser.class.getCanonicalName() + this.getPersistenceContext().getTopiaIdFactory().getSeparator() + shortUserId;
    }

    protected String getFullIdFromShort(Class clazz, String shortId) {
        return clazz.getCanonicalName() + this.getPersistenceContext().getTopiaIdFactory().getSeparator() + shortId;
    }

    protected String getShortIdFromFull(String fullId) {
        return this.getPersistenceContext().getTopiaIdFactory().getRandomPart(fullId);
    }
}

