/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.indexation;

import fr.ifremer.coselmar.config.CoselmarServicesConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NIOFSDirectory;

public class LuceneUtils {
    private static final Log log = LogFactory.getLog(LuceneUtils.class);
    public Analyzer analyzer;
    public final IndexWriterConfig indexationConfig = new IndexWriterConfig(this.getAnalyzer());
    public IndexWriter indexWriter;
    protected CoselmarServicesConfig servicesConfig;

    public LuceneUtils(CoselmarServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    protected Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(FrenchAnalyzer.getDefaultStopSet());
        }
        return this.analyzer;
    }

    public IndexWriter getIndexWriter() throws IOException {
        if (this.indexWriter == null) {
            File indexDirectory = this.servicesConfig.getIndexDirectory();
            FSDirectory index = NIOFSDirectory.open((Path)indexDirectory.toPath());
            this.indexationConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            this.indexWriter = new IndexWriter((Directory)index, this.indexationConfig);
        }
        return this.indexWriter;
    }

    public void closeWriter() {
        block3: {
            if (this.indexWriter != null) {
                try {
                    this.indexWriter.close();
                }
                catch (IOException | IllegalStateException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Unable to close lucene index writer", (Throwable)e);
                }
            }
        }
    }

    public void clearIndex() throws IOException {
        this.getIndexWriter().deleteAll();
        this.getIndexWriter().commit();
    }
}

