/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.maven.jgitflow.api.MavenHotfixFinishExtension;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.mojo.AbstractJGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="hotfix-finish", aggregator=true, requiresDependencyResolution=ResolutionScope.TEST)
public class HotfixFinishMojo
extends AbstractJGitFlowMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules = false;
    @Parameter(property="developmentVersion", defaultValue="")
    private String developmentVersion = "";
    @Parameter(defaultValue="false", property="pushHotfixes")
    private boolean pushHotfixes = false;
    @Parameter(defaultValue="false", property="noDeploy")
    private boolean noDeploy = false;
    @Parameter(defaultValue="false", property="keepBranch")
    private boolean keepBranch = false;
    @Parameter(defaultValue="false", property="squash")
    private boolean squash = false;
    @Parameter(defaultValue="false", property="noTag")
    private boolean noTag = false;
    @Parameter(defaultValue="false", property="noHotfixBuild")
    private boolean noHotfixBuild = false;
    @Parameter(defaultValue="true", property="useReleaseProfile")
    private boolean useReleaseProfile = true;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies = true;
    @Parameter(property="tagMessage", defaultValue="")
    private String tagMessage = "";
    @Component(hint="hotfix")
    FlowReleaseManager releaseManager;
    @Parameter(defaultValue="")
    private String hotfixFinishExtension = "";

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassloader(this.getClasspath()));
        MavenHotfixFinishExtension extensionObject = (MavenHotfixFinishExtension)this.getExtensionInstance(this.hotfixFinishExtension);
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setInteractive(this.getSettings().isInteractiveMode()).setAutoVersionSubmodules(this.autoVersionSubmodules).setAllowSnapshots(this.allowSnapshots).setDefaultDevelopmentVersion(this.developmentVersion).setPushHotfixes(this.pushHotfixes).setKeepBranch(this.keepBranch).setSquash(this.squash).setNoTag(this.noTag).setNoDeploy(this.noDeploy).setUseReleaseProfile(this.useReleaseProfile).setTagMessage(this.tagMessage).setUpdateDependencies(this.updateDependencies).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setAllowRemote(this.isRemoteAllowed()).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setNoBuild(this.noHotfixBuild).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setScmCommentSuffix(this.scmCommentSuffix).setUsername(this.username).setPassword(this.password).setPullMaster(this.pullMaster).setPullDevelop(this.pullDevelop).setHotfixFinishExtension(extensionObject).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.finish(ctx, this.getReactorProjects(), this.session);
        }
        catch (MavenJGitFlowException e) {
            throw new MojoExecutionException("Error finishing hotfix: " + e.getMessage(), (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }
}

