/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.Block;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Emitter;
import com.github.rjeschke.txtmark.HTML;
import com.github.rjeschke.txtmark.Line;
import com.github.rjeschke.txtmark.LinkRef;
import com.github.rjeschke.txtmark.MarkToken;
import com.github.rjeschke.txtmark.Utils;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultEmitter
implements Emitter {
    private final HashMap<String, LinkRef> linkRefs = new HashMap();
    private final Configuration config;
    public boolean useExtensions = false;

    public DefaultEmitter(Configuration config) {
        this.config = config;
        this.useExtensions = config.forceExtendedProfile;
    }

    @Override
    public void setUseExtensions(boolean useExtensions) {
        this.useExtensions = useExtensions;
    }

    @Override
    public void addLinkRef(String key, LinkRef linkRef) {
        this.linkRefs.put(key.toLowerCase(), linkRef);
    }

    @Override
    public void emit(StringBuilder out, Block root) {
        root.removeSurroundingEmptyLines();
        switch (root.type) {
            case RULER: {
                this.config.decorator.horizontalRuler(out);
                return;
            }
            case NONE: 
            case XML: {
                break;
            }
            case HEADLINE: {
                this.config.decorator.openHeadline(out, root.hlDepth);
                if (this.useExtensions && root.id != null) {
                    out.append(" id=\"");
                    Utils.appendCode(out, root.id, 0, root.id.length());
                    out.append('\"');
                }
                out.append('>');
                break;
            }
            case PARAGRAPH: {
                this.config.decorator.openParagraph(out);
                break;
            }
            case CODE: 
            case FENCED_CODE: {
                if (this.config.codeBlockEmitter != null) break;
                this.config.decorator.openCodeBlock(out);
                break;
            }
            case BLOCKQUOTE: {
                this.config.decorator.openBlockquote(out);
                break;
            }
            case UNORDERED_LIST: {
                this.config.decorator.openUnorderedList(out);
                break;
            }
            case ORDERED_LIST: {
                this.config.decorator.openOrderedList(out);
                break;
            }
            case LIST_ITEM: {
                this.config.decorator.openListItem(out);
                if (this.useExtensions && root.id != null) {
                    out.append(" id=\"");
                    Utils.appendCode(out, root.id, 0, root.id.length());
                    out.append('\"');
                }
                out.append('>');
            }
        }
        if (root.hasLines()) {
            this.emitLines(out, root);
        } else {
            Block block = root.blocks;
            while (block != null) {
                this.emit(out, block);
                block = block.next;
            }
        }
        switch (root.type) {
            case RULER: 
            case NONE: 
            case XML: {
                break;
            }
            case HEADLINE: {
                this.config.decorator.closeHeadline(out, root.hlDepth);
                break;
            }
            case PARAGRAPH: {
                this.config.decorator.closeParagraph(out);
                break;
            }
            case CODE: 
            case FENCED_CODE: {
                if (this.config.codeBlockEmitter != null) break;
                this.config.decorator.closeCodeBlock(out);
                break;
            }
            case BLOCKQUOTE: {
                this.config.decorator.closeBlockquote(out);
                break;
            }
            case UNORDERED_LIST: {
                this.config.decorator.closeUnorderedList(out);
                break;
            }
            case ORDERED_LIST: {
                this.config.decorator.closeOrderedList(out);
                break;
            }
            case LIST_ITEM: {
                this.config.decorator.closeListItem(out);
            }
        }
    }

    private void emitLines(StringBuilder out, Block block) {
        switch (block.type) {
            case CODE: {
                this.emitCodeLines(out, block.lines, block.meta, true);
                break;
            }
            case FENCED_CODE: {
                this.emitCodeLines(out, block.lines, block.meta, false);
                break;
            }
            case XML: {
                this.emitRawLines(out, block.lines);
                break;
            }
            default: {
                this.emitMarkedLines(out, block.lines);
            }
        }
    }

    private int findToken(String in, int start, MarkToken token) {
        for (int pos = start; pos < in.length(); ++pos) {
            if (this.getToken(in, pos) != token) continue;
            return pos;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int checkLink(StringBuilder out, String in, int start, MarkToken token) {
        boolean isAbbrev = false;
        int pos = start + (token == MarkToken.LINK ? 1 : 2);
        StringBuilder temp = new StringBuilder();
        temp.setLength(0);
        pos = Utils.readMdLinkId(temp, in, pos);
        if (pos < start) {
            return -1;
        }
        String name = temp.toString();
        String link = null;
        String comment = null;
        int oldPos = pos++;
        if ((pos = Utils.skipSpaces(in, pos)) < start) {
            LinkRef lr = this.linkRefs.get(name.toLowerCase());
            if (lr == null) return -1;
            isAbbrev = lr.isAbbrev;
            link = lr.link;
            comment = lr.title;
            pos = oldPos;
        } else if (in.charAt(pos) == '(') {
            ++pos;
            if ((pos = Utils.skipSpaces(in, pos)) < start) {
                return -1;
            }
            temp.setLength(0);
            boolean useLt = in.charAt(pos) == '<';
            int n = pos = useLt ? Utils.readUntil(temp, in, pos + 1, '>') : Utils.readMdLink(temp, in, pos);
            if (pos < start) {
                return -1;
            }
            if (useLt) {
                ++pos;
            }
            link = temp.toString();
            if (in.charAt(pos) == ' ' && (pos = Utils.skipSpaces(in, pos)) > start && in.charAt(pos) == '\"') {
                ++pos;
                temp.setLength(0);
                pos = Utils.readUntil(temp, in, pos, '\"');
                if (pos < start) {
                    return -1;
                }
                comment = temp.toString();
                ++pos;
                if ((pos = Utils.skipSpaces(in, pos)) == -1) {
                    return -1;
                }
            }
            if (in.charAt(pos) != ')') {
                return -1;
            }
        } else if (in.charAt(pos) == '[') {
            ++pos;
            temp.setLength(0);
            pos = Utils.readRawUntil(temp, in, pos, ']');
            if (pos < start) {
                return -1;
            }
            String id = temp.length() > 0 ? temp.toString() : name;
            LinkRef lr = this.linkRefs.get(id.toLowerCase());
            if (lr != null) {
                link = lr.link;
                comment = lr.title;
            }
        } else {
            LinkRef lr = this.linkRefs.get(name.toLowerCase());
            if (lr == null) return -1;
            isAbbrev = lr.isAbbrev;
            link = lr.link;
            comment = lr.title;
            pos = oldPos;
        }
        if (link == null) {
            return -1;
        }
        if (token == MarkToken.LINK) {
            if (isAbbrev && comment != null) {
                if (!this.useExtensions) {
                    return -1;
                }
                out.append("<abbr title=\"");
                Utils.appendValue(out, comment, 0, comment.length());
                out.append("\">");
                this.recursiveEmitLine(out, name, 0, MarkToken.NONE);
                out.append("</abbr>");
                return pos;
            } else {
                this.config.decorator.openLink(out);
                out.append(" href=\"");
                Utils.appendValue(out, link, 0, link.length());
                out.append('\"');
                if (comment != null) {
                    out.append(" title=\"");
                    Utils.appendValue(out, comment, 0, comment.length());
                    out.append('\"');
                }
                out.append('>');
                this.recursiveEmitLine(out, name, 0, MarkToken.NONE);
                this.config.decorator.closeLink(out);
            }
            return pos;
        } else {
            this.config.decorator.openImage(out);
            out.append(" src=\"");
            Utils.appendValue(out, link, 0, link.length());
            out.append("\" alt=\"");
            Utils.appendValue(out, name, 0, name.length());
            out.append('\"');
            if (comment != null) {
                out.append(" title=\"");
                Utils.appendValue(out, comment, 0, comment.length());
                out.append('\"');
            }
            this.config.decorator.closeImage(out);
        }
        return pos;
    }

    private int checkHtml(StringBuilder out, String in, int start) {
        StringBuilder temp = new StringBuilder();
        temp.setLength(0);
        int pos = Utils.readUntil(temp, in, start + 1, ':', ' ', '>', '\n');
        if (pos != -1 && in.charAt(pos) == ':' && HTML.isLinkPrefix(temp.toString()) && (pos = Utils.readUntil(temp, in, pos, '>')) != -1) {
            String link = temp.toString();
            this.config.decorator.openLink(out);
            out.append(" href=\"");
            Utils.appendValue(out, link, 0, link.length());
            out.append("\">");
            Utils.appendValue(out, link, 0, link.length());
            this.config.decorator.closeLink(out);
            return pos;
        }
        temp.setLength(0);
        pos = Utils.readUntil(temp, in, start + 1, '@', ' ', '>', '\n');
        if (pos != -1 && in.charAt(pos) == '@' && (pos = Utils.readUntil(temp, in, pos, '>')) != -1) {
            String link = temp.toString();
            this.config.decorator.openLink(out);
            out.append(" href=\"");
            Utils.appendMailto(out, "mailto:", 0, 7);
            Utils.appendMailto(out, link, 0, link.length());
            out.append("\">");
            Utils.appendMailto(out, link, 0, link.length());
            this.config.decorator.closeLink(out);
            return pos;
        }
        if (start + 2 < in.length()) {
            temp.setLength(0);
            return Utils.readXML(out, in, start, this.config.safeMode);
        }
        return -1;
    }

    private static int checkEntity(StringBuilder out, String in, int start) {
        int pos = Utils.readUntil(out, in, start, ';');
        if (pos < 0 || out.length() < 3) {
            return -1;
        }
        if (out.charAt(1) == '#') {
            if (out.charAt(2) == 'x' || out.charAt(2) == 'X') {
                if (out.length() < 4) {
                    return -1;
                }
                for (int i = 3; i < out.length(); ++i) {
                    char c = out.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                    return -1;
                }
            } else {
                for (int i = 2; i < out.length(); ++i) {
                    char c = out.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    return -1;
                }
            }
        } else {
            for (int i = 1; i < out.length(); ++i) {
                char c = out.charAt(i);
                if (Character.isLetterOrDigit(c)) continue;
                return -1;
            }
            out.append(';');
            return HTML.isEntity(out.toString()) ? pos : -1;
        }
        out.append(';');
        return pos;
    }

    private int recursiveEmitLine(StringBuilder out, String in, int start, MarkToken token) {
        StringBuilder temp = new StringBuilder();
        block21: for (int pos = start; pos < in.length(); ++pos) {
            MarkToken mt = this.getToken(in, pos);
            if (token != MarkToken.NONE && (mt == token || token == MarkToken.EM_STAR && mt == MarkToken.STRONG_STAR || token == MarkToken.EM_UNDERSCORE && mt == MarkToken.STRONG_UNDERSCORE)) {
                return pos;
            }
            switch (mt) {
                case IMAGE: 
                case LINK: {
                    temp.setLength(0);
                    int b = this.checkLink(temp, in, pos, mt);
                    if (b > 0) {
                        out.append((CharSequence)temp);
                        pos = b;
                        continue block21;
                    }
                    out.append(in.charAt(pos));
                    continue block21;
                }
                case EM_STAR: 
                case EM_UNDERSCORE: {
                    temp.setLength(0);
                    int b = this.recursiveEmitLine(temp, in, pos + 1, mt);
                    if (b > 0) {
                        this.config.decorator.openEmphasis(out);
                        out.append((CharSequence)temp);
                        this.config.decorator.closeEmphasis(out);
                        pos = b;
                        continue block21;
                    }
                    out.append(in.charAt(pos));
                    continue block21;
                }
                case STRONG_STAR: 
                case STRONG_UNDERSCORE: {
                    temp.setLength(0);
                    int b = this.recursiveEmitLine(temp, in, pos + 2, mt);
                    if (b > 0) {
                        this.config.decorator.openStrong(out);
                        out.append((CharSequence)temp);
                        this.config.decorator.closeStrong(out);
                        pos = b + 1;
                        continue block21;
                    }
                    out.append(in.charAt(pos));
                    continue block21;
                }
                case SUPER: {
                    temp.setLength(0);
                    int b = this.recursiveEmitLine(temp, in, pos + 1, mt);
                    if (b > 0) {
                        this.config.decorator.openSuper(out);
                        out.append((CharSequence)temp);
                        this.config.decorator.closeSuper(out);
                        pos = b;
                        continue block21;
                    }
                    out.append(in.charAt(pos));
                    continue block21;
                }
                case CODE_SINGLE: 
                case CODE_DOUBLE: {
                    int a = pos + (mt == MarkToken.CODE_DOUBLE ? 2 : 1);
                    int b = this.findToken(in, a, mt);
                    if (b > 0) {
                        pos = b + (mt == MarkToken.CODE_DOUBLE ? 1 : 0);
                        while (a < b && in.charAt(a) == ' ') {
                            ++a;
                        }
                        if (a >= b) continue block21;
                        while (in.charAt(b - 1) == ' ') {
                            --b;
                        }
                        this.config.decorator.openCodeSpan(out);
                        Utils.appendCode(out, in, a, b);
                        this.config.decorator.closeCodeSpan(out);
                        continue block21;
                    }
                    out.append(in.charAt(pos));
                    continue block21;
                }
                case HTML: {
                    temp.setLength(0);
                    int b = this.checkHtml(temp, in, pos);
                    if (b > 0) {
                        out.append((CharSequence)temp);
                        pos = b;
                        continue block21;
                    }
                    out.append("&lt;");
                    continue block21;
                }
                case ENTITY: {
                    temp.setLength(0);
                    int b = DefaultEmitter.checkEntity(temp, in, pos);
                    if (b > 0) {
                        out.append((CharSequence)temp);
                        pos = b;
                        continue block21;
                    }
                    out.append("&amp;");
                    continue block21;
                }
                case X_LINK_OPEN: {
                    temp.setLength(0);
                    int b = this.recursiveEmitLine(temp, in, pos + 2, MarkToken.X_LINK_CLOSE);
                    if (b > 0 && this.config.specialLinkEmitter != null) {
                        this.config.specialLinkEmitter.emitSpan(out, temp.toString());
                        pos = b + 1;
                        continue block21;
                    }
                    out.append(in.charAt(pos));
                    continue block21;
                }
                case X_COPY: {
                    out.append("&copy;");
                    pos += 2;
                    continue block21;
                }
                case X_REG: {
                    out.append("&reg;");
                    pos += 2;
                    continue block21;
                }
                case X_TRADE: {
                    out.append("&trade;");
                    pos += 3;
                    continue block21;
                }
                case X_NDASH: {
                    out.append("&ndash;");
                    ++pos;
                    continue block21;
                }
                case X_MDASH: {
                    out.append("&mdash;");
                    pos += 2;
                    continue block21;
                }
                case X_HELLIP: {
                    out.append("&hellip;");
                    pos += 2;
                    continue block21;
                }
                case X_LAQUO: {
                    out.append("&laquo;");
                    ++pos;
                    continue block21;
                }
                case X_RAQUO: {
                    out.append("&raquo;");
                    ++pos;
                    continue block21;
                }
                case X_RDQUO: {
                    out.append("&rdquo;");
                    continue block21;
                }
                case X_LDQUO: {
                    out.append("&ldquo;");
                    continue block21;
                }
                case ESCAPE: {
                    ++pos;
                }
                default: {
                    out.append(in.charAt(pos));
                }
            }
        }
        return -1;
    }

    private static char whitespaceToSpace(char c) {
        return Character.isWhitespace(c) ? (char)' ' : (char)c;
    }

    private MarkToken getToken(String in, int pos) {
        char c0 = pos > 0 ? (char)DefaultEmitter.whitespaceToSpace(in.charAt(pos - 1)) : (char)' ';
        char c = DefaultEmitter.whitespaceToSpace(in.charAt(pos));
        char c1 = pos + 1 < in.length() ? (char)DefaultEmitter.whitespaceToSpace(in.charAt(pos + 1)) : (char)' ';
        int c2 = pos + 2 < in.length() ? (int)DefaultEmitter.whitespaceToSpace(in.charAt(pos + 2)) : 32;
        int c3 = pos + 3 < in.length() ? (int)DefaultEmitter.whitespaceToSpace(in.charAt(pos + 3)) : 32;
        switch (c) {
            case '*': {
                if (c1 == '*') {
                    return c0 != ' ' || c2 != 32 ? MarkToken.STRONG_STAR : MarkToken.EM_STAR;
                }
                return c0 != ' ' || c1 != ' ' ? MarkToken.EM_STAR : MarkToken.NONE;
            }
            case '_': {
                if (c1 == '_') {
                    return c0 != ' ' || c2 != 32 ? MarkToken.STRONG_UNDERSCORE : MarkToken.EM_UNDERSCORE;
                }
                if (this.useExtensions) {
                    return Character.isLetterOrDigit(c0) && c0 != '_' && Character.isLetterOrDigit(c1) ? MarkToken.NONE : MarkToken.EM_UNDERSCORE;
                }
                return c0 != ' ' || c1 != ' ' ? MarkToken.EM_UNDERSCORE : MarkToken.NONE;
            }
            case '!': {
                if (c1 == '[') {
                    return MarkToken.IMAGE;
                }
                return MarkToken.NONE;
            }
            case '[': {
                if (this.useExtensions && c1 == '[') {
                    return MarkToken.X_LINK_OPEN;
                }
                return MarkToken.LINK;
            }
            case ']': {
                if (this.useExtensions && c1 == ']') {
                    return MarkToken.X_LINK_CLOSE;
                }
                return MarkToken.NONE;
            }
            case '`': {
                return c1 == '`' ? MarkToken.CODE_DOUBLE : MarkToken.CODE_SINGLE;
            }
            case '\\': {
                switch (c1) {
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '<': 
                    case '>': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '_': 
                    case '`': 
                    case '{': 
                    case '}': 
                    case '~': {
                        return MarkToken.ESCAPE;
                    }
                }
                return MarkToken.NONE;
            }
            case '<': {
                if (this.useExtensions && c1 == '<') {
                    return MarkToken.X_LAQUO;
                }
                return MarkToken.HTML;
            }
            case '&': {
                return MarkToken.ENTITY;
            }
        }
        if (this.useExtensions) {
            switch (c) {
                case '-': {
                    if (c1 != 45) break;
                    return c2 == 45 ? MarkToken.X_MDASH : MarkToken.X_NDASH;
                }
                case '^': {
                    return c0 == '^' || c1 == '^' ? MarkToken.NONE : MarkToken.SUPER;
                }
                case '>': {
                    if (c1 != 62) break;
                    return MarkToken.X_RAQUO;
                }
                case '.': {
                    if (c1 != 46 || c2 != 46) break;
                    return MarkToken.X_HELLIP;
                }
                case '(': {
                    if (c1 == 'C' && c2 == 41) {
                        return MarkToken.X_COPY;
                    }
                    if (c1 == 'R' && c2 == 41) {
                        return MarkToken.X_REG;
                    }
                    if (!(c1 == 'T' & c2 == 77 & c3 == 41)) break;
                    return MarkToken.X_TRADE;
                }
                case '\"': {
                    if (!Character.isLetterOrDigit(c0) && c1 != ' ') {
                        return MarkToken.X_LDQUO;
                    }
                    if (c0 == 32 || Character.isLetterOrDigit(c1)) break;
                    return MarkToken.X_RDQUO;
                }
            }
        }
        return MarkToken.NONE;
    }

    private void emitMarkedLines(StringBuilder out, Line lines) {
        StringBuilder in = new StringBuilder();
        Line line = lines;
        while (line != null) {
            if (!line.isEmpty) {
                in.append(line.value.substring(line.leading, line.value.length() - line.trailing));
                if (line.trailing >= 2) {
                    in.append("<br />");
                }
            }
            if (line.next != null) {
                in.append('\n');
            }
            line = line.next;
        }
        this.recursiveEmitLine(out, in.toString(), 0, MarkToken.NONE);
    }

    private void emitRawLines(StringBuilder out, Line lines) {
        Line line = lines;
        if (this.config.safeMode) {
            StringBuilder temp = new StringBuilder();
            while (line != null) {
                if (!line.isEmpty) {
                    temp.append(line.value);
                }
                temp.append('\n');
                line = line.next;
            }
            String in = temp.toString();
            for (int pos = 0; pos < in.length(); ++pos) {
                if (in.charAt(pos) == '<') {
                    temp.setLength(0);
                    int t = Utils.readXML(temp, in, pos, this.config.safeMode);
                    if (t != -1) {
                        out.append((CharSequence)temp);
                        pos = t;
                        continue;
                    }
                    out.append(in.charAt(pos));
                    continue;
                }
                out.append(in.charAt(pos));
            }
        } else {
            while (line != null) {
                if (!line.isEmpty) {
                    out.append(line.value);
                }
                out.append('\n');
                line = line.next;
            }
        }
    }

    private void emitCodeLines(StringBuilder out, Line lines, String meta, boolean removeIndent) {
        Line line = lines;
        if (this.config.codeBlockEmitter != null) {
            ArrayList<String> list = new ArrayList<String>();
            while (line != null) {
                if (line.isEmpty) {
                    list.add("");
                } else {
                    list.add(removeIndent ? line.value.substring(4) : line.value);
                }
                line = line.next;
            }
            this.config.codeBlockEmitter.emitBlock(out, list, meta);
        } else {
            while (line != null) {
                if (!line.isEmpty) {
                    int i;
                    int n = i = removeIndent ? 4 : 0;
                    while (i < line.value.length()) {
                        char c = line.value.charAt(i);
                        switch (c) {
                            case '&': {
                                out.append("&amp;");
                                break;
                            }
                            case '<': {
                                out.append("&lt;");
                                break;
                            }
                            case '>': {
                                out.append("&gt;");
                                break;
                            }
                            default: {
                                out.append(c);
                            }
                        }
                        ++i;
                    }
                }
                out.append('\n');
                line = line.next;
            }
        }
    }
}

