/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.BooleanOperations;
import de.odysseus.el.misc.NumberOperations;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import javax.el.ELContext;
import javax.el.ELException;

public class AstUnary
extends AstRightValue {
    public static final Operator EMPTY = new Operator(){

        public Object apply(TypeConverter converter, Object o) {
            return BooleanOperations.empty(converter, o);
        }

        public String toString() {
            return "empty";
        }
    };
    public static final Operator NEG = new Operator(){

        public Object apply(TypeConverter converter, Object o) {
            return NumberOperations.neg(converter, o);
        }

        public String toString() {
            return "-";
        }
    };
    public static final Operator NOT = new Operator(){

        public Object apply(TypeConverter converter, Object o) {
            return BooleanOperations.not(converter, o);
        }

        public String toString() {
            return "!";
        }
    };
    private final Operator operator;
    private final AstNode child;

    public AstUnary(AstNode child, Operator operator) {
        this.child = child;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object eval(Bindings bindings, ELContext context) throws ELException {
        return this.operator.apply(bindings, this.child.eval(bindings, context));
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(this.operator);
        b.append(' ');
        this.child.appendStructure(b, bindings);
    }

    public int getCardinality() {
        return 1;
    }

    public AstNode getChild(int i) {
        return i == 0 ? this.child : null;
    }

    public static interface Operator {
        public Object apply(TypeConverter var1, Object var2);
    }
}

