/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.rt;

import com.webcohesion.enunciate.rt.EnunciateJaxbContext;
import com.webcohesion.enunciate.rt.EnunciateJaxbNamespacePrefixMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

@Provider
public class EnunciateJaxbContextResolver
implements ContextResolver<JAXBContext> {
    private static Logger LOG = Logger.getLogger(EnunciateJaxbContextResolver.class.getName());
    private final JAXBContext context = this.buildJaxbContext();

    public JAXBContext getContext(Class<?> type) {
        return this.context;
    }

    protected JAXBContext buildJaxbContext() {
        ArrayList contextClasses = new ArrayList();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        boolean hasContextClasses = false;
        boolean hasNamespacePrefixes = false;
        try {
            Enumeration<URL> contextClassLists = classloader.getResources("/jaxb-context-classes.list");
            while (contextClassLists.hasMoreElements()) {
                hasContextClasses = true;
                URL contextClassList = contextClassLists.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(contextClassList.openStream(), "utf-8"));
                String contextClass = reader.readLine();
                while (contextClass != null) {
                    try {
                        contextClasses.add(classloader.loadClass(contextClass));
                    }
                    catch (Throwable e) {
                        LOG.warning("Unable to load JAXB context class " + contextClass + " (" + e.getMessage() + ")");
                    }
                    contextClass = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            LOG.warning("Unable to read all JAXB context classes (" + e.getMessage() + ")");
        }
        Properties namespacePrefixes = new Properties();
        String defaultNs = null;
        try {
            Enumeration<URL> namespacePropertiesList = classloader.getResources("/namespaces.properties");
            while (namespacePropertiesList.hasMoreElements()) {
                hasNamespacePrefixes = true;
                URL namespaceProperties = namespacePropertiesList.nextElement();
                Properties props = new Properties();
                props.load(namespaceProperties.openStream());
                Object defaultNamespace = props.remove("{default}");
                if (defaultNamespace != null && defaultNs == null) {
                    defaultNs = defaultNamespace.toString();
                }
                namespacePrefixes.putAll((Map<?, ?>)props);
            }
        }
        catch (IOException e) {
            LOG.warning("Unable to read all namespace properties (" + e.getMessage() + ")");
        }
        if (hasContextClasses || hasNamespacePrefixes) {
            try {
                EnunciateJaxbNamespacePrefixMapper prefixMapper = new EnunciateJaxbNamespacePrefixMapper(defaultNs, namespacePrefixes);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])contextClasses.toArray(new Class[contextClasses.size()]));
                return new EnunciateJaxbContext(jaxbContext, prefixMapper);
            }
            catch (JAXBException e) {
                LOG.warning("Unable to construct JAXB classes (" + e.getMessage() + ")");
            }
        }
        return null;
    }
}

