/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jackson1;

import com.webcohesion.enunciate.CompletionFailureException;
import com.webcohesion.enunciate.EnunciateContext;
import com.webcohesion.enunciate.EnunciateException;
import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedDeclaredType;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeMirrorUtils;
import com.webcohesion.enunciate.metadata.json.JsonSeeAlso;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnum;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import com.webcohesion.enunciate.module.EnunciateModuleContext;
import com.webcohesion.enunciate.modules.jackson1.javac.InterfaceJackson1DeclaredType;
import com.webcohesion.enunciate.modules.jackson1.javac.ParameterizedJackson1DeclaredType;
import com.webcohesion.enunciate.modules.jackson1.javac.SyntheticJackson1ArrayType;
import com.webcohesion.enunciate.modules.jackson1.model.Accessor;
import com.webcohesion.enunciate.modules.jackson1.model.AccessorVisibilityChecker;
import com.webcohesion.enunciate.modules.jackson1.model.EnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.Member;
import com.webcohesion.enunciate.modules.jackson1.model.ObjectTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.QNameEnumTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.SimpleTypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.TypeDefinition;
import com.webcohesion.enunciate.modules.jackson1.model.Value;
import com.webcohesion.enunciate.modules.jackson1.model.adapters.AdapterType;
import com.webcohesion.enunciate.modules.jackson1.model.types.JsonType;
import com.webcohesion.enunciate.modules.jackson1.model.types.KnownJsonType;
import com.webcohesion.enunciate.modules.jackson1.model.util.JacksonUtil;
import com.webcohesion.enunciate.modules.jackson1.model.util.MapType;
import com.webcohesion.enunciate.util.AnnotationUtils;
import com.webcohesion.enunciate.util.OneTimeLogMessage;
import com.webcohesion.enunciate.util.TypeHintUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BigIntegerNode;
import org.codehaus.jackson.node.BinaryNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.ContainerNode;
import org.codehaus.jackson.node.DecimalNode;
import org.codehaus.jackson.node.DoubleNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.LongNode;
import org.codehaus.jackson.node.MissingNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.NumericNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.POJONode;
import org.codehaus.jackson.node.TextNode;
import org.codehaus.jackson.node.ValueNode;

public class EnunciateJackson1Context
extends EnunciateModuleContext {
    private final Map<String, JsonType> knownTypes;
    private final Map<String, TypeDefinition> typeDefinitions;
    private final Map<String, TypeDefinition> typeDefinitionsBySlug;
    private final boolean honorJaxb;
    private final KnownJsonType dateType;
    private final boolean collapseTypeHierarchy;
    private final Map<String, String> mixins;
    private final Map<String, String> examples;
    private final AccessorVisibilityChecker defaultVisibility;
    private final boolean disableExamples;
    private final boolean wrapRootValue;
    private final String propertyNamingStrategy;
    private final boolean propertiesAlphabetical;

    public EnunciateJackson1Context(EnunciateContext context, boolean honorJaxb, KnownJsonType dateType, boolean collapseTypeHierarchy, Map<String, String> mixins, Map<String, String> examples, AccessorVisibilityChecker visibility, boolean disableExamples, boolean wrapRootValue, String propertyNamingStrategy, boolean propertiesAlphabetical) {
        super(context);
        this.dateType = dateType;
        this.mixins = mixins;
        this.examples = examples;
        this.defaultVisibility = visibility;
        this.collapseTypeHierarchy = collapseTypeHierarchy;
        this.disableExamples = disableExamples;
        this.propertyNamingStrategy = propertyNamingStrategy;
        this.propertiesAlphabetical = propertiesAlphabetical;
        this.knownTypes = this.loadKnownTypes();
        this.typeDefinitions = new HashMap<String, TypeDefinition>();
        this.typeDefinitionsBySlug = new HashMap<String, TypeDefinition>();
        this.honorJaxb = honorJaxb;
        this.wrapRootValue = wrapRootValue;
    }

    public EnunciateContext getContext() {
        return this.context;
    }

    public boolean isHonorJaxb() {
        return this.honorJaxb;
    }

    public Collection<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions.values();
    }

    public boolean isDisableExamples() {
        return this.disableExamples;
    }

    public boolean isWrapRootValue() {
        return this.wrapRootValue;
    }

    public String getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public boolean isPropertiesAlphabetical() {
        return this.propertiesAlphabetical;
    }

    public DecoratedTypeMirror resolveSyntheticType(DecoratedTypeMirror type) {
        DecoratedTypeMirror resolved;
        DecoratedTypeMirror componentType;
        if (type instanceof DeclaredType && !type.isCollection() && MapType.findMapType((TypeMirror)type, this) == null) {
            if (!((DeclaredType)type).getTypeArguments().isEmpty()) {
                type = new ParameterizedJackson1DeclaredType((DeclaredType)type, this.getContext());
            } else if (type.isInterface()) {
                type = new InterfaceJackson1DeclaredType((DeclaredType)type, this.getContext().getProcessingEnvironment());
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            DecoratedProcessingEnvironment env = this.context.getProcessingEnvironment();
            DecoratedTypeMirror extendsBound = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((DecoratedTypeMirror)wildcardType.getExtendsBound()), (DecoratedProcessingEnvironment)env);
            DecoratedTypeMirror superBound = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((DecoratedTypeMirror)wildcardType.getSuperBound()), (DecoratedProcessingEnvironment)env);
            if (extendsBound != null) {
                type = this.resolveSyntheticType(extendsBound);
            } else if (superBound != null) {
                type = this.resolveSyntheticType(superBound);
            }
        } else if (type != null && (componentType = TypeMirrorUtils.getComponentType((DecoratedTypeMirror)type, (DecoratedProcessingEnvironment)this.getContext().getProcessingEnvironment())) != null && componentType != (resolved = this.resolveSyntheticType(componentType))) {
            return new SyntheticJackson1ArrayType(this.getContext().getProcessingEnvironment().getTypeUtils().getArrayType((TypeMirror)resolved), resolved, this.getContext().getProcessingEnvironment());
        }
        return type;
    }

    public JsonType getKnownType(Element declaration) {
        if (declaration instanceof TypeElement) {
            return this.knownTypes.get(((TypeElement)declaration).getQualifiedName().toString());
        }
        return null;
    }

    public TypeDefinition findTypeDefinition(Element declaration) {
        if (declaration instanceof TypeElement) {
            return this.typeDefinitions.get(((TypeElement)declaration).getQualifiedName().toString());
        }
        return null;
    }

    protected Map<String, JsonType> loadKnownTypes() {
        HashMap<String, JsonType> knownTypes = new HashMap<String, JsonType>();
        knownTypes.put(Boolean.class.getName(), KnownJsonType.BOOLEAN);
        knownTypes.put(Byte.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Character.class.getName(), KnownJsonType.STRING);
        knownTypes.put(Double.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Float.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Integer.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Long.class.getName(), KnownJsonType.LONG_NUMBER);
        knownTypes.put(Short.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Boolean.TYPE.getName(), KnownJsonType.BOOLEAN);
        knownTypes.put(Byte.TYPE.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Double.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Float.TYPE.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Integer.TYPE.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Long.TYPE.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Short.TYPE.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(Character.TYPE.getName(), KnownJsonType.STRING);
        knownTypes.put(QName.class.getName(), KnownJsonType.STRING);
        knownTypes.put(String.class.getName(), KnownJsonType.STRING);
        knownTypes.put(Enum.class.getName(), KnownJsonType.STRING);
        knownTypes.put(BigInteger.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(BigDecimal.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(Calendar.class.getName(), this.dateType);
        knownTypes.put(Date.class.getName(), this.dateType);
        knownTypes.put(Timestamp.class.getName(), this.dateType);
        knownTypes.put(URI.class.getName(), KnownJsonType.STRING);
        knownTypes.put(URL.class.getName(), KnownJsonType.STRING);
        knownTypes.put(Object.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(byte[].class.getName(), KnownJsonType.STRING);
        knownTypes.put(ByteBuffer.class.getName(), KnownJsonType.STRING);
        knownTypes.put(DataHandler.class.getName(), KnownJsonType.STRING);
        knownTypes.put(UUID.class.getName(), KnownJsonType.STRING);
        knownTypes.put(XMLGregorianCalendar.class.getName(), this.dateType);
        knownTypes.put(GregorianCalendar.class.getName(), this.dateType);
        knownTypes.put(JsonNode.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(ContainerNode.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(ArrayNode.class.getName(), KnownJsonType.ARRAY);
        knownTypes.put(ObjectNode.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(ValueNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(TextNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(BinaryNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(MissingNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(NullNode.class.getName(), KnownJsonType.STRING);
        knownTypes.put(NumericNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(IntNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(DoubleNode.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(DecimalNode.class.getName(), KnownJsonType.NUMBER);
        knownTypes.put(LongNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(BigIntegerNode.class.getName(), KnownJsonType.WHOLE_NUMBER);
        knownTypes.put(POJONode.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put(BooleanNode.class.getName(), KnownJsonType.BOOLEAN);
        knownTypes.put(Class.class.getName(), KnownJsonType.OBJECT);
        knownTypes.put("java.time.Period", KnownJsonType.STRING);
        knownTypes.put("java.time.Duration", this.dateType);
        knownTypes.put("java.time.Instant", this.dateType);
        knownTypes.put("java.time.Year", this.dateType);
        knownTypes.put("java.time.YearMonth", KnownJsonType.STRING);
        knownTypes.put("java.time.MonthDay", KnownJsonType.STRING);
        knownTypes.put("java.time.ZoneId", KnownJsonType.STRING);
        knownTypes.put("java.time.ZoneOffset", KnownJsonType.STRING);
        knownTypes.put("java.time.LocalDate", KnownJsonType.STRING);
        knownTypes.put("java.time.LocalTime", KnownJsonType.STRING);
        knownTypes.put("java.time.LocalDateTime", KnownJsonType.STRING);
        knownTypes.put("java.time.OffsetTime", KnownJsonType.STRING);
        knownTypes.put("java.time.ZonedDateTime", this.dateType);
        knownTypes.put("java.time.OffsetDateTime", this.dateType);
        knownTypes.put("org.joda.time.DateTime", this.dateType);
        knownTypes.put("java.util.Currency", KnownJsonType.STRING);
        for (String m : this.mixins.keySet()) {
            if (knownTypes.remove(m) == null) continue;
            this.debug("Unregistering %s from known types, as it is redefined using a mixin.", new Object[]{m});
        }
        return knownTypes;
    }

    protected TypeDefinition createTypeDefinition(TypeElement declaration) {
        if (this.isEnumType(declaration = this.narrowToAdaptingType(declaration))) {
            if (declaration.getAnnotation(XmlQNameEnum.class) != null) {
                return new QNameEnumTypeDefinition(declaration, this);
            }
            return new EnumTypeDefinition(declaration, this);
        }
        ObjectTypeDefinition typeDef = new ObjectTypeDefinition(declaration, this);
        if (typeDef.getValue() != null) {
            return new SimpleTypeDefinition(typeDef);
        }
        return typeDef;
    }

    protected TypeElement narrowToAdaptingType(TypeElement declaration) {
        AdapterType adapterType = JacksonUtil.findAdapterType(declaration, this);
        if (adapterType != null) {
            TypeMirror adaptingType = adapterType.getAdaptingType();
            if (adaptingType.getKind() != TypeKind.DECLARED) {
                return declaration;
            }
            TypeElement adaptingDeclaration = (TypeElement)((DeclaredType)adaptingType).asElement();
            if (adaptingDeclaration == null) {
                throw new EnunciateException(String.format("Class %s is being adapted by a type (%s) that doesn't seem to be on the classpath.", declaration.getQualifiedName(), adaptingType));
            }
            return adaptingDeclaration;
        }
        return declaration;
    }

    protected boolean isEnumType(TypeElement declaration) {
        return declaration.getKind() == ElementKind.ENUM;
    }

    public boolean isKnownTypeDefinition(TypeElement el) {
        return this.findTypeDefinition(el) != null || this.isKnownType(el);
    }

    public boolean isIgnored(Element el) {
        if (AnnotationUtils.isIgnored((Element)el)) {
            return true;
        }
        if (el instanceof PropertyElement && el.getAnnotation(JsonProperty.class) != null) {
            return false;
        }
        return el.getAnnotation(JsonIgnore.class) != null && el.getAnnotation(JsonIgnore.class).value();
    }

    public AccessorVisibilityChecker getDefaultVisibility() {
        return this.defaultVisibility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TypeDefinition typeDef, LinkedList<Element> stack) {
        if (this.findTypeDefinition((Element)((Object)typeDef)) == null && !this.isKnownType((TypeElement)((Object)typeDef))) {
            this.typeDefinitions.put(typeDef.getQualifiedName().toString(), typeDef);
            if (this.context.isExcluded((Element)((Object)typeDef))) {
                this.warn("Added %s as a Jackson type definition even though is was supposed to be excluded according to configuration. It was referenced from %s%s, so it had to be included to prevent broken references.", new Object[]{typeDef.getQualifiedName(), stack.size() > 0 ? stack.get(0) : "an unknown location", stack.size() > 1 ? " of " + stack.get(1) : ""});
            } else {
                this.debug("Added %s as a Jackson type definition.", new Object[]{typeDef.getQualifiedName()});
            }
            if (this.getContext().getProcessingEnvironment().findSourcePosition((Element)((Object)typeDef)) == null) {
                OneTimeLogMessage.SOURCE_FILES_NOT_FOUND.log(this.getContext());
                this.debug("Unable to find source file for %s.", new Object[]{typeDef.getQualifiedName()});
            }
            typeDef.getReferencedFrom().addAll(stack);
            try {
                stack.push((Element)((Object)typeDef));
                this.addSeeAlsoTypeDefinitions((Element)((Object)typeDef), stack);
                for (Member member : typeDef.getMembers()) {
                    TypeHint hintInfo = (TypeHint)member.getAnnotation(TypeHint.class);
                    if (hintInfo != null) {
                        TypeMirror hint = TypeHintUtils.getTypeHint((TypeHint)hintInfo, (DecoratedProcessingEnvironment)this.context.getProcessingEnvironment(), null);
                        if (hint == null) continue;
                        this.addReferencedTypeDefinitions(hint, stack);
                        continue;
                    }
                    this.addReferencedTypeDefinitions(member, stack);
                }
                Value value = typeDef.getValue();
                if (value != null) {
                    this.addReferencedTypeDefinitions(value, stack);
                }
                TypeMirror superclass = typeDef.getSuperclass();
                if (!typeDef.isBaseObject() && superclass != null && superclass.getKind() != TypeKind.NONE && !this.isCollapseTypeHierarchy()) {
                    this.addReferencedTypeDefinitions(superclass, stack);
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedTypeDefinitions(Accessor accessor, LinkedList<Element> stack) {
        stack.push((Element)((Object)accessor));
        try {
            this.addSeeAlsoTypeDefinitions((Element)((Object)accessor), stack);
            DecoratedTypeMirror enumRef = accessor.getQNameEnumRef();
            if (enumRef != null) {
                this.addReferencedTypeDefinitions((TypeMirror)enumRef, stack);
            }
        }
        finally {
            stack.pop();
        }
    }

    protected void addReferencedTypeDefinitions(Value value, LinkedList<Element> stack) {
        this.addReferencedTypeDefinitions((Accessor)value, stack);
        stack.push((Element)((Object)value));
        try {
            if (value.isAdapted()) {
                this.addReferencedTypeDefinitions((TypeMirror)((Object)value.getAdapterType()), stack);
            } else if (value.getQNameEnumRef() == null) {
                this.addReferencedTypeDefinitions((TypeMirror)value.getAccessorType(), stack);
            }
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReferencedTypeDefinitions(Member member, LinkedList<Element> stack) {
        this.addReferencedTypeDefinitions((Accessor)member, stack);
        stack.push((Element)((Object)member));
        try {
            for (Member member2 : member.getChoices()) {
                if (member2.isAdapted()) {
                    this.addReferencedTypeDefinitions((TypeMirror)((Object)member2.getAdapterType()), stack);
                    continue;
                }
                if (member2.getQNameEnumRef() != null) continue;
                this.addReferencedTypeDefinitions((TypeMirror)member2.getAccessorType(), stack);
            }
        }
        finally {
            stack.pop();
        }
    }

    protected void addReferencedTypeDefinitions(TypeMirror type, LinkedList<Element> stack) {
        type.accept(new ReferencedJsonDefinitionVisitor(), new ReferenceContext(stack));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void addSeeAlsoTypeDefinitions(Element declaration, LinkedList<Element> stack) {
        JsonSeeAlso seeAlso;
        Class clazz;
        JsonSubTypes subTypes = declaration.getAnnotation(JsonSubTypes.class);
        if (subTypes != null) {
            JsonSubTypes.Type[] types;
            Elements elementUtils = this.getContext().getProcessingEnvironment().getElementUtils();
            Types typeUtils = this.getContext().getProcessingEnvironment().getTypeUtils();
            for (JsonSubTypes.Type type : types = subTypes.value()) {
                try {
                    stack.push(elementUtils.getTypeElement(JsonSubTypes.class.getName()));
                    clazz = type.value();
                    this.add(this.createTypeDefinition(elementUtils.getTypeElement(clazz.getName())), stack);
                }
                catch (MirroredTypeException e) {
                    TypeMirror mirror = e.getTypeMirror();
                    Element element = typeUtils.asElement(mirror);
                    if (!(element instanceof TypeElement)) continue;
                    this.add(this.createTypeDefinition((TypeElement)element), stack);
                }
                catch (MirroredTypesException e) {
                    List<? extends TypeMirror> mirrors = e.getTypeMirrors();
                    for (TypeMirror typeMirror : mirrors) {
                        Element element = typeUtils.asElement(typeMirror);
                        if (!(element instanceof TypeElement)) continue;
                        this.add(this.createTypeDefinition((TypeElement)element), stack);
                    }
                }
                finally {
                    stack.pop();
                }
            }
        }
        if ((seeAlso = declaration.getAnnotation(JsonSeeAlso.class)) != null) {
            Elements elementUtils = this.getContext().getProcessingEnvironment().getElementUtils();
            Types typeUtils = this.getContext().getProcessingEnvironment().getTypeUtils();
            stack.push(elementUtils.getTypeElement(JsonSeeAlso.class.getName()));
            try {
                void var10_19;
                Class[] classes;
                Class[] classArray = classes = seeAlso.value();
                int n = classArray.length;
                boolean bl = false;
                while (var10_19 < n) {
                    clazz = classArray[var10_19];
                    this.add(this.createTypeDefinition(elementUtils.getTypeElement(clazz.getName())), stack);
                    ++var10_19;
                }
            }
            catch (MirroredTypeException e) {
                TypeMirror mirror = e.getTypeMirror();
                Element element = typeUtils.asElement(mirror);
                if (element instanceof TypeElement) {
                    this.add(this.createTypeDefinition((TypeElement)element), stack);
                }
            }
            catch (MirroredTypesException e) {
                List<? extends TypeMirror> mirrors = e.getTypeMirrors();
                for (TypeMirror typeMirror : mirrors) {
                    Element element = typeUtils.asElement(typeMirror);
                    if (!(element instanceof TypeElement)) continue;
                    this.add(this.createTypeDefinition((TypeElement)element), stack);
                }
            }
            finally {
                stack.pop();
            }
        }
        if (subTypes == null && seeAlso == null && declaration instanceof TypeElement) {
            for (Element el : this.getContext().getApiElements()) {
                if (!(el instanceof TypeElement) || ((TypeElement)el).getQualifiedName().contentEquals(((TypeElement)declaration).getQualifiedName()) || !((DecoratedTypeMirror)el.asType()).isInstanceOf(declaration)) continue;
                this.add(this.createTypeDefinition((TypeElement)el), stack);
            }
        }
    }

    protected boolean isKnownType(TypeElement typeDef) {
        return this.knownTypes.containsKey(typeDef.getQualifiedName().toString()) || ((DecoratedTypeMirror)typeDef.asType()).isInstanceOf(JAXBElement.class);
    }

    public String getSlug(TypeDefinition typeDefinition) {
        String[] qualifiedNameTokens = typeDefinition.getQualifiedName().toString().split("\\.");
        String slug = "";
        for (int i = qualifiedNameTokens.length - 1; i >= 0; --i) {
            TypeDefinition entry = this.typeDefinitionsBySlug.get(slug = slug.isEmpty() ? qualifiedNameTokens[i] : slug + "_" + qualifiedNameTokens[i]);
            if (entry == null) {
                entry = typeDefinition;
                this.typeDefinitionsBySlug.put(slug, entry);
            }
            if (!entry.getQualifiedName().toString().equals(typeDefinition.getQualifiedName().toString())) continue;
            return slug;
        }
        return slug;
    }

    public TypeElement lookupMixin(TypeElement element) {
        String mixin = this.mixins.get(element.getQualifiedName().toString());
        if (mixin != null) {
            return this.getContext().getProcessingEnvironment().getElementUtils().getTypeElement(mixin);
        }
        return null;
    }

    public String lookupExternalExample(TypeElement element) {
        return this.examples.get(element.getQualifiedName().toString());
    }

    public boolean isCollapseTypeHierarchy() {
        return this.collapseTypeHierarchy;
    }

    private static class ReferenceContext {
        LinkedList<Element> referenceStack;
        LinkedList<Element> recursionStack;

        public ReferenceContext(LinkedList<Element> referenceStack) {
            this.referenceStack = referenceStack;
            this.recursionStack = new LinkedList();
        }
    }

    private class ReferencedJsonDefinitionVisitor
    extends SimpleTypeVisitor6<Void, ReferenceContext> {
        private ReferencedJsonDefinitionVisitor() {
        }

        @Override
        public Void visitArray(ArrayType t, ReferenceContext context) {
            return t.getComponentType().accept(this, context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void visitDeclared(DeclaredType declaredType, ReferenceContext context) {
            TypeElement declaration = (TypeElement)declaredType.asElement();
            if (declaration.getKind() == ElementKind.ENUM) {
                if (EnunciateJackson1Context.this.isKnownTypeDefinition(declaration)) return null;
                EnunciateJackson1Context.this.add(EnunciateJackson1Context.this.createTypeDefinition(declaration), context.referenceStack);
                return null;
            } else if (declaredType instanceof AdapterType) {
                ((AdapterType)((Object)declaredType)).getAdaptingType().accept(this, context);
                return null;
            } else if (MapType.findMapType(declaredType, EnunciateJackson1Context.this) == null) {
                String qualifiedName = declaration.getQualifiedName().toString();
                if (Object.class.getName().equals(qualifiedName)) {
                    return null;
                }
                if (context.recursionStack.contains(declaration)) {
                    return null;
                }
                context.recursionStack.push(declaration);
                try {
                    List<? extends TypeMirror> typeArgs;
                    if (!(EnunciateJackson1Context.this.isKnownTypeDefinition(declaration) || EnunciateJackson1Context.this.isIgnored(declaration) || declaration.getKind() != ElementKind.CLASS || ((DecoratedDeclaredType)declaredType).isCollection() || ((DecoratedDeclaredType)declaredType).isInstanceOf(JAXBElement.class))) {
                        EnunciateJackson1Context.this.add(EnunciateJackson1Context.this.createTypeDefinition(declaration), context.referenceStack);
                    }
                    if ((typeArgs = declaredType.getTypeArguments()) == null) return null;
                    for (TypeMirror typeMirror : typeArgs) {
                        typeMirror.accept(this, context);
                    }
                    return null;
                }
                catch (RuntimeException e) {
                    if (!e.getClass().getName().endsWith("CompletionFailure")) throw e;
                    LinkedList<Element> linkedList = new LinkedList<Element>(context.referenceStack);
                    linkedList.push(declaration);
                    throw new CompletionFailureException(linkedList, (Throwable)e);
                }
                finally {
                    context.recursionStack.pop();
                }
            } else {
                List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
                if (typeArgs == null) return null;
                for (TypeMirror typeMirror : typeArgs) {
                    typeMirror.accept(this, context);
                }
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(TypeVariable t, ReferenceContext context) {
            return t.getUpperBound().accept(this, context);
        }

        @Override
        public Void visitWildcard(WildcardType t, ReferenceContext context) {
            TypeMirror superBound;
            TypeMirror extendsBound = t.getExtendsBound();
            if (extendsBound != null) {
                extendsBound.accept(this, context);
            }
            if ((superBound = t.getSuperBound()) != null) {
                superBound.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitUnknown(TypeMirror t, ReferenceContext context) {
            return (Void)this.defaultAction(t, context);
        }
    }
}

