/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.menu.MenuRegistry;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.Menu;
import com.vaadin.flow.router.MenuData;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.RouteAliasData;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedEvent;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.ConfigureRoutes;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.DefaultErrorHandler;
import com.vaadin.flow.router.internal.ErrorTargetEntry;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteFormat;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.AccessCheckDecision;
import com.vaadin.flow.server.auth.MenuAccessControl;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.NavigationContext;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractRouteRegistry
implements RouteRegistry {
    private static final String TARGET_MUST_NOT_BE_NULL = "Target must not be null.";
    private final ReentrantLock configurationLock = new ReentrantLock(true);
    private volatile ConfiguredRoutes configuredRoutes = new ConfiguredRoutes();
    private volatile ConfigureRoutes editing = null;
    private CopyOnWriteArrayList<RoutesChangedListener> routesChangedListeners = new CopyOnWriteArrayList();
    private final Map<String, Class<? extends RouterLayout>> layouts = new HashMap<String, Class<? extends RouterLayout>>();

    protected void configure(Configuration command) {
        this.lock();
        try {
            if (this.editing == null) {
                this.editing = new ConfigureRoutes(this.configuredRoutes);
            }
            command.configure(this.editing);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void update(Command command) {
        this.lock();
        try {
            command.execute();
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
        this.configurationLock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unlock() {
        if (this.configurationLock.getHoldCount() == 1 && this.editing != null) {
            try {
                ConfiguredRoutes oldConfiguration = this.configuredRoutes;
                this.configuredRoutes = new ConfiguredRoutes(this.editing);
                if (this.routesChangedListeners.isEmpty()) return;
                List<RouteBaseData<?>> oldRoutes = this.flattenRoutes(this.getRegisteredRoutes(oldConfiguration));
                List<RouteBaseData<?>> newRoutes = this.flattenRoutes(this.getRegisteredRoutes(this.configuredRoutes));
                ArrayList added = new ArrayList();
                ArrayList removed = new ArrayList();
                oldRoutes.stream().filter(route -> !newRoutes.contains(route)).forEach(removed::add);
                newRoutes.stream().filter(route -> !oldRoutes.contains(route)).forEach(added::add);
                this.fireEvent(new RoutesChangedEvent(this, added, removed));
                return;
            }
            finally {
                this.editing = null;
                this.configurationLock.unlock();
            }
        } else {
            this.configurationLock.unlock();
        }
    }

    protected void fireEvent(RoutesChangedEvent routeChangedEvent) {
        this.routesChangedListeners.forEach(listener -> listener.routesChanged(routeChangedEvent));
    }

    @Override
    public Registration addRoutesChangeListener(RoutesChangedListener listener) {
        return Registration.addAndRemove(this.routesChangedListeners, listener);
    }

    protected boolean hasLock() {
        return this.configurationLock.isHeldByCurrentThread();
    }

    public ConfiguredRoutes getConfiguration() {
        if (this.configurationLock.isHeldByCurrentThread() && this.editing != null) {
            return this.editing;
        }
        return this.configuredRoutes;
    }

    @Override
    public List<RouteData> getRegisteredRoutes() {
        return this.getRegisteredRoutes(this.getConfiguration());
    }

    @Override
    public List<RouteData> getRegisteredAccessibleMenuRoutes(VaadinRequest vaadinRequest, Collection<BeforeEnterListener> accessControls) {
        if (vaadinRequest == null) {
            return Collections.emptyList();
        }
        VaadinService vaadinService = vaadinRequest.getService();
        if (vaadinService == null) {
            return Collections.emptyList();
        }
        MenuAccessControl.PopulateClientMenu populateClientSideMenu = vaadinService.getInstantiator().getMenuAccessControl().getPopulateClientSideMenu();
        if (populateClientSideMenu == MenuAccessControl.PopulateClientMenu.NEVER) {
            return Collections.emptyList();
        }
        List<NavigationAccessControl> navigationAccessControls = this.findListOf(NavigationAccessControl.class, accessControls);
        List<ViewAccessChecker> legacyViewAccessCheckers = this.findListOf(ViewAccessChecker.class, accessControls);
        if (navigationAccessControls.isEmpty() && legacyViewAccessCheckers.isEmpty()) {
            return this.getMenuRouteCandidates().toList();
        }
        return this.getMenuRouteCandidates().filter(route -> navigationAccessControls.stream().allMatch(accessControl -> {
            NavigationContext navigationContext = accessControl.createNavigationContext(route.getNavigationTarget(), route.getTemplate(), vaadinService, vaadinRequest);
            return accessControl.checkAccess(navigationContext, true).decision() == AccessCheckDecision.ALLOW;
        })).filter(route -> legacyViewAccessCheckers.stream().allMatch(legacyAccessChecker -> {
            NavigationContext navigationContext = legacyAccessChecker.createNavigationContext(route.getNavigationTarget(), route.getTemplate(), vaadinService, vaadinRequest);
            return legacyAccessChecker.checkAccess(navigationContext).decision() == AccessCheckDecision.ALLOW;
        })).toList();
    }

    private Stream<RouteData> getMenuRouteCandidates() {
        return this.getRegisteredRoutes().stream().filter(route -> route.getMenuData() != null);
    }

    private <T> List<T> findListOf(Class<T> targetType, Collection<?> objects) {
        return Stream.ofNullable(objects).flatMap(Collection::stream).filter(event -> targetType.isAssignableFrom(event.getClass())).map(targetType::cast).toList();
    }

    private List<RouteData> getRegisteredRoutes(ConfiguredRoutes configuration) {
        HashMap<String, RouteTarget> routePathMap = new HashMap<String, RouteTarget>(configuration.getRoutesMap());
        ArrayList registeredRoutes = new ArrayList();
        configuration.getTargetRoutes().forEach((target, template) -> this.populateRegisteredRoutes(configuration, registeredRoutes, (Map<String, RouteTarget>)routePathMap, (Class<? extends Component>)target, (String)template));
        Collections.sort(registeredRoutes);
        return Collections.unmodifiableList(registeredRoutes);
    }

    private void populateRegisteredRoutes(ConfiguredRoutes configuration, List<RouteData> registeredRoutes, Map<String, RouteTarget> routePathMap, Class<? extends Component> target, String template) {
        ArrayList<RouteAliasData> routeAliases = new ArrayList<RouteAliasData>();
        routePathMap.entrySet().stream().filter(entry -> ((RouteTarget)entry.getValue()).containsTarget(target)).map(Map.Entry::getKey).collect(Collectors.toList()).stream().peek(routePathMap::remove).filter(routePathTemplate -> !routePathTemplate.equals(template)).forEach(aliasRoutePathTemplate -> routeAliases.add(new RouteAliasData(this.getParentLayouts(configuration, (String)aliasRoutePathTemplate), (String)aliasRoutePathTemplate, configuration.getParameters((String)aliasRoutePathTemplate), target)));
        List<Class<? extends RouterLayout>> parentLayouts = this.getParentLayouts(configuration, template);
        Map<String, RouteParameterData> parameters = configuration.getParameters(template);
        boolean excludeFromMenu = parameters != null && !parameters.isEmpty() && parameters.values().stream().anyMatch(param -> !param.isOptional() && !param.isVarargs());
        MenuData menuData = AnnotationReader.getAnnotationFor(target, Menu.class).map(menu -> new MenuData(menu.title() == null || menu.title().isBlank() ? MenuRegistry.getTitle(target) : menu.title(), Objects.equals(menu.order(), Double.MIN_VALUE) ? null : Double.valueOf(menu.order()), excludeFromMenu, menu.icon().isBlank() ? null : menu.icon(), target)).orElse(null);
        RouteData route = new RouteData(parentLayouts, template, parameters, target, routeAliases, menuData);
        registeredRoutes.add(route);
    }

    private List<RouteBaseData<?>> flattenRoutes(List<RouteData> routeData) {
        ArrayList flatRoutes = new ArrayList();
        for (RouteData route : routeData) {
            RouteData nonAliasCollection = new RouteData(route.getParentLayouts(), route.getTemplate(), route.getRouteParameters(), route.getNavigationTarget(), Collections.emptyList(), route.getMenuData());
            flatRoutes.add(nonAliasCollection);
            route.getRouteAliases().forEach(flatRoutes::add);
        }
        return flatRoutes;
    }

    private List<Class<? extends RouterLayout>> getParentLayouts(ConfiguredRoutes configuration, String template) {
        RouteTarget routeTarget = configuration.getRouteTarget(template);
        if (routeTarget != null) {
            return routeTarget.getParentLayouts();
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget) {
        Objects.requireNonNull(navigationTarget, TARGET_MUST_NOT_BE_NULL);
        HasUrlParameterFormat.checkMandatoryParameter(navigationTarget, null);
        return Optional.ofNullable(this.getConfiguration().getTargetUrl(navigationTarget));
    }

    @Override
    public Optional<String> getTargetUrl(Class<? extends Component> navigationTarget, RouteParameters parameters) {
        Objects.requireNonNull(navigationTarget, TARGET_MUST_NOT_BE_NULL);
        HasUrlParameterFormat.checkMandatoryParameter(navigationTarget, parameters);
        return Optional.ofNullable(this.getConfiguration().getTargetUrl(navigationTarget, parameters));
    }

    @Override
    public Optional<String> getTemplate(Class<? extends Component> navigationTarget) {
        Objects.requireNonNull(navigationTarget, TARGET_MUST_NOT_BE_NULL);
        return Optional.ofNullable(this.getConfiguration().getTemplate(navigationTarget));
    }

    @Override
    public void setRoute(String path, Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        RouteUtil.checkForClientRouteCollisions(VaadinService.getCurrent(), HasUrlParameterFormat.getTemplate(path, navigationTarget));
        this.configureWithFullTemplate(path, navigationTarget, (configuration, fullTemplate) -> configuration.setRoute((String)fullTemplate, navigationTarget, parentChain));
    }

    @Override
    public void removeRoute(Class<? extends Component> navigationTarget) {
        if (!this.getConfiguration().hasRouteTarget(navigationTarget)) {
            return;
        }
        this.configure(configuration -> configuration.removeRoute(navigationTarget));
    }

    @Override
    public void removeRoute(String path) {
        if (!this.getConfiguration().hasTemplate(path)) {
            return;
        }
        this.configure(configuration -> configuration.removeRoute(path));
    }

    @Override
    public void removeRoute(String path, Class<? extends Component> navigationTarget) {
        if (!this.getConfiguration().hasTemplate(path)) {
            return;
        }
        this.configureWithFullTemplate(path, navigationTarget, (configuration, fullTemplate) -> configuration.removeRoute((String)fullTemplate, navigationTarget));
    }

    @Override
    public void clean() {
        this.configure(ConfigureRoutes::clear);
    }

    @Override
    public boolean hasMandatoryParameter(Class<? extends Component> navigationTarget) {
        String template = this.getTemplate(navigationTarget).orElseThrow(() -> new NotFoundException("Requested navigation target is not registered."));
        return HasUrlParameterFormat.hasUrlParameter(navigationTarget) && HasUrlParameterFormat.hasMandatoryParameter(navigationTarget) || RouteFormat.hasRequiredParameter(template);
    }

    private void configureWithFullTemplate(String path, Class<? extends Component> navigationTarget, SerializableBiConsumer<ConfigureRoutes, String> templateConfiguration) {
        this.configure(configuration -> templateConfiguration.accept(configuration, HasUrlParameterFormat.getTemplate(path, navigationTarget)));
    }

    @Override
    public NavigationRouteTarget getNavigationRouteTarget(String url) {
        return this.getConfiguration().getNavigationRouteTarget(url);
    }

    @Override
    public RouteTarget getRouteTarget(Class<? extends Component> target, RouteParameters parameters) {
        return this.getConfiguration().getRouteTarget(target, parameters);
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String url) {
        Objects.requireNonNull(url, "url must not be null.");
        return this.getConfiguration().getTarget(url);
    }

    @Override
    public Optional<Class<? extends Component>> getNavigationTarget(String url, List<String> segments) {
        return this.getNavigationTarget(PathUtil.getPath(url, segments));
    }

    protected void addErrorTarget(Class<? extends Component> target, Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap) {
        Class<Exception> exceptionType = ReflectTools.getGenericInterfaceType(target, HasErrorParameter.class).asSubclass(Exception.class);
        if (exceptionTargetsMap.containsKey(exceptionType)) {
            this.handleRegisteredExceptionType(exceptionTargetsMap, target, exceptionType);
        } else {
            exceptionTargetsMap.put(exceptionType, target);
        }
    }

    private void handleRegisteredExceptionType(Map<Class<? extends Exception>, Class<? extends Component>> exceptionTargetsMap, Class<? extends Component> target, Class<? extends Exception> exceptionType) {
        Class<? extends Component> registered = exceptionTargetsMap.get(exceptionType);
        if (registered.isAssignableFrom(target)) {
            exceptionTargetsMap.put(exceptionType, target);
        } else if (!target.isAssignableFrom(registered)) {
            if (registered.isAnnotationPresent(DefaultErrorHandler.class)) {
                exceptionTargetsMap.put(exceptionType, target);
            } else if (!target.isAnnotationPresent(DefaultErrorHandler.class)) {
                String msg = String.format("Only one target for an exception should be defined. Found '%s' and '%s' for exception '%s'", target.getName(), registered.getName(), exceptionType.getName());
                throw new InvalidRouteConfigurationException(msg);
            }
        }
    }

    protected Optional<ErrorTargetEntry> searchByCause(Exception exception) {
        Class<? extends Component> targetClass = this.getConfiguration().getExceptionHandlerByClass(exception.getClass());
        if (targetClass != null) {
            return Optional.of(new ErrorTargetEntry(targetClass, exception.getClass()));
        }
        Throwable cause = exception.getCause();
        if (cause instanceof Exception) {
            return this.searchByCause((Exception)cause);
        }
        return Optional.empty();
    }

    protected Optional<ErrorTargetEntry> searchBySuperType(Throwable exception) {
        for (Class<?> superClass = exception.getClass().getSuperclass(); superClass != null && Exception.class.isAssignableFrom(superClass); superClass = superClass.getSuperclass()) {
            Class<? extends Component> targetClass = this.getConfiguration().getExceptionHandlerByClass(superClass);
            if (targetClass == null) continue;
            return Optional.of(new ErrorTargetEntry(targetClass, superClass.asSubclass(Exception.class)));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLayout(Class<? extends RouterLayout> layout) {
        if (layout == null || !layout.isAnnotationPresent(Layout.class)) {
            return;
        }
        Map<String, Class<? extends RouterLayout>> map = this.layouts;
        synchronized (map) {
            this.layouts.put(layout.getAnnotation(Layout.class).value(), layout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLayout(Class<? extends RouterLayout> layout) {
        if (layout == null) {
            return;
        }
        Map<String, Class<? extends RouterLayout>> map = this.layouts;
        synchronized (map) {
            this.layouts.entrySet().removeIf(entry -> layout.equals(entry.getValue()));
            if (layout.isAnnotationPresent(Layout.class)) {
                this.layouts.put(layout.getAnnotation(Layout.class).value(), layout);
            }
        }
    }

    Collection<Class<?>> getLayouts() {
        return Set.copyOf(this.layouts.values());
    }

    @Override
    public Class<? extends RouterLayout> getLayout(String path) {
        Optional<String> first = this.layouts.keySet().stream().sorted(this.pathSortComparator()).filter(key -> this.pathMatches(path, (String)key)).findFirst();
        return first.map(this.layouts::get).orElse(null);
    }

    @Override
    public boolean hasLayout(String path) {
        return this.layouts.keySet().stream().anyMatch(key -> this.pathMatches(path, (String)key));
    }

    private Comparator<String> pathSortComparator() {
        return (o1, o2) -> this.removeStartSlash((String)o2).split("/").length - this.removeStartSlash((String)o1).split("/").length;
    }

    private boolean pathMatches(String path, String layoutPath) {
        String[] pathSplit = this.removeStartSlash(path).split("/");
        String[] layoutSplit = this.removeStartSlash(layoutPath).split("/");
        if (layoutSplit.length == 1 && layoutSplit[0].isEmpty()) {
            return true;
        }
        if (layoutSplit.length > pathSplit.length) {
            return false;
        }
        for (int i = 0; i < layoutSplit.length; ++i) {
            if (pathSplit[i].equals(layoutSplit[i])) continue;
            return false;
        }
        return true;
    }

    private String removeStartSlash(String path) {
        return path.startsWith("/") ? path.substring(1, path.length()) : path;
    }

    @FunctionalInterface
    public static interface Configuration
    extends Serializable {
        public void configure(ConfigureRoutes var1);
    }
}

