/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class BeanUtil
implements Serializable {
    private BeanUtil() {
    }

    public static List<PropertyDescriptor> getBeanPropertyDescriptors(Class<?> beanType) throws IntrospectionException {
        if (beanType.isRecord()) {
            ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
            for (RecordComponent component : beanType.getRecordComponents()) {
                propertyDescriptors.add(new PropertyDescriptor(component.getName(), component.getAccessor(), null));
            }
            return propertyDescriptors;
        }
        if (beanType.isInterface()) {
            ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
            for (Class<?> cls : beanType.getInterfaces()) {
                propertyDescriptors.addAll(BeanUtil.getBeanPropertyDescriptors(cls));
            }
            BeanInfo info = Introspector.getBeanInfo(beanType);
            propertyDescriptors.addAll(BeanUtil.getPropertyDescriptors(info));
            return propertyDescriptors;
        }
        BeanInfo info = Introspector.getBeanInfo(beanType);
        return BeanUtil.getPropertyDescriptors(info);
    }

    public static Class<?> getPropertyType(Class<?> beanType, String propertyName) throws IntrospectionException {
        PropertyDescriptor descriptor = BeanUtil.getPropertyDescriptor(beanType, propertyName);
        if (descriptor != null) {
            return descriptor.getPropertyType();
        }
        return null;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> beanType, String propertyName) throws IntrospectionException {
        if (propertyName.contains(".")) {
            String[] parts = propertyName.split("\\.", 2);
            Class<?> propertyBean = BeanUtil.getPropertyType(beanType, parts[0]);
            return BeanUtil.getPropertyDescriptor(propertyBean, parts[1]);
        }
        List<PropertyDescriptor> descriptors = BeanUtil.getBeanPropertyDescriptors(beanType);
        for (PropertyDescriptor descriptor : descriptors) {
            Method getMethod = descriptor.getReadMethod();
            if (!descriptor.getName().equals(propertyName) || getMethod == null || getMethod.getDeclaringClass() == Object.class) continue;
            return descriptor;
        }
        return null;
    }

    public static boolean checkBeanValidationAvailable() {
        return LazyValidationAvailability.BEAN_VALIDATION_AVAILABLE;
    }

    private static List<PropertyDescriptor> getPropertyDescriptors(BeanInfo beanInfo) {
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            try {
                result.add(BeanUtil.fixPropertyDescriptor(descriptor));
            }
            catch (SecurityException exception) {
                LoggerFactory.getLogger((String)BeanUtil.class.getName()).info(null, (Throwable)exception);
            }
            catch (IntrospectionException e) {
                LoggerFactory.getLogger((String)BeanUtil.class.getName()).info(null, (Throwable)e);
                result.add(descriptor);
            }
        }
        return result;
    }

    private static PropertyDescriptor fixPropertyDescriptor(PropertyDescriptor descriptor) throws IntrospectionException {
        Method readMethod = BeanUtil.getMethodFromBridge(descriptor.getReadMethod());
        if (readMethod != null) {
            Method writeMethod = BeanUtil.getMethodFromBridge(descriptor.getWriteMethod(), readMethod.getReturnType());
            if (writeMethod == null) {
                writeMethod = descriptor.getWriteMethod();
            }
            return new PropertyDescriptor(descriptor.getName(), readMethod, writeMethod);
        }
        return descriptor;
    }

    private static Method getMethodFromBridge(Method bridgeMethod) throws SecurityException {
        if (bridgeMethod == null) {
            return null;
        }
        return BeanUtil.getMethodFromBridge(bridgeMethod, bridgeMethod.getParameterTypes());
    }

    private static Method getMethodFromBridge(Method bridgeMethod, Class<?> ... paramTypes) throws SecurityException {
        if (bridgeMethod == null || !bridgeMethod.isBridge()) {
            return null;
        }
        try {
            return bridgeMethod.getDeclaringClass().getMethod(bridgeMethod.getName(), paramTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static class LazyValidationAvailability
    implements Serializable {
        private static final boolean BEAN_VALIDATION_AVAILABLE = LazyValidationAvailability.isAvailable();

        private LazyValidationAvailability() {
        }

        private static boolean isAvailable() {
            try {
                Class<?> clazz = Class.forName("jakarta.validation.Validation");
                Method method = clazz.getMethod("buildDefaultValidatorFactory", new Class[0]);
                method.invoke(null, new Object[0]);
                return true;
            }
            catch (ClassNotFoundException | NoSuchMethodException | InvocationTargetException e) {
                LoggerFactory.getLogger((String)"com.vaadin.validator.BeanValidator").info("A JSR-303 bean validation implementation not found on the classpath or could not be initialized. BeanValidator cannot be used.", (Throwable)e);
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Unable to invoke jakarta.validation.Validation.buildDefaultValidatorFactory()", e);
            }
        }
    }
}

