/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientRequestValue;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntermediateClientRequestControl
extends Control {
    @NotNull
    public static final String INTERMEDIATE_CLIENT_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.2";
    @NotNull
    private static final String JSON_FIELD_CLIENT_IDENTITY = "client-identity";
    @NotNull
    private static final String JSON_FIELD_CLIENT_NAME = "client-name";
    @NotNull
    private static final String JSON_FIELD_CLIENT_REQUEST_ID = "client-request-id";
    @NotNull
    private static final String JSON_FIELD_CLIENT_SESSION_ID = "client-session-id";
    @NotNull
    private static final String JSON_FIELD_DOWNSTREAM_CLIENT_ADDRESS = "downstream-client-address";
    @NotNull
    private static final String JSON_FIELD_DOWNSTREAM_CLIENT_SECURE = "downstream-client-secure";
    @NotNull
    private static final String JSON_FIELD_DOWNSTREAM_REQUEST = "downstream-request";
    private static final long serialVersionUID = 4883725840393001578L;
    @NotNull
    private final IntermediateClientRequestValue value;

    public IntermediateClientRequestControl(@Nullable IntermediateClientRequestValue downstreamRequest, @Nullable String downstreamClientAddress, @Nullable Boolean downstreamClientSecure, @Nullable String clientIdentity, @Nullable String clientName, @Nullable String clientSessionID, @Nullable String clientRequestID) {
        this(true, new IntermediateClientRequestValue(downstreamRequest, downstreamClientAddress, downstreamClientSecure, clientIdentity, clientName, clientSessionID, clientRequestID));
    }

    public IntermediateClientRequestControl(@NotNull IntermediateClientRequestValue value) {
        this(true, value);
    }

    public IntermediateClientRequestControl(boolean isCritical, @NotNull IntermediateClientRequestValue value) {
        super(INTERMEDIATE_CLIENT_REQUEST_OID, isCritical, new ASN1OctetString(value.encode().encode()));
        this.value = value;
    }

    public IntermediateClientRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Sequence valueSequence;
        ASN1OctetString controlValue = control.getValue();
        if (controlValue == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICREQ_CONTROL_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(controlValue.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICREQ_CONTROL_VALUE_NOT_SEQUENCE.get(e), e);
        }
        this.value = IntermediateClientRequestValue.decode(valueSequence);
    }

    @NotNull
    public IntermediateClientRequestValue getRequestValue() {
        return this.value;
    }

    @Nullable
    public IntermediateClientRequestValue getDownstreamRequest() {
        return this.value.getDownstreamRequest();
    }

    @Nullable
    public String getClientIdentity() {
        return this.value.getClientIdentity();
    }

    @Nullable
    public String getDownstreamClientAddress() {
        return this.value.getDownstreamClientAddress();
    }

    @Nullable
    public Boolean downstreamClientSecure() {
        return this.value.downstreamClientSecure();
    }

    @Nullable
    public String getClientName() {
        return this.value.getClientName();
    }

    @Nullable
    public String getClientSessionID() {
        return this.value.getClientSessionID();
    }

    @Nullable
    public String getClientRequestID() {
        return this.value.getClientRequestID();
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_INTERMEDIATE_CLIENT_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", INTERMEDIATE_CLIENT_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_INTERMEDIATE_CLIENT_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", IntermediateClientRequestControl.encodeRequestValueJSON(this.value)));
    }

    @NotNull
    private static JSONObject encodeRequestValueJSON(@NotNull IntermediateClientRequestValue value) {
        String clientRequestID;
        String clientSessionID;
        String clientName;
        String clientIdentity;
        Boolean downstreamClientSecure;
        String downstreamClientAddress;
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>();
        IntermediateClientRequestValue downstreamRequest = value.getDownstreamRequest();
        if (downstreamRequest != null) {
            fields.put(JSON_FIELD_DOWNSTREAM_REQUEST, IntermediateClientRequestControl.encodeRequestValueJSON(downstreamRequest));
        }
        if ((downstreamClientAddress = value.getDownstreamClientAddress()) != null) {
            fields.put(JSON_FIELD_DOWNSTREAM_CLIENT_ADDRESS, new JSONString(downstreamClientAddress));
        }
        if ((downstreamClientSecure = value.downstreamClientSecure()) != null) {
            fields.put(JSON_FIELD_DOWNSTREAM_CLIENT_SECURE, new JSONBoolean(downstreamClientSecure));
        }
        if ((clientIdentity = value.getClientIdentity()) != null) {
            fields.put(JSON_FIELD_CLIENT_IDENTITY, new JSONString(clientIdentity));
        }
        if ((clientName = value.getClientName()) != null) {
            fields.put(JSON_FIELD_CLIENT_NAME, new JSONString(clientName));
        }
        if ((clientSessionID = value.getClientSessionID()) != null) {
            fields.put(JSON_FIELD_CLIENT_SESSION_ID, new JSONString(clientSessionID));
        }
        if ((clientRequestID = value.getClientRequestID()) != null) {
            fields.put(JSON_FIELD_CLIENT_REQUEST_ID, new JSONString(clientRequestID));
        }
        return new JSONObject(fields);
    }

    @NotNull
    public static IntermediateClientRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new IntermediateClientRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        IntermediateClientRequestValue value = IntermediateClientRequestControl.decodeIntermediateClientRequestValueJSON(controlObject, jsonControl.getValueObject(), false, strict);
        return new IntermediateClientRequestControl(jsonControl.getCriticality(), value);
    }

    @NotNull
    private static IntermediateClientRequestValue decodeIntermediateClientRequestValueJSON(@NotNull JSONObject controlObject, @NotNull JSONObject valueObject, boolean isDownstreamRequest, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONObject downstreamRequestObject = valueObject.getFieldAsObject(JSON_FIELD_DOWNSTREAM_REQUEST);
        IntermediateClientRequestValue downstreamRequest = downstreamRequestObject == null ? null : IntermediateClientRequestControl.decodeIntermediateClientRequestValueJSON(controlObject, downstreamRequestObject, true, strict);
        String downstreamClientAddress = valueObject.getFieldAsString(JSON_FIELD_DOWNSTREAM_CLIENT_ADDRESS);
        Boolean downstreamClientSecure = valueObject.getFieldAsBoolean(JSON_FIELD_DOWNSTREAM_CLIENT_SECURE);
        String clientIdentity = valueObject.getFieldAsString(JSON_FIELD_CLIENT_IDENTITY);
        String clientName = valueObject.getFieldAsString(JSON_FIELD_CLIENT_NAME);
        String clientSessionID = valueObject.getFieldAsString(JSON_FIELD_CLIENT_SESSION_ID);
        String clientRequestID = valueObject.getFieldAsString(JSON_FIELD_CLIENT_REQUEST_ID);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_DOWNSTREAM_REQUEST, JSON_FIELD_DOWNSTREAM_CLIENT_ADDRESS, JSON_FIELD_DOWNSTREAM_CLIENT_SECURE, JSON_FIELD_CLIENT_IDENTITY, JSON_FIELD_CLIENT_NAME, JSON_FIELD_CLIENT_SESSION_ID, JSON_FIELD_CLIENT_REQUEST_ID)).isEmpty()) {
            if (isDownstreamRequest) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INTERMEDIATE_CLIENT_REQUEST_JSON_DS_VALUE_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INTERMEDIATE_CLIENT_REQUEST_JSON_VALUE_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new IntermediateClientRequestValue(downstreamRequest, downstreamClientAddress, downstreamClientSecure, clientIdentity, clientName, clientSessionID, clientRequestID);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("IntermediateClientRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", value=");
        this.value.toString(buffer);
        buffer.append(')');
    }
}

