/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.paranamer.generator;

import com.thoughtworks.paranamer.generator.Enhancer;
import com.thoughtworks.paranamer.generator.ParanamerGenerator;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QdoxParanamerGenerator
implements ParanamerGenerator {
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String COMMA = ",";

    @Override
    public void processSourcePath(String sourcePath, String outputPath) throws IOException {
        List<JavaClass> classes = this.getClassesSortedByName(sourcePath);
        this.processClasses(classes, outputPath);
    }

    private List<JavaClass> getClassesSortedByName(String sourcePath) {
        JavaProjectBuilder builder = new JavaProjectBuilder();
        builder.addSourceTree(new File(sourcePath));
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>(builder.getClasses());
        Collections.sort(classes, new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass o1, JavaClass o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return classes;
    }

    public void processClasses(Collection<JavaClass> classes, String outputPath) throws IOException {
        for (JavaClass javaClass : classes) {
            StringBuilder content = new StringBuilder();
            content.append(this.addConstructors(javaClass.getConstructors()));
            content.append(this.addMethods(javaClass.getMethods()));
            this.makeEnhancer().enhance(new File(outputPath, javaClass.getFullyQualifiedName().replace('.', File.separatorChar) + ".class"), content);
        }
    }

    public Enhancer makeEnhancer() {
        return new Enhancer();
    }

    private String addConstructors(List<JavaConstructor> methods) {
        StringBuilder buffer = new StringBuilder();
        for (JavaConstructor javaConstructor : methods) {
            if (javaConstructor.isPrivate() || javaConstructor.getParameters().size() <= 0) continue;
            buffer.append(this.addConstructor(javaConstructor));
        }
        return buffer.toString();
    }

    private String addMethods(List<JavaMethod> methods) {
        Collections.sort(methods, new Comparator<JavaMethod>(){

            @Override
            public int compare(JavaMethod o1, JavaMethod o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuilder buffer = new StringBuilder();
        for (JavaMethod javaMethod : methods) {
            if (javaMethod.isPrivate() || javaMethod.getParameters().size() <= 0) continue;
            buffer.append(this.addMethod(javaMethod));
        }
        return buffer.toString();
    }

    private CharSequence addConstructor(JavaConstructor constructor) {
        List parameters = constructor.getParameters();
        return this.format(constructor.getName(), parameters, true);
    }

    private CharSequence addMethod(JavaMethod method) {
        List parameters = method.getParameters();
        return this.format(method.getName(), parameters, false);
    }

    private CharSequence format(String name, List<JavaParameter> parameters, boolean isConstructor) {
        StringBuilder sb = new StringBuilder();
        String methodName = name;
        if (isConstructor) {
            methodName = "<init>";
        }
        String parameterTypes = this.getParameterTypes(parameters);
        sb.append(this.formatLine(methodName, parameterTypes, this.getParameterNames(parameters)));
        return sb;
    }

    private CharSequence formatLine(String methodName, String paramTypes, String paramNames) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append(SPACE);
        if (paramTypes.length() > 0) {
            sb.append(paramTypes.trim()).append(SPACE);
            sb.append(paramNames.trim()).append(SPACE);
        }
        sb.append(NEWLINE);
        return sb;
    }

    private String getParameterNames(List<JavaParameter> parameters) {
        StringBuilder sb = new StringBuilder();
        Iterator<JavaParameter> paramIter = parameters.iterator();
        while (paramIter.hasNext()) {
            JavaParameter param = paramIter.next();
            sb.append(param.getName());
            if (!paramIter.hasNext()) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    private String getParameterTypes(List<JavaParameter> parameters) {
        StringBuilder sb = new StringBuilder();
        Iterator<JavaParameter> paramIter = parameters.iterator();
        while (paramIter.hasNext()) {
            JavaParameter param = paramIter.next();
            sb.append(param.getType().getCanonicalName());
            if (!paramIter.hasNext()) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }
}

