/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc.maven2;

import com.sun.tools.jxc.SchemaGenTask;
import com.sun.tools.jxc.maven2.Schema;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class SchemaGenAdapter
extends SchemaGenTask {
    Log log;
    private String[] includePatterns = null;
    private String[] excludePatterns = null;

    public SchemaGenAdapter(Log log) {
        this.log = log;
        this.setProject(new Project());
    }

    public void setSrcdir(File srcdir) {
        this.setSrcdir(new Path(this.getProject(), srcdir.getAbsolutePath()));
    }

    public void setIncludeExclude(String[] includePatterns, String[] excludePatterns) {
        this.includePatterns = includePatterns;
        this.excludePatterns = excludePatterns;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        Path src = this.getSrcdir();
        String[] list = src.list();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            if (this.includePatterns != null) {
                ds.setIncludes(this.includePatterns);
            }
            if (this.excludePatterns != null) {
                ds.setExcludes(this.excludePatterns);
            }
            ds.scan();
            String[] files = ds.getIncludedFiles();
            File destDir = this.getDestdir();
            this.scanDir(srcDir, destDir != null ? destDir : srcDir, files);
        }
        this.compile();
    }

    public void addSchemas(Schema[] schemas) throws MojoExecutionException {
        if (schemas == null) {
            return;
        }
        for (int i = 0; i < schemas.length; ++i) {
            if (schemas[i].getNamespace() != null && schemas[i].getFile() != null) continue;
            throw new MojoExecutionException("Invalid schema definition in pom file. Neither namespace nor file elements may be unset.\nschema: " + i + "\t namespace = " + schemas[i].getNamespace() + "\tfile = " + schemas[i].getFile());
        }
        for (Schema s : schemas) {
            SchemaGenTask.Schema tmpS = null;
            if (s.getNamespace() != null) {
                tmpS = this.createSchema();
                tmpS.setNamespace(s.getNamespace());
            }
            if (s.getFile() == null) continue;
            if (tmpS == null) {
                tmpS = this.createSchema();
            }
            tmpS.setFile(s.getFile());
        }
    }

    public void log(String message, int logType) {
        switch (logType) {
            case 1: {
                this.log.warn((CharSequence)message);
                break;
            }
            case 0: {
                this.log.error((CharSequence)message);
                break;
            }
            case 4: {
                this.log.debug((CharSequence)message);
                break;
            }
            default: {
                this.log.info((CharSequence)message);
            }
        }
    }
}

