/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageQueue;
import com.sun.messaging.jmq.jmsclient.PriorityQueue;
import com.sun.messaging.jmq.jmsclient.SequentialQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

class SessionQueue
implements Traceable {
    private MessageQueue queue = null;
    protected boolean isLocked = false;
    private boolean sessionIsStopped = false;
    protected boolean isClosed = false;
    protected boolean listenerIsSetLate = false;
    protected boolean debug = Debug.debug;
    private long constructTime = 0L;
    private static String USE_SEQUENTIAL = System.getProperty("imq.useSequentialQueue");

    protected synchronized void enqueueNotify(Object object) {
        this.enqueue(object);
        this.notifyAll();
    }

    public SessionQueue() {
        this.queue = USE_SEQUENTIAL == null ? new PriorityQueue() : new SequentialQueue();
    }

    public SessionQueue(boolean bl, int n) {
        this.queue = bl ? new SequentialQueue(n) : new PriorityQueue();
    }

    protected synchronized void validateQueue() {
        if (this.constructTime == 0L) {
            this.constructTime = System.currentTimeMillis();
        }
        if (this.queue == null) {
            long l = System.currentTimeMillis() - this.constructTime;
            throw new Error("JVM Error. Message Queue is null. Create time: " + this.constructTime + " duration: " + l);
        }
    }

    protected int size() {
        return this.queue.size();
    }

    protected boolean isEmpty() {
        if (this.queue == null) {
            this.validateQueue();
        }
        return this.queue.isEmpty();
    }

    protected void clear() {
        this.queue.clear();
    }

    protected Object[] toArray() {
        return this.queue.toArray();
    }

    protected boolean remove(Object object) {
        return this.queue.remove(object);
    }

    protected void enqueue(Object object) {
        this.queue.enqueue(object);
        if (this.debug) {
            Debug.println(this);
        }
    }

    protected Object dequeue() {
        Object object = null;
        if (!this.queue.isEmpty()) {
            object = this.queue.dequeue();
        }
        if (this.debug) {
            Debug.println(this);
        }
        return object;
    }

    protected synchronized Object dequeueWait(long l) {
        while (this.isEmpty() || this.isLocked) {
            if (this.isClosed) {
                return null;
            }
            if (this.isLocked) {
                this.setSessionIsStopped(true);
            }
            if (this.listenerIsSetLate) {
                return null;
            }
            try {
                this.wait(l);
                if (!this.isEmpty() || this.isLocked || l <= 0L) continue;
                return null;
            }
            catch (InterruptedException interruptedException) {
                Debug.printStackTrace(interruptedException);
            }
        }
        return this.dequeue();
    }

    protected synchronized Object dequeueWait() {
        return this.dequeueWait(0L);
    }

    protected synchronized void setIsLocked(boolean bl) {
        this.isLocked = bl;
        this.notifyAll();
    }

    protected synchronized boolean getIsLocked() {
        return this.isLocked;
    }

    protected synchronized void setSessionIsStopped(boolean bl) {
        if (this.debug) {
            Debug.println("session reader is stopped: " + bl);
        }
        this.sessionIsStopped = bl;
        this.notifyAll();
    }

    protected synchronized void waitUntilSessionStopped() {
        try {
            while (!this.isClosed && this.isLocked && !this.sessionIsStopped) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void stop(boolean bl) {
        this.setIsLocked(true);
        if (bl) {
            this.waitUntilSessionStopped();
        } else {
            this.sessionIsStopped = true;
        }
    }

    protected synchronized void start() {
        this.setIsLocked(false);
        this.setSessionIsStopped(false);
    }

    protected synchronized void close() {
        this.isClosed = true;
        this.setIsLocked(false);
        if (this.debug) {
            Debug.println("Session queue closed ...");
        }
    }

    protected boolean getIsClosed() {
        return this.isClosed;
    }

    public String toString() {
        StringBuffer stringBuffer = null;
        int n = 0;
        stringBuffer = new StringBuffer(this.getClass().getName() + ": \n");
        Object[] objectArray = this.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            Object object = objectArray[n];
            stringBuffer.append("Element " + n + " :" + object.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    protected synchronized void setListenerLateNotify() {
        this.listenerIsSetLate = true;
        this.notifyAll();
    }

    protected synchronized void setListenerLate(boolean bl) {
        this.listenerIsSetLate = bl;
    }

    protected synchronized boolean isListenerSetLate() {
        return this.listenerIsSetLate;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ SessionQueue dump ------");
        printStream.println("queue size: " + this.size());
        for (Object object : this.queue.toArray()) {
            if (object instanceof ReadWritePacket) {
                ((ReadWritePacket)object).dump(printStream);
                continue;
            }
            if (object == null || !(object instanceof Traceable)) continue;
            ((Traceable)object).dump(printStream);
        }
    }

    protected Hashtable getDebugState(boolean bl) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("isLocked", this.isLocked);
        hashtable.put("sessionIsStopped", this.sessionIsStopped);
        hashtable.put("isClosed", this.isClosed);
        hashtable.put("listenerIsSetLate", this.listenerIsSetLate);
        hashtable.put("constructTime", this.constructTime);
        hashtable.put("queueSize", this.queue.size());
        if (bl) {
            Vector<String> vector = new Vector<String>();
            Object[] objectArray = this.queue.toArray();
            int n = objectArray.length;
            Object object = null;
            for (int i = 0; i < n; ++i) {
                object = objectArray[i];
                if (object instanceof ReadOnlyPacket) {
                    vector.add(((ReadOnlyPacket)object).getMessageID());
                    continue;
                }
                vector.add(object.toString());
            }
            hashtable.put("queue", vector);
        }
        return hashtable;
    }
}

