/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.oauth.client.RequestUtil;
import com.sun.jersey.oauth.signature.OAuthRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestWrapper
implements OAuthRequest {
    private final ClientRequest clientRequest;
    private final Providers providers;
    private MultivaluedMap<String, String> parameters = null;

    private void setParameters() {
        this.parameters = new MultivaluedMapImpl();
        this.parameters.putAll(RequestUtil.getQueryParameters(this.clientRequest));
        this.parameters.putAll(RequestUtil.getEntityParameters(this.clientRequest, this.providers));
    }

    public RequestWrapper(ClientRequest clientRequest, Providers providers) {
        this.clientRequest = clientRequest;
        this.providers = providers;
        this.setParameters();
    }

    public String getRequestMethod() {
        return this.clientRequest.getMethod();
    }

    public String getRequestURL() {
        URI uri = this.clientRequest.getURI();
        return uri.getScheme() + "://" + uri.getAuthority() + uri.getPath();
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public List<String> getParameterValues(String name) {
        return (List)this.parameters.get((Object)name);
    }

    public List<String> getHeaderValues(String name) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object header : (List)this.clientRequest.getMetadata().get((Object)name)) {
            list.add(ClientRequest.getHeaderValue(header));
        }
        return list;
    }

    public void addHeaderValue(String name, String value) {
        this.clientRequest.getMetadata().add((Object)name, (Object)value);
    }
}

