/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.lineage;

import com.streamsets.pipeline.api.Label;
import com.streamsets.pipeline.api.lineage.LineageSpecificAttribute;
import java.util.Arrays;
import java.util.List;

public enum LineageEventType implements Label
{
    START("START", true, Arrays.asList(LineageSpecificAttribute.DESCRIPTION)),
    STOP("STOP", true, Arrays.asList(LineageSpecificAttribute.DESCRIPTION)),
    ENTITY_CREATED("ENTITY_CREATED", false, Arrays.asList(LineageSpecificAttribute.ENDPOINT_TYPE, LineageSpecificAttribute.ENTITY_NAME, LineageSpecificAttribute.DESCRIPTION)),
    ENTITY_READ("ENTITY_READ", false, Arrays.asList(LineageSpecificAttribute.ENDPOINT_TYPE, LineageSpecificAttribute.ENTITY_NAME, LineageSpecificAttribute.DESCRIPTION)),
    ENTITY_WRITTEN("ENTITY_WRITTEN", false, Arrays.asList(LineageSpecificAttribute.ENDPOINT_TYPE, LineageSpecificAttribute.ENTITY_NAME, LineageSpecificAttribute.DESCRIPTION));

    private String label;
    private boolean frameworkOnly;
    private List<LineageSpecificAttribute> specificAttributes;

    private LineageEventType(String label, boolean frameworkOnly, List<LineageSpecificAttribute> specificAttributes) {
        this.label = label;
        this.frameworkOnly = frameworkOnly;
        this.specificAttributes = specificAttributes;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isFrameworkOnly() {
        return this.frameworkOnly;
    }

    public List<LineageSpecificAttribute> getSpecificAttributes() {
        return this.specificAttributes;
    }

    public boolean isOneOf(LineageEventType ... types) {
        if (types == null) {
            return false;
        }
        for (LineageEventType t : types) {
            if (this != t) continue;
            return true;
        }
        return false;
    }
}

