/*
 * Decompiled with CFR 0.152.
 */
package com.streamsets.pipeline.api.base;

import com.streamsets.pipeline.api.ChooserValues;
import com.streamsets.pipeline.api.Label;
import com.streamsets.pipeline.api.impl.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseEnumChooserValues<T extends Enum>
implements ChooserValues {
    private String resourceBundle;
    private List<String> values;
    private List<String> labels;

    public BaseEnumChooserValues(Class<? extends Enum> klass) {
        this(klass.getEnumConstants());
    }

    public BaseEnumChooserValues(T ... enums) {
        Utils.checkNotNull(enums, "enums");
        Utils.checkArgument(enums.length > 0, "array enum cannot have zero elements");
        this.resourceBundle = enums[0].getClass().getName() + "-bundle";
        boolean isEnumWithLabels = enums[0] instanceof Label;
        this.values = new ArrayList<String>(enums.length);
        this.labels = new ArrayList<String>(enums.length);
        for (T e : enums) {
            String value = ((Enum)e).name();
            this.values.add(value);
            String label = isEnumWithLabels ? ((Label)e).getLabel() : value;
            this.labels.add(label);
        }
        this.values = Collections.unmodifiableList(this.values);
        this.labels = Collections.unmodifiableList(this.labels);
    }

    @Override
    public String getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public List<String> getLabels() {
        return this.labels;
    }
}

