//[okio](../../../index.md)/[okio](../index.md)/[ForwardingSource](index.md)

# ForwardingSource

expect abstract class [ForwardingSource](index.md)(delegate: [Source](../-source/index.md)) : [Source](../-source/index.md)actual abstract class [ForwardingSource](index.md)(val delegate: [Source](../-source/index.md#1331753033%2FMain%2F1033915053)) : [Source](../-source/index.md#1331753033%2FMain%2F1033915053)actual abstract class [ForwardingSource](index.md)(val delegate: [Source](../-source/index.md)) : [Source](../-source/index.md)

A [Source](../-source/index.md) which forwards calls to another. Useful for subclassing.

#### Inheritors

| |
|---|
| [HashingSource](../-hashing-source/index.md) |

## Constructors

| | |
|---|---|
| [ForwardingSource](-forwarding-source.md) | [common]<br>expect constructor(delegate: [Source](../-source/index.md))<br>[jvm]<br>actual constructor(delegate: [Source](../-source/index.md#1331753033%2FMain%2F1033915053))<br>[nonJvm]<br>actual constructor(delegate: [Source](../-source/index.md)) |

## Properties

| Name | Summary |
|---|---|
| [delegate](delegate.md) | [common]<br>expect val [delegate](delegate.md): [Source](../-source/index.md)<br>[Source](../-source/index.md) to which this instance is delegating.<br>[jvm, nonJvm]<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;delegate&quot;)<br>actual val [delegate](delegate.md): [Source](../-source/index.md#1331753033%2FMain%2F1033915053)<br>[nonJvm]<br>actual val [delegate](delegate.md): [Source](../-source/index.md) |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Source](../-source/index.md).[buffer](../buffer.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [cipherSource](../cipher-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[cipherSource](../cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](../-cipher-source/index.md)<br>Returns a source that uses [cipher](../cipher-source.md) to encrypt or decrypt this. |
| [close](close.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [close](close.md)()<br>[jvm, nonJvm]<br>actual open override fun [close](close.md)()<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [gzip](../gzip.md) | [jvm]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[gzip](../gzip.md)(): [GzipSource](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F1033915053) while reading. |
| [hashingSource](../hashing-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [digest](../hashing-source.md) to hash this.<br>[jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [mac](../hashing-source.md) to hash this. |
| [inflate](../inflate.md) | [jvm]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[inflate](../inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html) = Inflater()): [InflaterSource](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F1033915053) while reading. |
| [read](read.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>actual open override fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to `byteCount` bytes from this and appends them to `sink`. Returns the number of bytes read, or -1 if this source is exhausted. |
| [timeout](timeout.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>[jvm, nonJvm]<br>actual open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |
| [toString](to-string.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[jvm, nonJvm]<br>actual open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
