/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.standalonemojos;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.MonkeyTestRunner;
import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.AndroidTestRunListener;
import com.simpligility.maven.plugins.android.DeviceCallback;
import com.simpligility.maven.plugins.android.common.DeviceHelper;
import com.simpligility.maven.plugins.android.config.ConfigHandler;
import com.simpligility.maven.plugins.android.config.ConfigPojo;
import com.simpligility.maven.plugins.android.config.PullParameter;
import com.simpligility.maven.plugins.android.configuration.Monkey;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="monkey")
public class MonkeyMojo
extends AbstractAndroidMojo {
    @Parameter(property="maven.test.skip", defaultValue="false", readonly=true)
    private boolean mavenTestSkip;
    @Parameter(property="skipTests", defaultValue="false", readonly=true)
    private boolean mavenSkipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false", readonly=true)
    private boolean mavenTestFailureIgnore;
    @Parameter(property="testFailureIgnore", defaultValue="false", readonly=true)
    private boolean mavenIgnoreTestFailure;
    @ConfigPojo
    @Parameter
    private Monkey monkey;
    @Parameter(property="android.monkey.skip")
    private Boolean monkeySkip;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedSkip;
    @Parameter(property="android.monkey.eventCount")
    private Integer monkeyEventCount;
    @PullParameter(required=true, defaultValue={"1000"})
    private Integer parsedEventCount;
    @Parameter(property="android.monkey.seed")
    private Long monkeySeed;
    @PullParameter(required=false, defaultValueGetterMethod="getSeed")
    private Long parsedSeed;
    @Parameter(property="android.monkey.throttle")
    private Long monkeyThrottle;
    @PullParameter(required=false, defaultValueGetterMethod="getThrottle")
    private Long parsedThrottle;
    @Parameter(property="android.monkey.percentTouch")
    private Integer monkeyPercentTouch;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentTouch")
    private Integer parsedPercentTouch;
    @Parameter(property="android.monkey.percentMotion")
    private Integer monkeyPercentMotion;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentMotion")
    private Integer parsedPercentMotion;
    @Parameter(property="android.monkey.percentTrackball")
    private Integer monkeyPercentTrackball;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentTrackball")
    private Integer parsedPercentTrackball;
    @Parameter(property="android.monkey.percentNav")
    private Integer monkeyPercentNav;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentNav")
    private Integer parsedPercentNav;
    @Parameter(property="android.monkey.percentMajorNav")
    private Integer monkeyPercentMajorNav;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentMajorNav")
    private Integer parsedPercentMajorNav;
    @Parameter(property="android.monkey.percentSyskeys")
    private Integer monkeyPercentSyskeys;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentSyskeys")
    private Integer parsedPercentSyskeys;
    @Parameter(property="android.monkey.percentAppswitch")
    private Integer monkeyPercentAppswitch;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentAppswitch")
    private Integer parsedPercentAppswitch;
    @Parameter(property="android.monkey.percentAnyevent")
    private Integer monkeyPercentAnyEvent;
    @PullParameter(required=false, defaultValueGetterMethod="getPercentAnyevent")
    private Integer parsedPercentAnyevent;
    @Parameter(property="android.monkey.packages")
    private String[] monkeyPackages;
    @PullParameter(required=false, defaultValueGetterMethod="getPackages")
    private String[] parsedPackages;
    @Parameter(property="android.monkey.categories")
    private String[] monkeyCategories;
    @PullParameter(required=false, defaultValueGetterMethod="getCategories")
    private String[] parsedCategories;
    @Parameter(property="android.monkey.debugNoEvents")
    private Boolean monkeyDebugNoEvents;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedDebugNoEvents;
    @Parameter(property="android.monkey.Hprof")
    private Boolean monkeyHprof;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedHprof;
    @Parameter(property="android.monkey.ignoreCrashes")
    private Boolean monkeyIgnoreCrashes;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedIgnoreCrashes;
    @Parameter(property="android.monkey.IgnoreTimeouts")
    private Boolean monkeyIgnoreTimeouts;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedIgnoreTimeouts;
    @Parameter(property="android.monkey.IgnoreSecurityExceptions")
    private Boolean monkeyIgnoreSecurityExceptions;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedIgnoreSecurityExceptions;
    @Parameter(property="android.monkey.KillProcessAfterError")
    private Boolean monkeyKillProcessAfterError;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedKillProcessAfterError;
    @Parameter(property="android.monkey.MonitorNativeCrashes")
    private Boolean monkeyMonitorNativeCrashes;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedMonitorNativeCrashes;
    @Parameter(property="android.monkey.createReport")
    private Boolean monkeyCreateReport;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedCreateReport;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        if (this.isEnableIntegrationTest()) {
            this.exerciseApp();
        }
    }

    protected boolean isEnableIntegrationTest() {
        return this.parsedSkip == false && !this.mavenTestSkip && !this.mavenSkipTests;
    }

    protected boolean isIgnoreTestFailures() {
        return this.mavenIgnoreTestFailure || this.mavenTestFailureIgnore;
    }

    protected void exerciseApp() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Parsed values for Android Monkey invocation: ");
        this.getLog().debug((CharSequence)("seed:" + this.parsedSeed));
        DeviceCallback instrumentationTestExecutor = new DeviceCallback(){

            @Override
            public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
                String deviceLogLinePrefix = DeviceHelper.getDeviceLogLinePrefix(device);
                MonkeyTestRunner monkeyTestRunner = new MonkeyTestRunner(MonkeyMojo.this.parsedEventCount, device);
                monkeyTestRunner.setRunName("ui monkey tests");
                if (MonkeyMojo.this.parsedSeed != null) {
                    monkeyTestRunner.setSeed(MonkeyMojo.this.parsedSeed);
                }
                if (MonkeyMojo.this.parsedPercentTouch != null) {
                    monkeyTestRunner.setPercentTouch(MonkeyMojo.this.parsedPercentTouch.intValue());
                }
                if (MonkeyMojo.this.parsedPercentMotion != null) {
                    monkeyTestRunner.setPercentTouch(MonkeyMojo.this.parsedPercentMotion.intValue());
                }
                if (MonkeyMojo.this.parsedPercentTrackball != null) {
                    monkeyTestRunner.setPercentTrackball(MonkeyMojo.this.parsedPercentTrackball.intValue());
                }
                if (MonkeyMojo.this.parsedPercentNav != null) {
                    monkeyTestRunner.setPercentNav(MonkeyMojo.this.parsedPercentNav.intValue());
                }
                if (MonkeyMojo.this.parsedPercentMajorNav != null) {
                    monkeyTestRunner.setPercentMajorNav(MonkeyMojo.this.parsedPercentMajorNav.intValue());
                }
                if (MonkeyMojo.this.parsedPercentSyskeys != null) {
                    monkeyTestRunner.setPercentSyskeys(MonkeyMojo.this.parsedPercentSyskeys.intValue());
                }
                if (MonkeyMojo.this.parsedPercentAppswitch != null) {
                    monkeyTestRunner.setPercentAppswitch(MonkeyMojo.this.parsedPercentAppswitch.intValue());
                }
                if (MonkeyMojo.this.parsedPercentAnyevent != null) {
                    monkeyTestRunner.setPercentAnyEvent(MonkeyMojo.this.parsedPercentAnyevent);
                }
                if (MonkeyMojo.this.parsedPackages != null) {
                    monkeyTestRunner.setPackages(MonkeyMojo.this.parsedPackages);
                }
                if (MonkeyMojo.this.parsedCategories != null) {
                    monkeyTestRunner.setCategories(MonkeyMojo.this.parsedCategories);
                }
                monkeyTestRunner.setDebugNoEvents(MonkeyMojo.this.parsedDebugNoEvents);
                monkeyTestRunner.setHprof(MonkeyMojo.this.parsedHprof);
                monkeyTestRunner.setIgnoreCrashes(MonkeyMojo.this.parsedIgnoreCrashes);
                monkeyTestRunner.setIgnoreTimeouts(MonkeyMojo.this.parsedIgnoreTimeouts);
                monkeyTestRunner.setIgnoreSecurityExceptions(MonkeyMojo.this.parsedIgnoreSecurityExceptions);
                monkeyTestRunner.setKillProcessAfterError(MonkeyMojo.this.parsedKillProcessAfterError);
                monkeyTestRunner.setMonitorNativeCrash(MonkeyMojo.this.parsedMonitorNativeCrashes);
                MonkeyMojo.this.getLog().info((CharSequence)(deviceLogLinePrefix + "Running ui monkey tests"));
                try {
                    AndroidTestRunListener testRunListener = new AndroidTestRunListener(MonkeyMojo.this.project, device, MonkeyMojo.this.getLog(), MonkeyMojo.this.parsedCreateReport, false, "", "", MonkeyMojo.this.targetDirectory);
                    monkeyTestRunner.run(testRunListener);
                    if (testRunListener.hasFailuresOrErrors() && !MonkeyMojo.this.isIgnoreTestFailures()) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Tests failed on device.");
                    }
                    if (testRunListener.testRunFailed()) {
                        throw new MojoFailureException(deviceLogLinePrefix + "Test run failed to complete: " + testRunListener.getTestRunFailureCause());
                    }
                    if (testRunListener.threwException() && !MonkeyMojo.this.isIgnoreTestFailures()) {
                        throw new MojoFailureException(deviceLogLinePrefix + testRunListener.getExceptionMessages());
                    }
                }
                catch (TimeoutException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "timeout", (Exception)((Object)e));
                }
                catch (AdbCommandRejectedException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "adb command rejected", (Exception)((Object)e));
                }
                catch (ShellCommandUnresponsiveException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "shell command " + "unresponsive", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException(deviceLogLinePrefix + "IO problem", (Exception)e);
                }
            }
        };
        this.doWithDevices(instrumentationTestExecutor);
    }

    private Long getSeed() {
        return this.parsedSeed;
    }

    private Long getThrottle() {
        return this.parsedThrottle;
    }

    private Integer getPercentTouch() {
        return this.parsedPercentTouch;
    }

    private Integer getPercentMotion() {
        return this.parsedPercentMotion;
    }

    private Integer getPercentTrackball() {
        return this.parsedPercentTrackball;
    }

    private Integer getPercentNav() {
        return this.parsedPercentNav;
    }

    private Integer getPercentMajorNav() {
        return this.parsedPercentMajorNav;
    }

    private Integer getPercentSyskeys() {
        return this.parsedPercentSyskeys;
    }

    private Integer getPercentAppswitch() {
        return this.parsedPercentAppswitch;
    }

    private Integer getPercentAnyevent() {
        return this.parsedPercentAnyevent;
    }

    public String[] getPackages() {
        return this.parsedPackages;
    }

    public String[] getCategories() {
        return this.parsedCategories;
    }
}

