/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.android.ddmlib.IDevice;
import com.github.rtyley.android.screenshot.paparazzo.OnDemandScreenshotService;
import com.github.rtyley.android.screenshot.paparazzo.processors.AnimatedGifCreator;
import com.github.rtyley.android.screenshot.paparazzo.processors.ImageSaver;
import com.github.rtyley.android.screenshot.paparazzo.processors.ImageScaler;
import com.github.rtyley.android.screenshot.paparazzo.processors.ScreenshotProcessor;
import com.github.rtyley.android.screenshot.paparazzo.processors.util.Dimensions;
import com.simpligility.maven.plugins.android.DeviceCallback;
import com.simpligility.maven.plugins.android.common.DeviceHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ScreenshotServiceWrapper
implements DeviceCallback {
    private final DeviceCallback delegate;
    private final Log log;
    private final File screenshotParentDir;
    private static final int MAX_BOUNDS = 320;

    public ScreenshotServiceWrapper(DeviceCallback delegate, MavenProject project, Log log) {
        this.delegate = delegate;
        this.log = log;
        this.screenshotParentDir = new File(project.getBuild().getDirectory(), "screenshots");
        this.create(this.screenshotParentDir);
    }

    @Override
    public void doWithDevice(IDevice device) throws MojoExecutionException, MojoFailureException {
        String deviceName = DeviceHelper.getDescriptiveName(device);
        File deviceGifFile = new File(this.screenshotParentDir, deviceName + ".gif");
        File deviceScreenshotDir = new File(this.screenshotParentDir, deviceName);
        this.create(deviceScreenshotDir);
        OnDemandScreenshotService screenshotService = new OnDemandScreenshotService(device, new ScreenshotProcessor[]{new ImageSaver(deviceScreenshotDir), new ImageScaler((ScreenshotProcessor)new AnimatedGifCreator(deviceGifFile), Dimensions.square((int)320))});
        screenshotService.start();
        this.delegate.doWithDevice(device);
        screenshotService.finish();
    }

    private void create(File dir) {
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("Unable to create screenshot directory: " + this.screenshotParentDir.getAbsolutePath()), (Throwable)e);
        }
    }
}

