/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.manager;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.OLuceneIndexType;
import com.orientechnologies.lucene.collections.LuceneResultSet;
import com.orientechnologies.lucene.collections.OSpatialCompositeKey;
import com.orientechnologies.lucene.manager.OLuceneIndexManagerAbstract;
import com.orientechnologies.lucene.query.QueryContext;
import com.orientechnologies.lucene.query.SpatialQueryContext;
import com.orientechnologies.lucene.shape.OShapeFactory;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class OLuceneSpatialIndexManager
extends OLuceneIndexManagerAbstract {
    private final OShapeFactory factory;
    private SpatialContext ctx = SpatialContext.GEO;
    private SpatialStrategy strategy;

    public OLuceneSpatialIndexManager(OShapeFactory factory) {
        this.factory = factory;
        GeohashPrefixTree grid = new GeohashPrefixTree(this.ctx, 11);
        this.strategy = new RecursivePrefixTreeStrategy((SpatialPrefixTree)grid, "location");
    }

    @Override
    public IndexWriter openIndexWriter(Directory directory, ODocument metadata) throws IOException {
        Analyzer analyzer = this.getAnalyzer(metadata);
        Version version = this.getLuceneVersion(metadata);
        IndexWriterConfig iwc = new IndexWriterConfig(version, analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return new IndexWriter(directory, iwc);
    }

    @Override
    public IndexWriter createIndexWriter(Directory directory, ODocument metadata) throws IOException {
        Analyzer analyzer = this.getAnalyzer(metadata);
        Version version = this.getLuceneVersion(metadata);
        IndexWriterConfig iwc = new IndexWriterConfig(version, analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return new IndexWriter(directory, iwc);
    }

    public void init() {
    }

    public boolean contains(Object key) {
        return false;
    }

    public boolean remove(Object key) {
        return false;
    }

    public Object get(Object key) {
        try {
            if (key instanceof OSpatialCompositeKey) {
                SpatialOperation strategy;
                OSpatialCompositeKey newKey = (OSpatialCompositeKey)((Object)key);
                SpatialOperation spatialOperation = strategy = newKey.getOperation() != null ? newKey.getOperation() : SpatialOperation.Intersects;
                if (SpatialOperation.Intersects.equals(strategy)) {
                    return this.searchIntersect(newKey, newKey.getMaxDistance(), newKey.getContext());
                }
                if (SpatialOperation.IsWithin.equals(strategy)) {
                    return this.searchWithin(newKey, newKey.getContext());
                }
            } else if (key instanceof OCompositeKey) {
                return this.searchIntersect((OCompositeKey)key, 0.0, null);
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on getting entry against Lucene index", (Throwable)e, new Object[0]);
        }
        return null;
    }

    public Object searchIntersect(OCompositeKey key, double distance, OCommandContext context) throws IOException {
        double lat = (Double)OType.convert(key.getKeys().get(0), Double.class);
        double lng = (Double)OType.convert(key.getKeys().get(1), Double.class);
        SpatialOperation operation = SpatialOperation.Intersects;
        Point p = this.ctx.makePoint(lng, lat);
        SpatialArgs args = new SpatialArgs(operation, (Shape)this.ctx.makeCircle(lng, lat, DistanceUtils.dist2Degrees((double)distance, (double)6371.0087714)));
        Filter filter = this.strategy.makeFilter(args);
        IndexSearcher searcher = this.getSearcher();
        ValueSource valueSource = this.strategy.makeDistanceValueSource(p);
        Sort distSort = new Sort(valueSource.getSortField(false)).rewrite(searcher);
        return new LuceneResultSet(this, new SpatialQueryContext(context, searcher, (Query)new MatchAllDocsQuery(), filter, distSort).setSpatialArgs(args));
    }

    @Override
    public void onRecordAddedToResultSet(QueryContext queryContext, OContextualRecordId recordId, Document doc, ScoreDoc score) {
        SpatialQueryContext spatialContext = (SpatialQueryContext)queryContext;
        if (spatialContext.spatialArgs != null) {
            Point docPoint = (Point)this.ctx.readShape(doc.get(this.strategy.getFieldName()));
            double docDistDEG = this.ctx.getDistCalc().distance(spatialContext.spatialArgs.getShape().getCenter(), docPoint);
            final double docDistInKM = DistanceUtils.degrees2Dist((double)docDistDEG, (double)6378.137);
            recordId.setContext((Map)new HashMap<String, Object>(){
                {
                    this.put("distance", docDistInKM);
                }
            });
        }
    }

    @Override
    public Document buildDocument(Object key, OIdentifiable value) {
        return null;
    }

    @Override
    public Query buildQuery(Object query) {
        return null;
    }

    @Override
    public Analyzer analyzer(String field) {
        return null;
    }

    public Object searchWithin(OSpatialCompositeKey key, OCommandContext context) throws IOException {
        HashSet result = new HashSet();
        Shape shape = this.factory.makeShape(key, this.ctx);
        if (shape == null) {
            return null;
        }
        SpatialArgs args = new SpatialArgs(SpatialOperation.IsWithin, shape);
        IndexSearcher searcher = this.getSearcher();
        Filter filter = this.strategy.makeFilter(args);
        return new LuceneResultSet(this, new SpatialQueryContext(context, searcher, (Query)new MatchAllDocsQuery(), filter));
    }

    public void put(Object key, Object value) {
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (key instanceof OCompositeKey) {
            // empty if block
        }
        Set container = (Set)value;
        for (OIdentifiable oIdentifiable : container) {
            this.addDocument(this.newGeoDocument(oIdentifiable, this.factory.makeShape(compositeKey, this.ctx)));
        }
    }

    public Object getFirstKey() {
        return null;
    }

    public Object getLastKey() {
        return null;
    }

    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        return null;
    }

    public OIndexKeyCursor keyCursor() {
        return null;
    }

    public boolean hasRangeQuerySupport() {
        return false;
    }

    private Document newGeoDocument(OIdentifiable oIdentifiable, Shape shape) {
        FieldType ft = new FieldType();
        ft.setIndexed(true);
        ft.setStored(true);
        Document doc = new Document();
        doc.add((IndexableField)OLuceneIndexType.createField("RID", oIdentifiable.getIdentity().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        for (Field f : this.strategy.createIndexableFields(shape)) {
            doc.add((IndexableField)f);
        }
        doc.add((IndexableField)new StoredField(this.strategy.getFieldName(), this.ctx.toString(shape)));
        return doc;
    }
}

