/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.lucene.LuceneTxOperations;
import com.orientechnologies.lucene.OLuceneIndex;
import com.orientechnologies.lucene.OLuceneIndexEngine;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.IndexSearcher;

public class OLuceneIndexNotUnique
extends OIndexNotUnique
implements OLuceneIndex {
    public OLuceneIndexNotUnique(String name, String typeId, String algorithm, OLuceneIndexEngine engine, String valueContainerAlgorithm, ODocument metadata, OStorage storage) {
        super(name, typeId, algorithm, (OIndexEngine)engine, valueContainerAlgorithm, metadata, storage);
        engine.setIndexMetadata(metadata);
    }

    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        OLuceneIndexEngine engine = (OLuceneIndexEngine)this.indexEngine;
        engine.setManagedIndex((OIndex)this);
        engine.setIndexName(name);
        return super.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexMultiValues put(Object key, OIdentifiable iSingleValue) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            this.checkForKeyType(key);
            HashSet<OIdentifiable> values = new HashSet<OIdentifiable>();
            values.add(iSingleValue);
            this.indexEngine.put(key, values);
            OLuceneIndexNotUnique oLuceneIndexNotUnique = this;
            return oLuceneIndexNotUnique;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    protected void commitSnapshot(Map<Object, Object> snapshot) {
        LuceneTxOperations operations;
        Object key;
        for (Map.Entry<Object, Object> snapshotEntry : snapshot.entrySet()) {
            key = snapshotEntry.getKey();
            operations = (LuceneTxOperations)snapshotEntry.getValue();
            this.checkForKeyType(key);
            for (OIdentifiable oIdentifiable : operations.removed) {
                ((OLuceneIndexEngine)this.indexEngine).remove(key, oIdentifiable);
            }
        }
        for (Map.Entry<Object, Object> snapshotEntry : snapshot.entrySet()) {
            key = snapshotEntry.getKey();
            operations = (LuceneTxOperations)snapshotEntry.getValue();
            this.checkForKeyType(key);
            this.indexEngine.put(key, operations.added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OIdentifiable> get(Object key) {
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            Set values = (Set)this.indexEngine.get(key);
            if (values == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            Set set = values;
            return set;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        LuceneTxOperations operations = (LuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new LuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.removed.add((OIdentifiable)value.getIdentity());
        snapshot.put(key, operations);
    }

    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        LuceneTxOperations operations = (LuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new LuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.added.add((OIdentifiable)value.getIdentity());
        snapshot.put(key, operations);
    }

    protected void clearSnapshot(OIndexAbstract.IndexTxSnapshot indexTxSnapshot) {
        indexTxSnapshot.clear = true;
        indexTxSnapshot.indexSnapshot.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object key, OIdentifiable value) {
        key = this.getCollatingValue(key);
        this.acquireExclusiveLock();
        try {
            if (this.indexEngine instanceof OLuceneIndexEngine) {
                boolean bl = ((OLuceneIndexEngine)this.indexEngine).remove(key, value);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public long rebuild(OProgressListener iProgressListener) {
        OLuceneIndexEngine engine = (OLuceneIndexEngine)this.indexEngine;
        try {
            engine.setRebuilding(true);
            super.rebuild(iProgressListener);
        }
        finally {
            engine.setRebuilding(false);
        }
        engine.flush();
        return ((OLuceneIndexEngine)this.indexEngine).size(null);
    }

    public Object getCollatingValue(Object key) {
        return key;
    }

    @Override
    public IndexSearcher searcher() throws IOException {
        return ((OLuceneIndexEngine)this.indexEngine).searcher();
    }

    protected OLuceneIndexEngine getIndexEngine() {
        return (OLuceneIndexEngine)this.indexEngine;
    }

    public boolean canBeUsedInEqualityOperators() {
        return false;
    }
}

