/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.collections;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.manager.OLuceneIndexManagerAbstract;
import com.orientechnologies.lucene.query.QueryContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class LuceneResultSet
implements Set<OIdentifiable> {
    private TopDocs topDocs;
    private Query query;
    private OLuceneIndexManagerAbstract manager;
    private QueryContext queryContext;
    private static Integer PAGE_SIZE = 50;

    public LuceneResultSet(OLuceneIndexManagerAbstract manager, QueryContext queryContext) {
        this.manager = manager;
        this.queryContext = queryContext;
        this.query = queryContext.query;
        this.fetchFirstBatch();
        this.fetchFacet();
    }

    private void fetchFacet() {
        if (this.queryContext.facet) {
            FacetsCollector facetsCollector = new FacetsCollector(true);
            try {
                String[] pathFacet = null;
                if (this.queryContext.isDrillDown()) {
                    DrillDownQuery drillDownQuery = new DrillDownQuery(this.queryContext.getFacetConfig(), this.query);
                    String[] path = this.queryContext.getDrillDownQuery().split(":");
                    pathFacet = path[1].split("/");
                    drillDownQuery.add(path[0], pathFacet);
                    FacetsCollector.search((IndexSearcher)this.queryContext.searcher, (Query)drillDownQuery, (int)PAGE_SIZE, (Collector)facetsCollector);
                } else {
                    FacetsCollector.search((IndexSearcher)this.queryContext.searcher, (Query)this.query, (int)PAGE_SIZE, (Collector)facetsCollector);
                }
                FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts(this.queryContext.reader, this.queryContext.getFacetConfig(), facetsCollector);
                FacetResult facetResult = null;
                facetResult = pathFacet != null ? facets.getTopChildren(PAGE_SIZE.intValue(), this.queryContext.getFacetField(), pathFacet) : facets.getTopChildren(PAGE_SIZE.intValue(), this.queryContext.getFacetField(), new String[0]);
                if (facetResult != null) {
                    ArrayList<ODocument> documents = new ArrayList<ODocument>();
                    ODocument doc = new ODocument();
                    doc.field("childCount", (Object)facetResult.childCount);
                    doc.field("value", (Object)facetResult.value);
                    doc.field("dim", (Object)facetResult.dim);
                    ArrayList<ODocument> labelsAndValue = new ArrayList<ODocument>();
                    for (LabelAndValue labelValue : facetResult.labelValues) {
                        ODocument doc1 = new ODocument();
                        doc1.field("label", (Object)labelValue.label);
                        doc1.field("value", (Object)labelValue.value);
                        labelsAndValue.add(doc1);
                    }
                    doc.field("labelsValue", labelsAndValue);
                    documents.add(doc);
                    this.queryContext.context.setVariable("$facet", documents);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int size() {
        return this.topDocs.totalHits;
    }

    private void fetchFirstBatch() {
        try {
            switch (this.queryContext.cfg) {
                case NO_FILTER_NO_SORT: {
                    this.topDocs = this.queryContext.searcher.search(this.query, PAGE_SIZE.intValue());
                    break;
                }
                case FILTER_SORT: {
                    this.topDocs = this.queryContext.searcher.search(this.query, this.queryContext.filter, PAGE_SIZE.intValue(), this.queryContext.sort);
                    break;
                }
                case FILTER: {
                    this.topDocs = this.queryContext.searcher.search(this.query, this.queryContext.filter, PAGE_SIZE.intValue());
                    break;
                }
                case SORT: {
                    this.topDocs = this.queryContext.searcher.search(this.query, PAGE_SIZE.intValue(), this.queryContext.sort);
                }
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on fetching document by query '%s' to Lucene index", (Throwable)e, new Object[]{this.query});
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new OLuceneResultSetIterator();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(OIdentifiable oIdentifiable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private class OLuceneResultSetIterator
    implements Iterator<OIdentifiable> {
        ScoreDoc[] array;
        private int index;
        private int localIndex;
        private int totalHits;

        public OLuceneResultSetIterator() {
            this.totalHits = ((LuceneResultSet)LuceneResultSet.this).topDocs.totalHits;
            this.index = 0;
            this.localIndex = 0;
            this.array = ((LuceneResultSet)LuceneResultSet.this).topDocs.scoreDocs;
            LuceneResultSet.this.manager.sendTotalHits(((LuceneResultSet)LuceneResultSet.this).queryContext.context, LuceneResultSet.this.topDocs);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.totalHits;
        }

        @Override
        public OIdentifiable next() {
            if (this.localIndex == this.array.length) {
                this.localIndex = 0;
                this.fetchMoreResult();
            }
            ScoreDoc score = this.array[this.localIndex++];
            Document ret = null;
            OContextualRecordId res = null;
            try {
                ret = ((LuceneResultSet)LuceneResultSet.this).queryContext.searcher.doc(score.doc);
                String rId = ret.get("RID");
                res = new OContextualRecordId(rId);
                LuceneResultSet.this.manager.onRecordAddedToResultSet(LuceneResultSet.this.queryContext, res, ret, score);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.index;
            return res;
        }

        private void fetchMoreResult() {
            TopDocs topDocs = null;
            try {
                switch (((LuceneResultSet)LuceneResultSet.this).queryContext.cfg) {
                    case NO_FILTER_NO_SORT: {
                        topDocs = ((LuceneResultSet)LuceneResultSet.this).queryContext.searcher.searchAfter(this.array[this.array.length - 1], LuceneResultSet.this.query, PAGE_SIZE.intValue());
                        break;
                    }
                    case FILTER_SORT: {
                        topDocs = ((LuceneResultSet)LuceneResultSet.this).queryContext.searcher.searchAfter(this.array[this.array.length - 1], LuceneResultSet.this.query, ((LuceneResultSet)LuceneResultSet.this).queryContext.filter, PAGE_SIZE.intValue(), ((LuceneResultSet)LuceneResultSet.this).queryContext.sort);
                        break;
                    }
                    case FILTER: {
                        topDocs = ((LuceneResultSet)LuceneResultSet.this).queryContext.searcher.searchAfter(this.array[this.array.length - 1], LuceneResultSet.this.query, ((LuceneResultSet)LuceneResultSet.this).queryContext.filter, PAGE_SIZE.intValue());
                        break;
                    }
                    case SORT: {
                        topDocs = ((LuceneResultSet)LuceneResultSet.this).queryContext.searcher.searchAfter(this.array[this.array.length - 1], LuceneResultSet.this.query, PAGE_SIZE.intValue(), ((LuceneResultSet)LuceneResultSet.this).queryContext.sort);
                    }
                }
                this.array = topDocs.scoreDocs;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on fetching document by query '%s' to Lucene index", (Throwable)e, new Object[]{LuceneResultSet.this.query});
            }
        }

        @Override
        public void remove() {
        }
    }
}

